<%--
  ~ Copyright (c) 2019, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
  ~
  ~ WSO2 Inc. licenses this file to you under the Apache License,
  ~ Version 2.0 (the "License"); you may not use this file except
  ~ in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~    http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing,
  ~ software distributed under the License is distributed on an
  ~ "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  ~ KIND, either express or implied.  See the License for the
  ~ specific language governing permissions and limitations
  ~ under the License.
--%>

<!-- page content -->
<div class="ui grid">
    <div class="two column row"></div>
        <div class="four wide computer four wide tablet column">
            <div id="toc" class="ui segment toc"></div>
        </div>
        <div class="twelve wide computer twelve wide tablet column">
            <!-- content -->
            <div>
                <div>
                    <h1>
                        WSO2 API Manager - Privacy Policy
                    </h1>
                </div>
                <div>
                <%-- Customizable content. Due to this nature, i18n is not implemented for this section --%>
                <div id="privacyPolicy" class="padding-double">
                    <h4><a href="https://wso2.com/api-management/"><strong>About WSO2 API Manager</strong></a></h4>
                    <p>WSO2 API Manager (referred hereafter as &ldquo;API-M &rdquo;) is an open source enterprise-class solution that supports API publishing, lifecycle management, application development, access control, rate limiting, and analytics in one cleanly integrated system.</p>
                    <div class="margin-bottom-double"></div>
                    <h2 id="privacy-policy"><strong>Privacy Policy</strong></h2>
                    <p>This section explains how API-M captures your personal information, purpose of capturing, and the retention of your personal information.</p>
                    <p>Please note that this policy is for reference only, and is applicable for the software as a product. WSO2 Inc., or its developers have no access to the information held within API-M. Please refer &ldquo;Disclaimer&rdquo; for more information.</p>
                    <p>Entities, organisations or individuals controlling the use and administration of API-M should create their own privacy policies setting out the manner in which data is controlled or processed by the respective entity, organisation or individual.</p>
                    <div class="margin-bottom-double"></div>
                    <h2 id="what-are-the-personal-information">What are the personal information &quest;</h2>
                    <p>API-M considers anything related to you as your personal information. This includes, but is not limited to,</p>
                    <ul>
                        <li>Your user name (except in the case where your user name is created by your employer under contract)</li>
                        <li>The IP address you use to login</li>
                        <li>Your device ID, if you choose to login with a device (Phone, Tablet)</li>
                    </ul>
                    <p>However API-M does not consider the following as your personal information, and  uses this only for <strong>analytical purposes</strong>, since this information cannot be used to track you.</p>
                    <ul>
                        <li>City/Country from which your TCP/IP connection originates</li>
                        <li>Time of the day you login.(Year, Month, Week, Hour or Minute)</li>
                        <li>Type of the device you use to login (Phone, Tablet, etc.)</li>
                        <li>Operating system and Generic browser information</li>
                    </ul>
                    <div class="margin-bottom-double"></div>
                    <h2 id="collection-of-your-information">Collection of your information</h2>
                    <p>API-M collects your information to only serve your access requirements.</p>
                    <p>For example,</p>
                    <ul>
                        <li>API-M uses your IP address to detect any suspicious login attempt to your account. </li>
                        <li>API-M uses your First Name, Last Name, etc to provide rich and personalized information.</li>
                    </ul>
                    <div class="margin-bottom"></div>
                    <h3 id="tracking-technologies">Tracking Technologies</h3>
                    <p>API-M collects your information through the following,</p>
                    <ul>
                        <li>The user sign up page where you enter your personal data</li>
                        <li>Tracking your IP address with HTTP request, HTTP headers, and TCP/IP</li>
                        <li>Tracking your geographic information with the IP address</li>
                        <li>Your login history with browser cookies. Please refer our <strong>cookie policy</strong> for more information</li>
                    </ul>
                    <p>API-M will also provide recommendation if the user wishes to enable that option in the feature which by default will be switched off. WSO2 shall use a randomised identifier to track the behaviour and will not have access to any personal information of the user.</p>
                    <div class="margin-bottom-double"></div>
                    <h2 id="user-of-your-personal-information">Use of your personal information</h2>
                    <p>API-M will use your personal information only for the purposes for which it was collected (or for a use identified as consistent with that purpose).</p>
                    <p>API-M uses your personal information only for the following purposes.</p>
                    <ul>
                        <li>To provide you with a personalized user experience. API-M uses attributes such as your name for this purpose</li>
                        <li>To protect your account from unauthorized access or a potential hacking attempt. API-M use HTTP or TCP/IP Headers  for this purpose</li>
                        <ul>
                            <li>This includes,</li>
                            <ul>
                                <li>IP address,</li>
                                <li>Browser fingerprinting,</li>
                                <li>Cookies</li>
                            </ul>
                        </ul>
                        <li>To derive statistical data for analytical purposes on system performance improvements. API-M will not keep any personal information after statistical calculations. Thus a statistical report has no means to identify an individual person</li>
                        <ul>
                            <li>API-M may use</li>
                            <ul>
                                <li>The IP Address to derive geographic information</li>
                                <li>Browser fingerprinting to determine the browser technology and version</li>
                            </ul>
                        </ul>
                    </ul>
                    <div class="margin-bottom-double"></div>
                    <h2 id="disclosure-of-your-personal-information">Disclosure of your personal information</h2>
                    <p>API-M will disclose personal information only for the purposes for which it was collected (or for a use identified as consistent with that purpose), unless you have consented otherwise or where it is required by law.</p>
                    <div class="margin-bottom"></div>
                    <h3 id="legal-process">Legal process</h3>
                    <p>API-M  may disclose your personal information with or without your consent where it is required by law following the due and lawful process.</p>
                    <div class="margin-bottom-double"></div>
                    <h2 id="how-apim-store-or-keep-your-personal-information">How API-M keeps your personal information</h2>
                    <div class="margin-bottom"></div>
                    <h3 id="where-your-personal-information-stored">Where your personal information is stored</h3>
                    <p>API-M stores your personal information in secured databases. API-M exercises proper industry accepted security measures to protect the database where your personal information is held.</p>
                    <p>API-M may use encryption to keep your personal data with added level of security.</p>
                    <div class="margin-bottom"></div>
                    <h3 id="how-long-does-apim-keep-your-personal-information">How long does API-M keep your personal information &quest;</h3>
                    <p>API-M keep your personal data as long as you are an active user of our system. You can update your personal data at any time with the given self-care user portals.</p>
                    <div class="margin-bottom"></div>
                    <h3 id="how-can-you-request-a-removal-of-your-personal-information">How can you request a removal of your personal information &quest;</h3>
                    <p>You can request the administrator to delete your account The administrator will be the administrator of the tenant you are registered or the super-administrator if you do not use the tenant feature.</p>
                    <p>You can additionally request to anonymize all traces of your activities that may have been retained by API-M  in Logs, Databases or Analytical storage.</p>
                    <div class="margin-bottom-double"></div>
                    <h2 id="about">About</h2>
                    <div class="margin-bottom"></div>
                    <h3 id="changes-to-this-policy">Changes to this policy</h3>
                    <p>Upgraded versions of API-M may contain changes to this policy and revisions to this policy will be packaged within such upgrades. Such changes would only apply to users who choose to use upgraded versions.</p>
                    <p>The organization running API-M may revise the Privacy Policy from time to time. You can find the most recent governing policy with the respective link provided by the organization running API-M. The organization will notify any changes to the privacy policy over our official public channels.</p>
                    <div class="margin-bottom"></div>
                    <h3 id="your-choices">Your choices</h3>
                    <p>If you already have an account with API Manager; you have the right to deactivate your account if you find that this privacy policy is unacceptable for you.</p>
                    <p>If you do not have an account, you can choose not to subscribe if you do not agree with our privacy policy.</p>
                    <div class="margin-bottom"></div>
                    <h3 id="contact-us">Contact us</h3>
                    <p>Please contact us if you have any question or concerns of this privacy policy.</p>
                    <p><a href="https://wso2.com/contact/">https://wso2.com/contact/</a></p>
                    <div class="margin-bottom-double"></div>
                    <h2 id="disclaimer">Disclaimer</h2>
                    <ol>
                        <li>This privacy policy statement serves as a template for the organization running WSO2 API-M. The organizational policies will govern the real privacy policy applicable for its business purposes.</li>
                        <li>WSO2 or its employees, partners, affiliates do not have access to any data, including privacy-related data held at the organization running API-M.</li>
                        <li>This policy should be modified according to the organizational requirements.</li>
                    </ol>
                </div>
                <%-- /Customizable content --%>
            </div>
        </div>
        <!-- /content -->
      </div>
   </div>
</div>
