<%--
  ~ Copyright (c) 2019, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
  ~
  ~ WSO2 Inc. licenses this file to you under the Apache License,
  ~ Version 2.0 (the "License"); you may not use this file except
  ~ in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~    http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing,
  ~ software distributed under the License is distributed on an
  ~ "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  ~ KIND, either express or implied.  See the License for the
  ~ specific language governing permissions and limitations
  ~ under the License.
--%>

<!-- page content -->
<div class="ui grid">
    <div class="two column row"></div>
        <div class="four wide computer four wide tablet column">
            <div id="toc" class="ui segment toc"></div>
        </div>
        <div class="twelve wide computer twelve wide tablet column">
            <!-- content -->
            <div>
                <div>
                    <h1>
                        WSO2 API Manager - Cookie Policy
                    </h1>
                </div>
                <div>
                    <%-- Customizable content. Due to this nature, i18n is not implemented for this section --%>
                    <div id="cookiePolicy">
                    	<h4><a href="https://wso2.com/api-management/"><strong>About WSO2 API Manager</strong></a></h4>
                        <p>WSO2 API Manager (referred hereafter as &ldquo;API-M &rdquo;) is an open source enterprise-class solution that supports API publishing, lifecycle management, application development, access control, rate limiting and analytics in one cleanly integrated system.</p>
                        <div class="margin-bottom-double"></div>
                        <h2 id="cookie-policy"><strong>Cookie Policy</strong></h2>
                        <p>API-M uses cookies to provide you with the best user experience, and to securely identify you. You might not be able to access some of the services if you disable cookies.</p>
                        <div class="margin-bottom-double"></div>
                        <h2 id="what-is-a-cookie">What is a cookie &quest;</h2>
                        <p>A browser cookie is a small piece of data that is stored on your device to help websites and mobile apps remember things about you. Other technologies, including Web storage and identifiers associated with your device, may be used for similar purposes. In this policy, we use the term &ldquo;cookies&rdquo; to discuss all of these technologies.</p>
                        <div class="margin-bottom-double"></div>
                        <h2 id="how-apim-process-cookies">How does API-M process cookies &quest;</h2>
                        <p>API-M uses cookies to store and retrieve information on your browser. This information is used to provide a better user experience. Some cookies have the primary purpose of allowing logging in to the system, maintaining sessions, and keeping track of activities you do within the login session.</p>
                        <p>Some cookies used in API-M are used to identify you personally. However, the cookie lifetime will end when you log-out ending your session or when your session expires.</p>
                        <p>Some cookies are simply used to give you a more personalised web experience, and these cannot be used to identify you or your activities personally.</p>
                        <p>This Cookie Policy is part of the API-M Privacy Policy.</p>
                        <div class="margin-bottom-double"></div>
                        <h2 id="what-apim-use-cookies-for">What does API-M use cookies for &quest;</h2>
                        <p>Cookies are used for two purposes in API-M</p>
                        <ol>
                           <li>Security.</li>
                           <li>Providing a  better user experience.</li>
                        </ol>
                        <div class="margin-bottom"></div>
                        <h3 id="apim-uses-cookies-for-the-following-purposes">API-M uses cookies for the following purposes</h3>
                        <h4>Preferences</h4>
                        <p>API-M uses cookies to remember your settings and preferences and to auto-fill the fields to make your interactions with the site easier.</p>
                        <ul>
                            <li>These cannot be used to identify you personally.</li>
                        </ul>
                        <h4>Security</h4>
                        <p>API-M uses selected cookies to identify and prevent security risks.</p>
                        <p>For example, API-M may use cookies to store your session information to prevent others from changing your password without your username and password.</p>
                        <p>API-M uses session cookie to maintain your active session.</p>
                        <p>API-M may use a temporary cookie when performing multi-factor authentication and federated authentication.</p>
                        <p>API-M may use permanent cookies to detect the devices you have logged in previously. This is to to calculate the <strong>risk level</strong> associated with your current login attempt. Using these cookies protects you and your account from possible attacks.</p>
                        <h4>Performance</h4>
                        <p>API-M may use cookies to allow &ldquo;Remember Me&rdquo; functionalities.</p>
                        <div class="margin-bottom"></div>
                        <h3 id="analytics">Analytics</h3>
                        <p>API-M as a product does not use cookies for analytical purposes.</p>
                        <div class="margin-bottom"></div>
                        <h3 id="third-party-cookies">Third party cookies</h3>
                        <p>Using API-M may cause some third-party cookie being set to your browser. API-M has no control over the operation of these cookies. The third-party cookies which maybe set include,</p>
                        <ul>
                            <li>Any of the social login sites, when API-M is configured to use &ldquo;Social&rdquo; or &ldquo;Federated&rdquo; login, and you opt to do login with your &ldquo;Social Account&rdquo;</li>
                            <li>Any third party federated login</li>
                        </ul>
                        <p>We strongly advise you to refer the respective cookie policies of such sites carefully as API-M has no knowledge or use on these cookies.</p>
                        <div class="margin-bottom-double"></div>
                        <h2 id="what-type-of-cookies-apim-use">What type of cookies does API-M use &quest;</h2>
                        <p>API-M uses persistent cookies and session cookies. A persistent cookie helps API-M to recognize you as an existing user, so you can easily return to WSO2 or interact with API-M without signing in again. After you sign in, a persistent cookie stays in your browser and will be read by API-M when you return.</p>
                        <p>A session cookie is erased when the user closes the Web browser. It is stored in temporarily and is not retained after the browser is closed. Session cookies do not collect information from the user's computer.</p>
                        <div class="margin-bottom-double"></div>
                        <h2 id="how-do-i-control-my-cookies">How do I control my cookies &quest;</h2>
                        <p>Most browsers allow you to control cookies through settings. However, if you limit the ability of websites to set cookies, you may worsen your overall user experience, since it will no longer be personalized to you. It may also stop you from saving customized
                           settings like login information. Disabling cookies might make you unable to use Authentication and Authorization functionalities offered by API-M.</p>
                        <p>If you have any questions or concerns regarding the use of cookies, please contact the Data Protection Officer of the organization running this API-M instance.</p>
                        <div class="margin-bottom-double"></div>
                        <h2 id="what-are-the-cookies-used">What are the cookies used &quest;</h2>
                        <table class="table table-bordered">
                            <tbody>
		                <tr>
		                    <td>
		                        <p><strong>Cookie Name</strong></p>
		                    </td>
		                    <td>
		                        <p><strong>Purpose</strong></p>
		                    </td>
		                    <td>
		                        <p><strong>Retention</strong></p>
		                    </td>
		                </tr>
		                <tr>
		                    <td>
		                        <p>JSESSIONID</p>
		                    </td>
		                    <td>
		                        <p>Keeps track of the user session data when you are logged in for providing a better user experience.</p>
		                    </td>
		                    <td>
		                        <p>Session</p>
		                    </td>
		                </tr>
		                <tr>
		                    <td>
		                        <p>goto_url</p>
		                    </td>
		                    <td>
		                        <p>Keeps track of the page that you should be directed to after login.</p>
		                    </td>
		                    <td>
		                        <p>Session</p>
		                    </td>
		                </tr>
		                <tr>
		                    <td>
		                        <p>workflowCookie</p>
		                    </td>
		                    <td>
		                        <p>Used for authentication purposes when invoking an admin service in the Business Process Server.</p>
		                    </td>
		                    <td>
		                        <p>Session</p>
		                    </td>
		                </tr>
		                <tr>
		                    <td>
		                        <p>csrftoken</p>
		                    </td>
		                    <td>
		                        <p>Used for mitigating Cross Site Request Forgery Attacks to provide you with a secure service.</p>
		                    </td>
		                    <td>
		                        <p>Request</p>
		                    </td>
		                </tr>
		                <tr>
		                    <td>
		                        <p>i18next</p>
		                    </td>
		                    <td>
		                        <p>Used to track the language API-M is served to you.</p>
		                    </td>
		                    <td>
		                        <p>Session</p>
		                    </td>
		                </tr>
		           </tbody>
                    </table>

                    <h2 id="disclaimer">Disclaimer</h2>
                    <p>This cookie policy is only for illustrative purposes of the API-M product. The content in this policy is technically correct at the time of product shipment.
                      The organization which runs this API-M instance has the full authority and responsibility of the effective Cookie Policy.</p>
                    <p>WSO2, its employees, partners, and affiliates do not have access to and do not require, store, process or control any of the data,
                    including personal data contained in WSO2 API-M. All data, including personal data is controlled and processed by the entity or individual
                    running WSO2 API-M. WSO2, its employees partners and affiliates are not a data processor or a data controller within the meaning of any data privacy
                    regulations. WSO2 does not provide any warranties or undertake any responsibility or liability in connection with the lawfulness or the manner and purposes for
                    which WSO2 API-M is used by such entities or persons.</p>
                </div>
                <%-- /Customizable content --%>
            </div>
        </div>
        <!-- /content -->
    </div>
  </div>
</div>
