CREATE SEQUENCE IDN_OAUTH_CONSUMER_APPS_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_ODF_SCOPES_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_OAUTH2_SCOPE_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE AM_SCOPE_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_SCIM_GROUP_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_STS_STORE_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_APP_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_METADATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_INBOUND_AUTH_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_AUTH_STEP_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_CLAIM_DIALECT_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_CLAIM_MAPPING_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_ROLE_MAPPING_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_REQ_PATH_AUTH_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_PROV_CONNECTOR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_AUTH_SCRIPT_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE SP_TEMPLATE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_AUTH_WAIT_STATUS_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_ROLE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_ROLE_MAPPING_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_CLAIM_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_CLAIM_MAPPING_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_AUTHENTICATOR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_METADATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_AUTHENTICATOR_PROP_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_PROVISIONING_CONFIG_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_PROV_CONFIG_PROP_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_PROV_ENTITY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDP_LOCAL_CLAIM_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_ASSOCIATED_ID_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE WF_WORKFLOW_ASSOCIATION_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_PASSWORD_HISTORY_DATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_CLAIM_DIALECT_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_CLAIM_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_CLAIM_MAPPED_ATTRIBUTE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_CLAIM_PROPERTY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_CLAIM_MAPPING_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_SAML2_ASSERTION_STORE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_SAML2_ARTIFACT_STORE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_OIDC_PROPERTY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_OIDC_REQ_OBJECT_REF_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_OIDC_REQ_OBJ_CLAIMS_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_OIDC_REQ_OBJ_CLM_VAL_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_CERTIFICATE_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_OIDC_SCOPE_CLAIM_MAP_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_UMA_RESOURCE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_UMA_RESOURCE_META_DATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_UMA_RESOURCE_SCOPE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_UMA_PERMISSION_TICKET_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_UMA_PT_RESOURCE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE IDN_UMA_PT_RESOURCE_SCOPE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE CM_PII_CATEGORY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE CM_PURPOSE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE CM_PURPOSE_CATEGORY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE CM_RECEIPT_SP_ASSOC_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE CM_SP_PURPOSE_ASSOC_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE AM_SUBSCRIBER_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_APPLICATION_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_API_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_API_URL_MAPPING_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_API_PRODUCT_MAPPING_SEQ START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_SUBSCRIPTION_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_API_RATINGS_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_TIER_PERMISSIONS_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_API_LC_EVENT_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_APP_REGISTRATION_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_WORKFLOWS_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_EXTERNAL_STORES_SEQUENCE START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_API_DEFAULT_VERSION_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE AM_ALERT_TYPES_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE AM_ALERT_EMAILLIST_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE AM_POLICY_SUBSCRIPTION_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_POLICY_APPLICATION_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_API_THROTTLE_POLICY_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_CONDITION_GROUP_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE QUERY_PARAMETER_CONDITION_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_HEADER_FIELD_CONDITION_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_JWT_CLAIM_CONDITION_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_IP_CONDITION_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_POLICY_GLOBAL_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE THROTTLE_TIER_PERMISSIONS_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_BLOCK_CONDITIONS_seq START WITH 1 INCREMENT BY 1
/
CREATE SEQUENCE AM_SYSTEM_APPS_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE SEQUENCE AM_API_LC_PUBLISH_EVENTS_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/

CREATE OR REPLACE TRIGGER IDN_OAUTH_CONSUMER_APPS_TRIG
            BEFORE INSERT
            ON IDN_OAUTH_CONSUMER_APPS
            REFERENCING NEW AS NEW
            FOR EACH ROW
              BEGIN
                SELECT IDN_OAUTH_CONSUMER_APPS_SEQ.nextval INTO :NEW.ID FROM dual;
              END;
/
CREATE OR REPLACE TRIGGER IDN_ODF_SCOPES_TRIG
            BEFORE INSERT
            ON IDN_OAUTH2_DEVICE_FLOW_SCOPES
            REFERENCING NEW AS NEW
            FOR EACH ROW
              BEGIN
                SELECT IDN_ODF_SCOPES_SEQ.nextval INTO :NEW.ID FROM dual;
              END;
/
CREATE OR REPLACE TRIGGER IDN_OAUTH2_SCOPE_TRIGGER
		    BEFORE INSERT
            ON IDN_OAUTH2_SCOPE
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT IDN_OAUTH2_SCOPE_SEQUENCE.nextval INTO :NEW.SCOPE_ID FROM dual;
            END;
/
CREATE OR REPLACE TRIGGER AM_SCOPE_TRIGGER
		    BEFORE INSERT
            ON AM_SCOPE
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT AM_SCOPE_SEQUENCE.nextval INTO :NEW.SCOPE_ID FROM dual;
            END;
/
CREATE OR REPLACE TRIGGER IDN_SCIM_GROUP_TRIGGER
		    BEFORE INSERT
            ON IDN_SCIM_GROUP
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT IDN_SCIM_GROUP_SEQUENCE.nextval INTO :NEW.ID FROM dual;
            END;
/
CREATE OR REPLACE TRIGGER IDN_STS_STORE_TRIGGER
		    BEFORE INSERT
            ON IDN_STS_STORE
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT IDN_STS_STORE_SEQUENCE.nextval INTO :NEW.ID FROM dual;
            END;
/
CREATE OR REPLACE TRIGGER SP_APP_TRIG
            BEFORE INSERT
            ON SP_APP
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT SP_APP_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER SP_METADATA_TRIG
            BEFORE INSERT
            ON SP_METADATA
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT SP_METADATA_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER SP_INBOUND_AUTH_TRIG
            BEFORE INSERT
            ON SP_INBOUND_AUTH
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT SP_INBOUND_AUTH_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER SP_AUTH_STEP_TRIG
            BEFORE INSERT
            ON SP_AUTH_STEP
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT SP_AUTH_STEP_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER SP_CLAIM_DIALECT_SEQ
            BEFORE INSERT
            ON SP_CLAIM_DIALECT
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT SP_CLAIM_DIALECT_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER SP_CLAIM_MAPPING_TRIG
            BEFORE INSERT
            ON SP_CLAIM_MAPPING
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT SP_CLAIM_MAPPING_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER SP_ROLE_MAPPING_TRIG
            BEFORE INSERT
            ON SP_ROLE_MAPPING
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT SP_ROLE_MAPPING_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER SP_REQ_PATH_AUTH_TRIG
            BEFORE INSERT
            ON SP_REQ_PATH_AUTHENTICATOR
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT SP_REQ_PATH_AUTH_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER SP_PROV_CONNECTOR_TRIG
            BEFORE INSERT
            ON SP_PROVISIONING_CONNECTOR
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT SP_PROV_CONNECTOR_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER SP_AUTH_SCRIPT_TRIG
  BEFORE INSERT
  ON SP_AUTH_SCRIPT
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT SP_AUTH_SCRIPT_SEQ.nextval
    INTO :NEW.ID
    FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER SP_TEMPLATE_TRIG
  BEFORE INSERT
  ON SP_TEMPLATE
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT SP_TEMPLATE_SEQ.nextval
    INTO :NEW.ID
    FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER IDN_AUTH_WAIT_STATUS_TRIG
  BEFORE INSERT
  ON IDN_AUTH_WAIT_STATUS
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT IDN_AUTH_WAIT_STATUS_SEQ.nextval
    INTO :NEW.ID
    FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER IDP_TRIG
            BEFORE INSERT
            ON IDP
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_ROLE_TRIG
            BEFORE INSERT
            ON IDP_ROLE
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_ROLE_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_ROLE_MAPPING_TRIG
            BEFORE INSERT
            ON IDP_ROLE_MAPPING
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_ROLE_MAPPING_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_CLAIM_TRIG
            BEFORE INSERT
            ON IDP_CLAIM
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_CLAIM_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_CLAIM_MAPPING_TRIG
            BEFORE INSERT
            ON IDP_CLAIM_MAPPING
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_CLAIM_MAPPING_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_AUTHENTICATOR_TRIG
            BEFORE INSERT
            ON IDP_AUTHENTICATOR
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_AUTHENTICATOR_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_METADATA_TRIG
            BEFORE INSERT
            ON IDP_METADATA
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_METADATA_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_AUTHENTICATOR_PROP_TRIG
            BEFORE INSERT
            ON IDP_AUTHENTICATOR_PROPERTY
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_AUTHENTICATOR_PROP_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_PROVISIONING_CONFIG_TRIG
            BEFORE INSERT
            ON IDP_PROVISIONING_CONFIG
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_PROVISIONING_CONFIG_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_PROV_CONFIG_PROP_TRIG
            BEFORE INSERT
            ON IDP_PROV_CONFIG_PROPERTY
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_PROV_CONFIG_PROP_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_PROV_ENTITY_TRIG
            BEFORE INSERT
            ON IDP_PROVISIONING_ENTITY
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_PROV_ENTITY_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDP_LOCAL_CLAIM_TRIG
            BEFORE INSERT
            ON IDP_LOCAL_CLAIM
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDP_LOCAL_CLAIM_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_ASSOCIATED_ID_TRIG
BEFORE INSERT
ON IDN_ASSOCIATED_ID
REFERENCING NEW AS NEW
FOR EACH ROW
  BEGIN
    SELECT IDN_ASSOCIATED_ID_SEQ.nextval
    INTO :NEW.ID
    FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER WF_WORKFLOW_ASSOCIATION_TRIG
BEFORE INSERT
ON WF_WORKFLOW_ASSOCIATION
REFERENCING NEW AS NEW
FOR EACH ROW
  BEGIN
    SELECT WF_WORKFLOW_ASSOCIATION_SEQ.nextval
    INTO :NEW.ID
    FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER IDN_PASSWORD_HISTORY_DATA_TRIG
BEFORE INSERT
ON IDN_PASSWORD_HISTORY_DATA
REFERENCING NEW AS NEW
FOR EACH ROW
  BEGIN
    SELECT IDN_PASSWORD_HISTORY_DATA_SEQ.nextval
    INTO :NEW.ID
    FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER IDN_CLAIM_DIALECT_TRIG
            BEFORE INSERT
            ON IDN_CLAIM_DIALECT
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_CLAIM_DIALECT_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_CLAIM_TRIG
            BEFORE INSERT
            ON IDN_CLAIM
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_CLAIM_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_CLAIM_MAPPED_ATTR_TRIG
            BEFORE INSERT
            ON IDN_CLAIM_MAPPED_ATTRIBUTE
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_CLAIM_MAPPED_ATTRIBUTE_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_CLAIM_PROPERTY_TRIG
            BEFORE INSERT
            ON IDN_CLAIM_PROPERTY
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_CLAIM_PROPERTY_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_CLAIM_MAPPING_TRIG
            BEFORE INSERT
            ON IDN_CLAIM_MAPPING
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_CLAIM_MAPPING_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_SAML2_ASSERTION_STORE_TRIG
            BEFORE INSERT
            ON IDN_SAML2_ASSERTION_STORE
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_SAML2_ASSERTION_STORE_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_SAML2_ARTIFACT_STORE_TRIG
            BEFORE INSERT
              ON IDN_SAML2_ARTIFACT_STORE
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_SAML2_ARTIFACT_STORE_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_OIDC_PROPERTY_TRIG
            BEFORE INSERT
            ON IDN_OIDC_PROPERTY
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_OIDC_PROPERTY_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_OIDC_REQ_OBJ_REF_TRIG
            BEFORE INSERT
            ON IDN_OIDC_REQ_OBJECT_REFERENCE
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_OIDC_REQ_OBJECT_REF_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_OIDC_REQ_OBJ_CLAIMS_TRIG
            BEFORE INSERT
            ON IDN_OIDC_REQ_OBJECT_CLAIMS
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_OIDC_REQ_OBJ_CLAIMS_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_OIDC_REQ_OBJ_CLM_VAL_TRIG
            BEFORE INSERT
            ON IDN_OIDC_REQ_OBJ_CLAIM_VALUES
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_OIDC_REQ_OBJ_CLM_VAL_SEQ.nextval INTO :NEW.ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER IDN_CERTIFICATE_TRIGGER
		    BEFORE INSERT
            ON IDN_CERTIFICATE
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT IDN_CERTIFICATE_SEQUENCE.nextval INTO :NEW.ID FROM dual;
            END;
/
CREATE OR REPLACE TRIGGER IDN_OIDC_SCOPE_CLAIM_MAP_TRIG
            BEFORE INSERT
            ON IDN_OIDC_SCOPE_CLAIM_MAPPING
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT IDN_OIDC_SCOPE_CLAIM_MAP_SEQ.nextval INTO :NEW.ID FROM dual;
               END;

/
CREATE OR REPLACE TRIGGER IDN_UMA_RESOURCE_TRIG
  BEFORE INSERT
  ON IDN_UMA_RESOURCE
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT IDN_UMA_RESOURCE_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER IDN_UMA_RESOURCE_METADATA_TRIG
  BEFORE INSERT
  ON IDN_UMA_RESOURCE_META_DATA
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT IDN_UMA_RESOURCE_META_DATA_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER IDN_UMA_RESOURCE_SCOPE_TRIG
  BEFORE INSERT
  ON IDN_UMA_RESOURCE_SCOPE
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT IDN_UMA_RESOURCE_SCOPE_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER IDN_UMA_PERMISSION_TICKET_TRIG
  BEFORE INSERT
  ON IDN_UMA_PERMISSION_TICKET
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT IDN_UMA_PERMISSION_TICKET_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER IDN_UMA_PT_RESOURCE_TRIG
  BEFORE INSERT
  ON IDN_UMA_PT_RESOURCE
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT IDN_UMA_PT_RESOURCE_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER IDN_UMA_PT_RESOURCE_SCOPE_TRIG
  BEFORE INSERT
  ON IDN_UMA_PT_RESOURCE_SCOPE
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT IDN_UMA_PT_RESOURCE_SCOPE_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER CM_PII_CATEGORY_TRIG
  BEFORE INSERT
  ON CM_PII_CATEGORY
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT CM_PII_CATEGORY_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER CM_PURPOSE_TRIG
  BEFORE INSERT
  ON CM_PURPOSE
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT CM_PURPOSE_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER CM_PURPOSE_CATEGORY_TRIG
  BEFORE INSERT
  ON CM_PURPOSE_CATEGORY
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT CM_PURPOSE_CATEGORY_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER CM_RECEIPT_SP_ASSOC_TRIG
  BEFORE INSERT
  ON CM_RECEIPT_SP_ASSOC
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT CM_RECEIPT_SP_ASSOC_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER CM_SP_PURPOSE_ASSOC_TRIG
  BEFORE INSERT
  ON CM_SP_PURPOSE_ASSOC
  REFERENCING NEW AS NEW
  FOR EACH ROW
  BEGIN
    SELECT CM_SP_PURPOSE_ASSOC_SEQ.nextval INTO :NEW.ID FROM dual;
  END;
/
CREATE OR REPLACE TRIGGER AM_SUBSCRIBER_TRIGGER
		            BEFORE INSERT
                    ON AM_SUBSCRIBER
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_SUBSCRIBER_SEQUENCE.nextval INTO :NEW.SUBSCRIBER_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_APPLICATION_TRIGGER
		            BEFORE INSERT
                    ON AM_APPLICATION
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_APPLICATION_SEQUENCE.nextval INTO :NEW.APPLICATION_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_API_TRIGGER
		            BEFORE INSERT
                    ON AM_API
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_API_SEQUENCE.nextval INTO :NEW.API_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_API_URL_MAPPING_TRIGGER
		            BEFORE INSERT
                    ON AM_API_URL_MAPPING
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_API_URL_MAPPING_SEQUENCE.nextval INTO :NEW.URL_MAPPING_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_API_PRODUCT_MAPPING_TRIGGER
		            BEFORE INSERT
                    ON AM_API_PRODUCT_MAPPING
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_API_PRODUCT_MAPPING_SEQ.nextval INTO :NEW.API_PRODUCT_MAPPING_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_SUBSCRIPTION_TRIGGER
		            BEFORE INSERT
                    ON AM_SUBSCRIPTION
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_SUBSCRIPTION_SEQUENCE.nextval INTO :NEW.SUBSCRIPTION_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_API_RATINGS_TRIGGER
		            BEFORE INSERT
                    ON AM_API_RATINGS
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_API_RATINGS_SEQUENCE.nextval INTO :NEW.RATING_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_TIER_PERMISSIONS_TRIGGER
		            BEFORE INSERT
                    ON AM_TIER_PERMISSIONS
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_TIER_PERMISSIONS_SEQUENCE.nextval INTO :NEW.TIER_PERMISSIONS_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_API_LC_EVENT_TRIGGER
		            BEFORE INSERT
                    ON AM_API_LC_EVENT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_API_LC_EVENT_SEQUENCE.nextval INTO :NEW.EVENT_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_APP_REGISTRATION_TRIGGER
		            BEFORE INSERT
                    ON AM_APPLICATION_REGISTRATION
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_APP_REGISTRATION_SEQUENCE.nextval INTO :NEW.REG_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_WORKFLOWS_TRIGGER
		            BEFORE INSERT
                    ON AM_WORKFLOWS
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_WORKFLOWS_SEQUENCE.nextval INTO :NEW.WF_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_EXTERNAL_STORES_TRIGGER
		            BEFORE INSERT
                    ON AM_EXTERNAL_STORES
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_EXTERNAL_STORES_SEQUENCE.nextval INTO :NEW.APISTORE_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_API_DEFAULT_VERSION_TRG
                    BEFORE INSERT
                    ON AM_API_DEFAULT_VERSION
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_API_DEFAULT_VERSION_SEQ.nextval INTO :NEW.DEFAULT_VERSION_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER AM_ALERT_TYPES_TRIG
            BEFORE INSERT
            ON AM_ALERT_TYPES
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT AM_ALERT_TYPES_SEQ.nextval INTO :NEW.ALERT_TYPE_ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER AM_ALERT_EMAILLIST_TRIG
            BEFORE INSERT
            ON AM_ALERT_EMAILLIST
            REFERENCING NEW AS NEW
            FOR EACH ROW
               BEGIN
                   SELECT AM_ALERT_EMAILLIST_SEQ.nextval INTO :NEW.EMAIL_LIST_ID FROM dual;
               END;
/
CREATE OR REPLACE TRIGGER AM_POLICY_SUBSCRIPTION_seq_tr
 BEFORE INSERT ON AM_POLICY_SUBSCRIPTION FOR EACH ROW
 WHEN (NEW.POLICY_ID IS NULL)
BEGIN
 SELECT AM_POLICY_SUBSCRIPTION_seq.NEXTVAL INTO :NEW.POLICY_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER AM_POLICY_APPLICATION_seq_tr
 BEFORE INSERT ON AM_POLICY_APPLICATION FOR EACH ROW
 WHEN (NEW.POLICY_ID IS NULL)
BEGIN
 SELECT AM_POLICY_APPLICATION_seq.NEXTVAL INTO :NEW.POLICY_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER AM_API_THROTTLE_POLICY_seq_tr
 BEFORE INSERT ON AM_API_THROTTLE_POLICY FOR EACH ROW
 WHEN (NEW.POLICY_ID IS NULL)
BEGIN
 SELECT AM_API_THROTTLE_POLICY_seq.NEXTVAL INTO :NEW.POLICY_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER AM_CONDITION_GROUP_seq_tr
 BEFORE INSERT ON AM_CONDITION_GROUP FOR EACH ROW
 WHEN (NEW.CONDITION_GROUP_ID IS NULL)
BEGIN
 SELECT AM_CONDITION_GROUP_seq.NEXTVAL INTO :NEW.CONDITION_GROUP_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER QUERY_PARAMETER_CONDITION_tr
 BEFORE INSERT ON AM_QUERY_PARAMETER_CONDITION FOR EACH ROW
 WHEN (NEW.QUERY_PARAMETER_ID IS NULL)
BEGIN
 SELECT QUERY_PARAMETER_CONDITION_seq.NEXTVAL INTO :NEW.QUERY_PARAMETER_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER AM_HEADER_FIELD_CONDITION_tr
 BEFORE INSERT ON AM_HEADER_FIELD_CONDITION FOR EACH ROW
 WHEN (NEW.HEADER_FIELD_ID IS NULL)
BEGIN
 SELECT AM_HEADER_FIELD_CONDITION_seq.NEXTVAL INTO :NEW.HEADER_FIELD_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER AM_JWT_CLAIM_CONDITION_seq_tr
 BEFORE INSERT ON AM_JWT_CLAIM_CONDITION FOR EACH ROW
 WHEN (NEW.JWT_CLAIM_ID IS NULL)
BEGIN
 SELECT AM_JWT_CLAIM_CONDITION_seq.NEXTVAL INTO :NEW.JWT_CLAIM_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER AM_IP_CONDITION_seq_tr
 BEFORE INSERT ON AM_IP_CONDITION FOR EACH ROW
 WHEN (NEW.AM_IP_CONDITION_ID IS NULL)
BEGIN
 SELECT AM_IP_CONDITION_seq.NEXTVAL INTO :NEW.AM_IP_CONDITION_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER AM_POLICY_GLOBAL_seq_tr
 BEFORE INSERT ON AM_POLICY_GLOBAL FOR EACH ROW
 WHEN (NEW.POLICY_ID IS NULL)
BEGIN
 SELECT AM_POLICY_GLOBAL_seq.NEXTVAL INTO :NEW.POLICY_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER THROTTLE_TIER_PERMISSIONS_tr
 BEFORE INSERT ON AM_THROTTLE_TIER_PERMISSIONS FOR EACH ROW
 WHEN (NEW.THROTTLE_TIER_PERMISSIONS_ID IS NULL)
BEGIN
 SELECT THROTTLE_TIER_PERMISSIONS_seq.NEXTVAL INTO :NEW.THROTTLE_TIER_PERMISSIONS_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER AM_BLOCK_CONDITIONS_seq_tr
 BEFORE INSERT ON AM_BLOCK_CONDITIONS FOR EACH ROW
 WHEN (NEW.CONDITION_ID IS NULL)
BEGIN
 SELECT AM_BLOCK_CONDITIONS_seq.NEXTVAL INTO :NEW.CONDITION_ID FROM DUAL;
END;
/
CREATE OR REPLACE TRIGGER AM_SYSTEM_APPS_TRIG
            BEFORE INSERT
            ON AM_SYSTEM_APPS
            REFERENCING NEW AS NEW
            FOR EACH ROW
              BEGIN
                SELECT AM_SYSTEM_APPS_SEQ.nextval INTO :NEW.ID FROM dual;
              END;
/
CREATE OR REPLACE TRIGGER AM_API_LC_PUBLISH_EVENTS_TRIG
            BEFORE INSERT
            ON AM_API_LC_PUBLISH_EVENTS
            REFERENCING NEW AS NEW
            FOR EACH ROW
              BEGIN
                SELECT AM_API_LC_PUBLISH_EVENTS_SEQ.nextval INTO :NEW.ID FROM dual;
              END;
/

INSERT INTO IDN_BASE_TABLE values ('WSO2 Identity Server')
/
INSERT INTO CM_PURPOSE (NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID) VALUES ('DEFAULT', 'For core functionalities of the product', 'DEFAULT', 'SP', '-1234')
/
INSERT INTO CM_PURPOSE_CATEGORY (NAME, DESCRIPTION, TENANT_ID) VALUES ('DEFAULT','For core functionalities of the product', '-1234')
/
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalResponseTime', 'publisher')
/
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalBackendTime', 'publisher')
/
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalRequestsPerMin', 'subscriber')
/
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalRequestPattern', 'subscriber')
/
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('UnusualIPAccess', 'subscriber')
/
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('FrequentTierLimitHitting', 'subscriber')
/
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('ApiHealthMonitor', 'publisher')
/