ALTER TABLE AM_API_URL_MAPPING ADD THROTTLING_TIER varchar(512) DEFAULT 'Unlimited'
/
ALTER TABLE AM_APPLICATION ADD DESCRIPTION VARCHAR(512)
/
ALTER TABLE IDN_OAUTH_CONSUMER_APPS ADD GRANT_TYPES VARCHAR (1024)
/

ALTER TABLE IDN_OAUTH_CONSUMER_APPS ADD LOGIN_PAGE_URL VARCHAR (1024)
/

ALTER TABLE IDN_OAUTH_CONSUMER_APPS ADD ERROR_PAGE_URL VARCHAR (1024)
/

ALTER TABLE IDN_OAUTH_CONSUMER_APPS ADD CONSENT_PAGE_URL VARCHAR (1024)
/

ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD CALLBACK_URL VARCHAR(1024)
/

CREATE TABLE AM_EXTERNAL_STORES (
    APISTORE_ID INTEGER,
    API_ID INTEGER,
    STORE_ID VARCHAR2(255) NOT NULL,
    STORE_DISPLAY_NAME VARCHAR2(255) NOT NULL,
    STORE_ENDPOINT VARCHAR2(255) NOT NULL,
    STORE_TYPE VARCHAR2(255) NOT NULL,
    FOREIGN KEY(API_ID) REFERENCES AM_API(API_ID) ON DELETE CASCADE,
    PRIMARY KEY (APISTORE_ID)
)
/

CREATE SEQUENCE AM_EXTERNAL_STORES_SEQUENCE START WITH 1 INCREMENT BY 1
/

CREATE OR REPLACE TRIGGER AM_EXTERNAL_STORES_TRIGGER
		            BEFORE INSERT
                    ON AM_EXTERNAL_STORES
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT AM_EXTERNAL_STORES_SEQUENCE.nextval INTO :NEW.APISTORE_ID FROM dual;
                    END;
/

CREATE TABLE AM_TIER_PERMISSIONS (
    TIER_PERMISSIONS_ID INTEGER,
    TIER VARCHAR2(50) NOT NULL,
    PERMISSIONS_TYPE VARCHAR2(50) NOT NULL,
    ROLES VARCHAR2(512) NOT NULL,
    TENANT_ID INTEGER NOT NULL,
    PRIMARY KEY(TIER_PERMISSIONS_ID)
)
/

CREATE TABLE IDN_THRIFT_SESSION (
                 SESSION_ID VARCHAR2(255) NOT NULL,
                 USER_NAME VARCHAR2(255) NOT NULL,
                 CREATED_TIME VARCHAR2(255) NOT NULL,
                 LAST_MODIFIED_TIME VARCHAR2(255) NOT NULL,
                 PRIMARY KEY (SESSION_ID)
)
/

