-- 
-- Copyright 2015 WSO2 Inc. (http://wso2.org)
-- 
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
-- 
--     http://www.apache.org/licenses/LICENSE-2.0
-- 
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
-- 

CREATE TABLE METRIC_GAUGE (
    ID NUMBER(20) PRIMARY KEY,
    SOURCE VARCHAR(255) NOT NULL,
    TIMESTAMP NUMBER(20) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    VALUE VARCHAR(100) NOT NULL
)
/
CREATE SEQUENCE METRIC_GAUGE_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER METRIC_GAUGE_TRIGGER
            BEFORE INSERT
            ON METRIC_GAUGE
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT METRIC_GAUGE_SEQUENCE.nextval INTO :NEW.ID FROM dual;
            END;
/

CREATE TABLE METRIC_COUNTER (
    ID NUMBER(20) PRIMARY KEY,
    SOURCE VARCHAR(255) NOT NULL,
    TIMESTAMP NUMBER(20) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    COUNT NUMBER(20) NOT NULL
)
/
CREATE SEQUENCE METRIC_COUNTER_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER METRIC_COUNTER_TRIGGER
            BEFORE INSERT
            ON METRIC_COUNTER
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT METRIC_COUNTER_SEQUENCE.nextval INTO :NEW.ID FROM dual;
            END;
/

CREATE TABLE METRIC_METER (
    ID NUMBER(20) PRIMARY KEY,
    SOURCE VARCHAR(255) NOT NULL,
    TIMESTAMP NUMBER(20) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    COUNT NUMBER(20) NOT NULL,
    MEAN_RATE BINARY_DOUBLE NOT NULL,
    M1_RATE BINARY_DOUBLE NOT NULL,
    M5_RATE BINARY_DOUBLE NOT NULL,
    M15_RATE BINARY_DOUBLE NOT NULL,
    RATE_UNIT VARCHAR(50) NOT NULL
)
/
CREATE SEQUENCE METRIC_METER_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER METRIC_METER_TRIGGER
            BEFORE INSERT
            ON METRIC_METER
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT METRIC_METER_SEQUENCE.nextval INTO :NEW.ID FROM dual;
            END;
/

CREATE TABLE METRIC_HISTOGRAM (
    ID NUMBER(20) PRIMARY KEY,
    SOURCE VARCHAR(255) NOT NULL,
    TIMESTAMP NUMBER(20) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    COUNT NUMBER(20) NOT NULL,
    MAX BINARY_DOUBLE NOT NULL,
    MEAN BINARY_DOUBLE NOT NULL,
    MIN BINARY_DOUBLE NOT NULL,
    STDDEV BINARY_DOUBLE NOT NULL,
    P50 BINARY_DOUBLE NOT NULL,
    P75 BINARY_DOUBLE NOT NULL,
    P95 BINARY_DOUBLE NOT NULL,
    P98 BINARY_DOUBLE NOT NULL,
    P99 BINARY_DOUBLE NOT NULL,
    P999 BINARY_DOUBLE NOT NULL
)
/
CREATE SEQUENCE METRIC_HISTOGRAM_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER METRIC_HISTOGRAM_TRIGGER
            BEFORE INSERT
            ON METRIC_HISTOGRAM
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT METRIC_HISTOGRAM_SEQUENCE.nextval INTO :NEW.ID FROM dual;
            END;
/

CREATE TABLE METRIC_TIMER (
    ID NUMBER(20) PRIMARY KEY,
    SOURCE VARCHAR(255) NOT NULL,
    TIMESTAMP NUMBER(20) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    COUNT NUMBER(20) NOT NULL,
    MAX BINARY_DOUBLE NOT NULL,
    MEAN BINARY_DOUBLE NOT NULL,
    MIN BINARY_DOUBLE NOT NULL,
    STDDEV BINARY_DOUBLE NOT NULL,
    P50 BINARY_DOUBLE NOT NULL,
    P75 BINARY_DOUBLE NOT NULL,
    P95 BINARY_DOUBLE NOT NULL,
    P98 BINARY_DOUBLE NOT NULL,
    P99 BINARY_DOUBLE NOT NULL,
    P999 BINARY_DOUBLE NOT NULL,
    MEAN_RATE BINARY_DOUBLE NOT NULL,
    M1_RATE BINARY_DOUBLE NOT NULL,
    M5_RATE BINARY_DOUBLE NOT NULL,
    M15_RATE BINARY_DOUBLE NOT NULL,
    RATE_UNIT VARCHAR(50) NOT NULL,
    DURATION_UNIT VARCHAR(50) NOT NULL
)
/
CREATE SEQUENCE METRIC_TIMER_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER METRIC_TIMER_TRIGGER
            BEFORE INSERT
            ON METRIC_TIMER
            REFERENCING NEW AS NEW
            FOR EACH ROW
            BEGIN
                SELECT METRIC_TIMER_SEQUENCE.nextval INTO :NEW.ID FROM dual;
            END;
/

CREATE INDEX IDX_TIMESTAMP_GAUGE ON METRIC_GAUGE (TIMESTAMP)
/
CREATE INDEX IDX_TIMESTAMP_COUNTER ON METRIC_COUNTER (TIMESTAMP)
/
CREATE INDEX IDX_TIMESTAMP_METER ON METRIC_METER (TIMESTAMP)
/
CREATE INDEX IDX_TIMESTAMP_HISTOGRAM ON METRIC_HISTOGRAM (TIMESTAMP)
/
CREATE INDEX IDX_TIMESTAMP_TIMER ON METRIC_TIMER (TIMESTAMP)
/
