/*
 * Copyright (c) 2015, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*!
 * Bootstrap v3.3.1 (http://getbootstrap.com)
 * Copyright 2011-2014 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 */
!function($){var methods={_init:function(options,popover){if(typeof(options.backgroundColor)!=='undefined'){Popover.setBackgroundColor(options.backgroundColor);}
if(typeof(options.fontColor)!=='undefined'){Popover.setFontColor(options.fontColor);}
if(typeof(options.borderColor)!=='undefined'){Popover.setBorderColor(options.borderColor);}
if(typeof(options.disableBackButton)!=="undefined"){if(options.disableBackButton===true){popover.disableBackButton();}else if(options.disableBackButton===false){popover.enableBackButton();}}
if(typeof(options.enableBackButton)!=="undefined"){if(options.enableBackButton===true){popover.enableBackButton();}else if(options.enableBackButton===false){popover.disableBackButton();}}
if(typeof(options.disableHeader)!=='undefined'){if(options.disableHeader===true){popover.disableHeader();}else if(options.disableHeader===false){popover.enableHeader();}}
if(typeof(options.keepData)!=='undefined'){popover.keepData(options.keepData);}
if(typeof(options.childToAppend)!=='undefined'){popover.childToAppend=options.childToAppend;}
if(typeof(options.onCreate)!=='undefined'){popover._onCreate=options.onCreate;}
if(typeof(options.onVisible)!=='undefined'){popover._onVisible=options.onVisible;}
Popover.addMenu(options.id,options.title,options.contents);},_popoverInit:function(options){var popover=new Popover(this.selector);methods._init(options,popover);return popover;},_optionsPopoverInit:function(options){var popover=new OptionsPopover(this.selector);methods._init(options,popover);return popover;},disableHeader:function(popover){popover.disableHeader();},enableHeader:function(popover){popover.enableHeader();},lockPopover:function(){Popover.lockPopover();},unlockPopover:function(){Popover.unlockPopover();},addMenu:function(menu){Popover.addMenu(menu.id,menu.title,menu.contents);},closePopover:function(){Popover.closePopover();},_getPopoverClass:function(){return Popover;}};$.fn.optionsPopover=function(method){if(methods[method]){return methods[method].apply(this,Array.prototype.slice.call(arguments,1));}else if(typeof method==='object'||!method){return methods._optionsPopoverInit.apply(this,arguments);}else{$.error('Method '+ method+' does not exist on jQuery.optionsPopover');}
return this.each(function(){});};$.fn.popover=function(method){if(methods[method]){return methods[method].apply(this,Array.prototype.slice.call(arguments,1));}else if(typeof method==='object'||!method){return methods._popoverInit.apply(this,arguments);}else{$.error('Method '+ method+' does not exist on jQuery.popover');}
return this.each(function(){});};function Popover(popoverListener){this.constructor=Popover;this.popoverNumber=++Popover.popoverNum;this.popoverListenerID="popoverListener"+this.popoverNumber;this.isHeaderDisabled=true;this.isDataKept=false;this.hasBeenOpened=false;var thisPopover=this;var listenerElements=$(popoverListener);listenerElements.addClass(this.popoverListenerID);listenerElements.css("cursor","pointer");listenerElements.click(function(e){thisPopover.toggleVisible(e,$(this));$(document).trigger("popover.listenerClicked");});}
Popover.prototype.disableHeader=function(){this.isHeaderDisabled=true;};Popover.prototype.enableHeader=function(){this.isHeaderDisabled=false;};Popover.prototype.disablePopover=function(){this.isDisabled=true;};Popover.prototype.enablePopover=function(){this.isDisabled=false;};Popover.prototype.keepData=function(bool){this.isDataKept=bool;};Popover.prototype.appendChild=function(){var child=this.childToAppend;if(!child)return;$("#popoverContent")[0].appendChild(child);};Popover.prototype.toggleVisible=function(e,clicked){Popover.lastPopoverClicked=this;var clickedDiv=$(clicked);if(!clickedDiv){console.log("ERROR: No element clicked!");return;}
var popoverWrapperDiv=$("#popoverWrapper");if(popoverWrapperDiv.length===0){popoverWrapperDiv=this.createPopover();if(popoverWrapperDiv.length===0){console.log("ERROR: Failed to create Popover!");return;}}
var id=clickedDiv.attr("id");var identifierList=clickedDiv.attr('class').split(/\s+/);identifierList.push(id);if($("#popover").is(":visible")&&Popover.lastElementClick){if(clickedDiv.is("#"+ Popover.lastElementClick)){console.log("Clicked on same element!");console.log("Last clicked: "+ Popover.lastElementClick);Popover.closePopover();return;}
console.log("Clicked on different element!");Popover.closePopover();}
$("#popover").promise().done(function(){});if(Popover.isLocked||this.isDisabled)return;this.populate(identifierList);clickedDiv.trigger("popover.action",clickedDiv);if(Popover.backgroundColor){$("#popoverHeader").css("backgroundColor",Popover.backgroundColor);$("#popoverContent").css("backgroundColor",Popover.backgroundColor);}
if(Popover.fontColor){$("#popover").css("color",Popover.fontColor);$("#popover a").css("color",Popover.fontColor);}
if(Popover.borderColor){$("#popoverHeader").css("border-color",Popover.borderColor);$("#popoverContent").css("border-color",Popover.borderColor);$(".popoverContentRow").css("border-color",Popover.borderColor);}
$("#popover").stop(false,true).fadeIn('fast');$("#popoverWrapper").css("visibility","visible");$("#popover").promise().done(function(){});popoverWrapperDiv.trigger("popover.visible");if(this._onVisible){this._onVisible();}
if((this.isDataKept&&!this.hasBeenOpened)||(!this.isDataKept)){var child=this.childToAppend;if(child){this.appendChild(child);}}
this.hasBeenOpened=true;Popover.updatePositions(clickedDiv);Popover.lastElementClick=clickedDiv.attr("id");};Popover.updatePositions=function(target){Popover.updateTopPosition(target);Popover.updateLeftPosition(target);$(document).trigger("popover.updatePositions");};Popover.updateTopPosition=function(target){var top=Popover.getTop(target);$("#popoverWrapper").css("padding-top",top+"px");};Popover.updateLeftPosition=function(target){var offset=Popover.getLeft(target);$("#popoverWrapper").css("left",offset.popoverLeft);Popover.setCaretPosition(offset.targetLeft- offset.popoverLeft+ Popover.padding);};Popover.getLeft=function(target){var popoverWrapperDiv=$("#popoverWrapper");Popover.currentTarget=target;var targetLeft=target.offset().left+ target.outerWidth()/2;var rightOffset=targetLeft+ popoverWrapperDiv.outerWidth()/2;var offset=targetLeft- popoverWrapperDiv.outerWidth()/2+ Popover.padding+ 1;var windowWidth=$(window).width();Popover.offScreenX=false;if(offset<0){Popover.offScreenX=true;offset=Popover.padding;}else if(rightOffset>windowWidth){Popover.offScreenX=true;offset=windowWidth- popoverWrapperDiv.outerWidth();}
return{targetLeft:targetLeft,popoverLeft:offset};};Popover.getTop=function(target){var caretHeight=$("#popoverArrow").height();var scrollTop=($("#popoverWrapper").css("position")==="absolute")?0:$(window).scrollTop();var targetTop=target.offset().top- scrollTop;var targetBottom=targetTop+ target.outerHeight();var popoverTop=targetBottom+ caretHeight;var windowHeight=$(window).height();var popoverContentHeight=$("#popoverContent").height();var popoverHeight=popoverContentHeight+ $("#popoverHeader").outerHeight()+ caretHeight;Popover.above=false;Popover.offScreenY=false;if(windowHeight<targetBottom+ popoverHeight){Popover.offScreenY=true;if(targetTop>=popoverHeight){popoverTop=targetTop- popoverHeight;Popover.above=true;}else{popoverTop=windowHeight- popoverHeight;}}else if(popoverTop<0){Popover.offScreenY=true;popoverTop=Popover.padding+ caretHeight;}
return popoverTop;};Popover.setCaretPosition=function(offset){var caretPos="50%";var caret=$("#popoverArrow");if(Popover.offScreenX){caretPos=offset;}
caret.css("left",caretPos);if(Popover.above){var popoverHeight=$("#popoverContent").outerHeight()- 4;$("#popoverArrow").css("margin-top",popoverHeight+"px").addClass("flipArrow").html("▼");}else{$("#popoverArrow").css("margin-top","").removeClass("flipArrow").html("▲");}
Popover.caretLeftOffset=caretPos;};Popover.prototype.createPopover=function(){var popoverWrapperDiv=$(document.createElement("div"));popoverWrapperDiv.attr("id","popoverWrapper");var s="<div id='popover'>"+"<div id='popoverArrow'>▲</div>"+"<div id='currentPopoverAction' style='display: none;'></div>"+"<div id='popoverContentWrapper'>"+"<div id='popoverContent'></div>"+"</div>"+"</div>";popoverWrapperDiv.html(s);popoverWrapperDiv.find("#popover").css("display","none");$("body").prepend(popoverWrapperDiv);$(window).on('resize',function(){if($("#popover").is(":visible")){Popover.updatePositions(Popover.currentTarget);}
var popoverWrapperDiv=$("#popoverWrapper");if(popoverWrapperDiv.css("position")==="absolute"){popoverWrapperDiv.css("height",$(document).height());}else{popoverWrapperDiv.css("height","");}});$('html').on('click touchend',function(e){var clicked=$(e.target);var popoverHeaderLen=clicked.parents("#popoverHeader").length+ clicked.is("#popoverHeader")?1:0;var popoverContentLen=(clicked.parents("#popoverContentWrapper").length&&!clicked.parent().is("#popoverContentWrapper"))?1:0;var isListener=clicked.parents("."+Popover.lastPopoverClicked.popoverListenerID).length+ clicked.is("."+Popover.lastPopoverClicked.popoverListenerID)?1:0;if(popoverHeaderLen===0&&popoverContentLen===0&&isListener===0){Popover.closePopover();}});var popoverContentWrapperDiv=$("#popoverContentWrapper");var throttleTimeout;$(window).bind('resize',function(){if($.browser.msie){if(!throttleTimeout){throttleTimeout=setTimeout(function(){popoverContentWrapperDiv.trigger("popover.resize");throttleTimeout=null;},50);}}else{popoverContentWrapperDiv.trigger("popover.resize");}});popoverContentWrapperDiv.trigger("popover.created");if(this._onCreate)this._onCreate();return popoverWrapperDiv;};Popover.closePopover=function(){if(Popover.isLocked)return;Popover.lastElementClick=null;$(document).trigger("popover.closing");Popover.history=[];$("#popover").stop(false,true).fadeOut('fast');$("#popoverWrapper").css("visibility","hidden");};Popover.getAction=function(){return $("#currentPopoverAction").html();};Popover.setAction=function(id){$("#currentPopoverAction").html(id);};Popover.prototype.disableBackButton=function(){this.isBackEnabled=false;};Popover.prototype.enableBackButton=function(){this.isBackEnabled=true;};Popover.prototype.previousPopover=function(){Popover.history.pop();if(Popover.history.length<=0){Popover.closePopover();return;}
var menu=Popover.history[Popover.history.length- 1];this.populateByMenu(menu);};Popover.setTitle=function(t){Popover.title=t;$("#popoverTitle").html(t);};Popover.getMenu=function(id){var i;for(i=0;i<Popover.menus.length;i+=1){if(Popover.menus[i].id===id){return Popover.menus[i];}}
return null;};Popover.addMenu=function(id,title,contents){Popover.menus.push({'id':id,'title':title,'contents':contents});};Popover.prototype.populateByMenu=function(menu){$(document).trigger('popover.populating');this.lastContentHeight=Popover.getPopoverContentHeight();if(!this.isDataKept){this.clearData();}
if(!this.isHeaderDisabled&&!this.isDataKept){this.insertHeader();}else{this.removeHeader();}
var popoverDisplay=$("#popover").css("display");if(!this.isDataKept||!this.hasBeenOpened)this.setData(menu);this.currentContentHeight=Popover.getPopoverContentHeight();if(Popover.above&&popoverDisplay!=="none"){var oldPopoverTop=parseInt($("#popoverWrapper").css("padding-top"),10);var contentHeightDelta=this.currentContentHeight- this.lastContentHeight;var popoverTop=oldPopoverTop-(contentHeightDelta);$("#popoverWrapper").css("padding-top",popoverTop+"px");Popover.setCaretPosition(Popover.caretLeftOffset);}
return true;};Popover.prototype.populate=function(identifierList){var newMenu=null;var i=0;for(i;i<identifierList.length;i++){newMenu=Popover.getMenu(identifierList[i]);if(newMenu){break;}}
if(!newMenu){console.log("ID not found.");return false;}
Popover.history.push(newMenu);return this.populateByMenu(newMenu);};Popover.getPopoverContentHeight=function(){var popoverDisplay=$("#popover").css("display");$("#popover").show();var popoverHeight=$("#popoverContent").height();$("#popover").css("display",popoverDisplay);return popoverHeight;};Popover.prototype.insertHeader=function(){var header="<div id='popoverHeader'>"+"<div id='popoverTitle'></div>"+"<a id='popoverClose'><span id='popoverCloseIcon'>✕</span></a>"+"</div>";$("#popoverContentWrapper").before(header);if(this.isBackEnabled){var thisPopover=this;$("#popoverHeader").prepend("<a id='popoverBack'><span id='popoverBackIcon'>◄</span></a>");$("#popoverBack").on("click",function(){thisPopover.previousPopover();});}
$("#popoverClose").on("click",function(){Popover.closePopover();});$("#popoverContent").css("paddingTop","47px");};Popover.prototype.removeHeader=function(){$("#popoverBack").off("click");$("#popoverClose").off("click");$("#popoverHeader").remove();$("#popoverContent").css("paddingTop","");};Popover.prototype.clearData=function(){this.removeHeader();$("#popoverTitle").html("");$("#popoverContent").html("");};Popover.prototype.setData=function(data){Popover.setAction(data.id);Popover.setTitle(data.title);Popover.setContent(data.contents);};Popover.prototype.replaceMenu=function(menu,newMenu){var property;for(property in menu){delete menu[property];}
for(property in newMenu){menu[property]=newMenu[property];}};Popover.setContent=function(cont){Popover.content=cont;$("#popoverContent").html(cont);$("#popoverContentWrapper").trigger("popover.setContent");};Popover.popoverNum=0;Popover.lastElementClick=null;Popover.currentTarget=null;Popover.title="";Popover.content="";Popover.menus=[];Popover.history=[];Popover.backgroundColor=null;Popover.fontColor=null;Popover.borderColor=null;Popover.padding=3;Popover.offScreenX=false;Popover.offScreenY=false;Popover.isLocked=false;Popover.above=false;Popover.caretLeftOffset="50%";Popover.lastPopoverClicked=null;Popover.setBackgroundColor=function(color){Popover.backgroundColor=color;};Popover.setFontColor=function(color){Popover.fontColor=color;};Popover.setBorderColor=function(color){Popover.borderColor=color;};Popover.lockPopover=function(){Popover.isLocked=true;};Popover.unlockPopover=function(){Popover.isLocked=false;};function OptionsPopover(popoverListener){Popover.apply(this,[popoverListener]);this.constructor=OptionsPopover;this.superConstructor=Popover;this.isHeaderDisabled=false;this.isBackEnabled=true;if(!OptionsPopover.hasRun){this.init();OptionsPopover.hasRun=true;}}
OptionsPopover.prototype=new Popover();OptionsPopover.constructor=OptionsPopover;OptionsPopover.hasRun=false;OptionsPopover.prototype.init=function(){$(document).on('touchstart mousedown','#popover a',function(){$(this).css({backgroundColor:"#488FCD"});}).on('touchend mouseup mouseout','#popover a',function(){$(this).css({backgroundColor:""});}).on('click','.popoverContentRow',function(){var newId=[];newId.push($(this).attr('id'));if($(this).hasClass("popoverEvent")){$(this).trigger("popover.action",$(this));}
var keepOpen=Popover.lastPopoverClicked.populate(newId);if(!keepOpen)Popover.closePopover();});};OptionsPopover.prototype.setData=function(data){var contArray=data.contents;var c="";var i;for(i=0;i<contArray.length;i++){var lastElement="";var popoverEvent="";var menuId="";var menuUrl="";if(i===contArray.length- 1){lastElement=" last";}
if(typeof(contArray[i].id)!=='undefined'){menuId=" id='"+ contArray[i].id+"'";}
if(typeof(contArray[i].url)!=='undefined'){menuUrl=" href='"+ contArray[i].url+"'";}else{popoverEvent=" popoverEvent";}
c+="<a"+ menuUrl+ menuId+" class='popoverContentRow"+ popoverEvent+ lastElement+"'>"+
contArray[i].name+"</a>";}
Popover.setAction(data.id);Popover.setTitle(data.title);Popover.setContent(c);};}(window.jQuery);