/*
 * Copyright (c) 2015, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* @set Global variables */
var menuButton = '.ctrl-asset-type-switcher',
    menu = '.popover.menu',
    menuContainer = '#asset-select',
    menuSubContainer = '#asset-selected',
    menuItems = '#asset-select ul li',
    tagsContainer = '.wr-search-tags',
    menuItemsID = 0,
    prevSelected = 0;

/* DOM ready functions */
$(document).ready(function(){

    /* Bind filter menu relationship on load */
    addingIdentity();

    /* Bind filter select function to all assets on load */
    $(menuItems).each(function(){
        menuItemsID++;
        $(this).attr({
            'asset':menuItemsID,
            'onclick':'selectAsset(this)',
            'level': $(this).parents('ul').length
        });
    });
});

/* Bind filter window hide function to the document */
$(document).bind('click', function(e) {
    if($(e.target).attr('rel') !== 'assetfilter') {
        $(menu).hide();
    }
});

/* On filter switch button click show filter option window */
$(menuButton).click(function(e){
    e.stopPropagation();
    $(menu).toggle();
});

/* Update filter container */
function containerUpdate(asset){
    var options = $(asset).next('ul').length ? $(asset).next('ul').html() : "";

    $(menuSubContainer).html('<ul class="selected"><li level="'+ $(asset).attr('level') +'" '
        +'onclick="selectAsset(this)"'
        +'asset="' + $(asset).attr('asset') + '">'+ $(asset).html() +'</li>'
        +'<a id="goBack" href="javascript:void(0);" onclick="goBack(this); return false;" '
        +'class="cu-btn btn-prev" title="Go Back"></a>'
        +'<a id="resetNav" href="javascript:void(0);" onclick="resetNav(this); return false;" '
        +'class="cu-btn btn-reset" title="Reset"></a>'
        +'</ul>' + '<ul class="options">'+ options +'</ul>');

    prevSelected = ($(menuSubContainer + ' ul.selected li').attr('asset'));

    $(menuSubContainer + ' ul.options li').length == 0 ? $(menuSubContainer + ' ul.options').hide() :
        + $(menuSubContainer + ' ul.options').show();

    addingIdentity();
}

/* On asset click selecting filter */
function selectAsset(asset){
    $(tagsContainer +' span').each(function(){
        if($(this).attr('level') == $(asset).attr('level')){
            removeTags(this);
        }
    });

    containerUpdate(asset);

    $(menuSubContainer).show();
    $(menuContainer).hide();

    addTags(asset);
}

/* Adding asset filtering relationship menu child elements */
function addingIdentity(){
    $(menu).find('*').each(function(){
        $(this).attr('rel', 'assetfilter');
    });
    $(tagsContainer).find('*').each(function(){
        $(this).attr('rel', 'assetfilter');
    });
}

/* Filter window go back function */
function goBack(backButton){
    if($(backButton).prev('li').attr('level') == 1){
        $(menuSubContainer).hide();
        $(menuContainer).show();
    }
    else{
        containerUpdate($(menuContainer + ' [asset='+prevSelected+']').parent('ul').prev('li'));
        $(backButton).remove();
    }
}

/* Filter window reset function */
function resetNav(reset){
    $('#goBack').remove();
    $('#resetNav').remove();
    $(menuSubContainer).hide();
    $(menuContainer).show();
}

/* Find parent function */
function getParent(selection){
    return $(menuContainer + ' [asset=' + $(selection).attr('asset') + ']').closest('ul').prev('li');
}

/* On filter select ad asset & its parents to search field */
function addTags(tag){
    var level = $(tag).attr('level'),
        selection = tag,
        content = '<span asset="'+ $(tag).attr('asset') +'" level="'+ $(tag).attr('level') +'" '
            +'onclick="removeTags(this)">' + $(tag).html() + ' <b>x</b></span>';

    if(level !== 1) {
        for (var i = 1; i < level; i++) {
            content = '<span asset="'+ $(getParent(selection)).attr('asset') +'" level="'
                + $(getParent(selection)).attr('level')
                +'" onclick="removeTags(this)">' + $(getParent(selection)).html() + ' <b>x</b></span>'
                +content;

            selection = getParent(selection);
        }
        $(tagsContainer).html(content);
    }
    addingIdentity();
}

/* On filter tags click remove asset & its child from search field */
function removeTags(tag){
    $(tag).nextAll('span').andSelf().each(function(){
        $($(menuContainer + ' [asset='+ $(this).attr('asset') +']')).removeClass('selected');
        $(this).remove();
    });
}
