/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.ui.client;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.template.mgt.TemplateManager;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementException;
import org.wso2.carbon.identity.template.mgt.model.Template;
import org.wso2.carbon.identity.template.mgt.model.TemplateInfo;
import org.wso2.carbon.identity.template.mgt.ui.dto.TemplateRequestDTO;
import org.wso2.carbon.identity.template.mgt.ui.dto.UpdateTemplateRequestDTO;
import org.wso2.carbon.identity.template.mgt.ui.internal.TemplateManagementUIServiceDataHolder;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreException;

public class TemplateManagementServiceClient {
    private String loggedInUser;

    public TemplateManagementServiceClient(String loggedInUser) {
        this.loggedInUser = loggedInUser;
    }

    public Template addTemplate(TemplateRequestDTO templateRequestDTO) throws TemplateManagementException {
        this.handleLoggedInUserAuthorization("/permission/admin/manage/identity/template/mgt/add");
        Template template = new Template(templateRequestDTO.getTenantId().intValue(), templateRequestDTO.getTemplateName(), templateRequestDTO.getDescription(), templateRequestDTO.getTemplateScript());
        return this.getTemplateManager().addTemplateUsingTemplateMgtDAO(template);
    }

    public Template getTemplateByName(String templateName) throws TemplateManagementException {
        this.handleLoggedInUserAuthorization("/permission/admin/manage/identity/template/mgt/view");
        return this.getTemplateManager().getTemplateByName(templateName);
    }

    public Template updateTemplate(String templateName, UpdateTemplateRequestDTO updateTemplateRequestDTO) throws TemplateManagementException {
        this.handleLoggedInUserAuthorization("/permission/admin/manage/identity/template/mgt/update");
        Template updateTemplateRequest = new Template(updateTemplateRequestDTO.getTemplateName(), updateTemplateRequestDTO.getDescription(), updateTemplateRequestDTO.getTemplateScript());
        return this.getTemplateManager().updateTemplate(templateName, updateTemplateRequest);
    }

    public void deleteTemplate(String templateName) throws TemplateManagementException {
        this.handleLoggedInUserAuthorization("/permission/admin/manage/identity/template/mgt/delete");
        this.getTemplateManager().deleteTemplate(templateName);
    }

    public List<TemplateInfo> listTemplates(Integer limit, Integer offset) throws TemplateManagementException {
        this.handleLoggedInUserAuthorization("/permission/admin/manage/identity/template/mgt/list");
        return this.getTemplateManager().listTemplates(limit, offset);
    }

    private TemplateManager getTemplateManager() {
        return TemplateManagementUIServiceDataHolder.getInstance().getTemplateManager();
    }

    private void handleLoggedInUserAuthorization(String permission) throws TemplateManagementException {
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            if (StringUtils.isBlank((String)this.loggedInUser)) {
                throw new TemplateManagementException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_NO_AUTH_USER_FOUND.getMessage(), TemplateMgtConstants.ErrorMessages.ERROR_CODE_NO_AUTH_USER_FOUND.getCode());
            }
            AuthorizationManager authorizationManager = TemplateManagementUIServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
            if (!authorizationManager.isUserAuthorized(this.loggedInUser, permission, "ui.execute")) {
                throw new TemplateManagementException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_USER_NOT_AUTHORIZED.getMessage(), TemplateMgtConstants.ErrorMessages.ERROR_CODE_USER_NOT_AUTHORIZED.getCode());
            }
        }
        catch (UserStoreException e) {
            throw new TemplateManagementException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_UNEXPECTED.getMessage(), TemplateMgtConstants.ErrorMessages.ERROR_CODE_UNEXPECTED.getCode());
        }
    }
}

