/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.string;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class UnhexFunctionExtension
extends FunctionExecutor {
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to math:unhex() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the argument of math:unhex() function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data != null) {
            String inputStr = (String)data;
            StringBuilder stringBuilderOut = new StringBuilder();
            for (int i = 0; i < inputStr.length(); i += 2) {
                String hexValue = inputStr.substring(i, i + 2);
                int decimalValue = Integer.parseInt(hexValue, 16);
                stringBuilderOut.append(Character.toChars(decimalValue));
            }
            return stringBuilderOut.toString();
        }
        throw new ExecutionPlanRuntimeException("Input to the math:unhex() function cannot be null");
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

