/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.string;

import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class ContainsFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.BOOL;
    private static final Logger log = Logger.getLogger(ContainsFunctionExtension.class);

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to str:contains() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of str:contains() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of str:contains() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
    }

    protected Object execute(Object[] data) {
        if (data[0] == null) {
            if (log.isDebugEnabled()) {
                log.warn((Object)"Invalid input given to str:contains() function. First argument cannot be null, returning false");
            }
            return false;
        }
        if (data[1] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to str:contains() function. Second argument cannot be null");
        }
        String source = (String)data[0];
        String sequenceToSearch = (String)data[1];
        return source.contains(sequenceToSearch);
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

