/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.string;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class ConcatFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length < 2) {
            throw new ExecutionPlanValidationException("str:concat() function requires at least two arguments, but found only " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        StringBuilder sb = new StringBuilder();
        for (Object aData : data) {
            if (aData == null) continue;
            sb.append(aData);
        }
        return sb.toString();
    }

    protected Object execute(Object data) {
        return data;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

