/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.event.core.internal.subscription.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.NameValidationUtils;
import org.wso2.carbon.andes.event.core.TopicManagerService;
import org.wso2.carbon.andes.event.core.TopicNode;
import org.wso2.carbon.andes.event.core.TopicRolePermission;
import org.wso2.carbon.andes.event.core.exception.EventBrokerException;
import org.wso2.carbon.andes.event.core.internal.ds.EventBrokerHolder;
import org.wso2.carbon.andes.event.core.internal.util.JavaUtil;
import org.wso2.carbon.andes.event.core.subscription.Subscription;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class TopicManagerServiceImpl
implements TopicManagerService {
    private static Log log = LogFactory.getLog(TopicManagerServiceImpl.class);
    private static final String AT_REPLACE_CHAR = "_";
    private static final String TOPIC_ROLE_PREFIX = "T_";
    private String topicStoragePath;
    private RegistryService registryService;
    private static final String UI_EXECUTE = "ui.execute";
    private static final String PERMISSION_ADMIN_MANAGE_TOPIC_ADD = "/permission/admin/manage/topic/add";
    private static final String PERMISSION_ADMIN_MANAGE_TOPIC_DELETE = "/permission/admin/manage/topic/delete";
    private static final String PERMISSION_ADMIN_MANAGE_TOPIC_DETAILS = "/permission/admin/manage/topic/details";
    private static final String PARENT_RESOURCE_PATH = "\\bevent/topics/\\b";

    public TopicManagerServiceImpl(String topicStoragePath) {
        this.topicStoragePath = topicStoragePath;
        this.registryService = EventBrokerHolder.getInstance().getRegistryService();
    }

    @Override
    public TopicNode getTopicTree() throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            if (!userRegistry.resourceExists(this.topicStoragePath)) {
                userRegistry.put(this.topicStoragePath, (Resource)userRegistry.newCollection());
            }
            Resource root = userRegistry.get(this.topicStoragePath);
            TopicNode rootTopic = new TopicNode("/", "/");
            this.buildTopicTree(rootTopic, ((Collection)root).getChildren());
            return rootTopic;
        }
        catch (RegistryException e) {
            throw new EventBrokerException(e.getMessage(), e);
        }
    }

    @Override
    public TopicNode getPaginatedTopicTree(String topicPath, int startIndex, int numberOfTopicsPerRound) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            if (!userRegistry.resourceExists(topicPath)) {
                userRegistry.put(topicPath, (Resource)userRegistry.newCollection());
            }
            Collection collection = (Collection)userRegistry.get(topicPath);
            String[] paths = collection.getChildren(startIndex, numberOfTopicsPerRound);
            TopicNode rootTopic = new TopicNode("/", "/");
            this.buildTopicTree(rootTopic, paths);
            return rootTopic;
        }
        catch (RegistryException e) {
            throw new EventBrokerException(e.getMessage(), e);
        }
    }

    private void buildTopicTree(TopicNode topicNode, String[] paths) throws EventBrokerException {
        String[] children = paths;
        if (children != null) {
            ArrayList<TopicNode> nodes = new ArrayList<TopicNode>();
            for (String childTopic : children) {
                String nodeName;
                if (childTopic.endsWith("/")) {
                    childTopic = childTopic.substring(0, childTopic.length() - 2);
                }
                if ((nodeName = childTopic.substring(childTopic.lastIndexOf("/") + 1)).equals("ws.subscriptions") || nodeName.equals("jms.subscriptions")) continue;
                childTopic = childTopic.substring(childTopic.indexOf(this.topicStoragePath) + this.topicStoragePath.length() + 1);
                TopicNode childNode = new TopicNode(nodeName, childTopic);
                childNode.setLeafNode(false);
                nodes.add(childNode);
            }
            topicNode.setChildren(nodes.toArray(new TopicNode[nodes.size()]));
        }
    }

    private boolean isLeafNode(Resource resource) throws RegistryException {
        String[] childrenNodesNames = ((Collection)resource).getChildren();
        if (null != childrenNodesNames) {
            for (String nodeName : childrenNodesNames) {
                if ((nodeName = nodeName.substring(nodeName.lastIndexOf("/") + 1)).equals("ws.subscriptions") || nodeName.equals("jms.subscriptions")) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void addTopic(String topicName) throws EventBrokerException {
        if (!NameValidationUtils.isValidUITopicName((String)topicName)) {
            throw new EventBrokerException("Topic name " + topicName + " is not a valid topic name. Only alphanumeric characters, stars(*), hash(#) and dots(.) are allowed. (.) can only use in the middle of the name, as a delimiter and (#) can only use at the end of the name. ");
        }
        String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            if (!userRegistry.resourceExists(resourcePath)) {
                Collection collection = userRegistry.newCollection();
                userRegistry.put(resourcePath, (Resource)collection);
                if (!JavaUtil.isAdmin(loggedInUser)) {
                    TopicManagerServiceImpl.authorizePermissionsToLoggedInUser(loggedInUser, topicName, resourcePath, userRealm);
                } else {
                    String[] userRoles = userRealm.getUserStoreManager().getRoleListOfUser(loggedInUser);
                    String adminRole = userRealm.getRealmConfiguration().getAdminRoleName();
                    String role = null;
                    for (String userRole : userRoles) {
                        if (!userRole.equals(adminRole)) continue;
                        role = userRole;
                        break;
                    }
                    TopicManagerServiceImpl.grantPermissionToHierarchyLevel(userRealm, resourcePath, role);
                }
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot access the config registry", e);
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Error while granting user " + loggedInUser + ", permission " + "changePermission" + ", on topic " + topicName, e);
        }
    }

    private static void grantPermissionToHierarchyLevel(UserRealm userRealm, String topicId, String role) throws UserStoreException {
        StringTokenizer tokenizer = new StringTokenizer(topicId, "/");
        StringBuilder resourcePathBuilder = new StringBuilder();
        int tokenCount = tokenizer.countTokens();
        int count = 0;
        Pattern pattern = Pattern.compile(PARENT_RESOURCE_PATH);
        while (tokenizer.hasMoreElements()) {
            String resource = tokenizer.nextElement().toString();
            resourcePathBuilder.append(resource);
            Matcher matcher = pattern.matcher(resourcePathBuilder.toString());
            if (matcher.find()) {
                userRealm.getAuthorizationManager().authorizeRole(role, resourcePathBuilder.toString(), "subscribe");
                userRealm.getAuthorizationManager().authorizeRole(role, resourcePathBuilder.toString(), "publish");
                userRealm.getAuthorizationManager().authorizeRole(role, resourcePathBuilder.toString(), "changePermission");
            }
            if (++count >= tokenCount) continue;
            resourcePathBuilder.append("/");
        }
    }

    private String removeResourcePath(String topic) {
        String resourcePath = this.topicStoragePath;
        if (topic.contains(resourcePath)) {
            topic = topic.substring(topic.indexOf(resourcePath) + resourcePath.length());
        }
        return topic;
    }

    @Override
    public TopicRolePermission[] getTopicRolePermission(String topicName) throws EventBrokerException {
        String topicResourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        ArrayList<TopicRolePermission> topicRolePermissions = new ArrayList<TopicRolePermission>();
        UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        String adminRole = EventBrokerHolder.getInstance().getRealmService().getBootstrapRealmConfiguration().getAdminRoleName();
        try {
            for (String role : userRealm.getUserStoreManager().getRoleNames()) {
                if (role.equals(adminRole) || "system/wso2.anonymous.role".equals(role)) continue;
                TopicRolePermission topicRolePermission = new TopicRolePermission();
                topicRolePermission.setRoleName(role);
                topicRolePermission.setAllowedToSubscribe(userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "subscribe"));
                topicRolePermission.setAllowedToPublish(userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "publish"));
                topicRolePermissions.add(topicRolePermission);
            }
            return topicRolePermissions.toArray(new TopicRolePermission[topicRolePermissions.size()]);
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Cannot access the UserStore manager ", e);
        }
    }

    @Override
    public void updatePermissions(String topicName, TopicRolePermission[] topicRolePermissions) throws EventBrokerException {
        String topicResourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        try {
            boolean isUserHasChangePermission = false;
            if (JavaUtil.isAdmin(loggedInUser)) {
                isUserHasChangePermission = true;
            } else {
                String[] userRoles;
                String[] stringArray = userRoles = userRealm.getUserStoreManager().getRoleListOfUser(loggedInUser);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String userRole = stringArray[i];
                    if (!userRealm.getAuthorizationManager().isRoleAuthorized(userRole, topicResourcePath, "changePermission")) continue;
                    isUserHasChangePermission = true;
                    break;
                }
            }
            if (!isUserHasChangePermission) {
                throw new EventBrokerException(" User " + loggedInUser + " cannot change the permissions of " + topicName);
            }
            for (TopicRolePermission topicRolePermission : topicRolePermissions) {
                String role = topicRolePermission.getRoleName();
                if (topicRolePermission.isAllowedToSubscribe()) {
                    if (!userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "subscribe")) {
                        userRealm.getAuthorizationManager().authorizeRole(role, topicResourcePath, "subscribe");
                    }
                } else if (userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "subscribe")) {
                    userRealm.getAuthorizationManager().denyRole(role, topicResourcePath, "subscribe");
                }
                if (topicRolePermission.isAllowedToPublish()) {
                    if (userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "publish")) continue;
                    userRealm.getAuthorizationManager().authorizeRole(role, topicResourcePath, "publish");
                    continue;
                }
                if (!userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "publish")) continue;
                userRealm.getAuthorizationManager().denyRole(role, topicResourcePath, "publish");
            }
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Cannot access the user store manager", e);
        }
    }

    public String getTopicStoragePath() {
        return this.topicStoragePath;
    }

    public void setTopicStoragePath(String topicStoragePath) {
        this.topicStoragePath = topicStoragePath;
    }

    @Override
    public Subscription[] getSubscriptions(String topicName, boolean withChildren) throws EventBrokerException {
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        LinkedList<String> pathsQueue = new LinkedList<String>();
        String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        pathsQueue.add(resourcePath);
        while (!pathsQueue.isEmpty()) {
            this.addSubscriptions((String)pathsQueue.remove(), subscriptions, pathsQueue, withChildren);
        }
        return subscriptions.toArray(new Subscription[subscriptions.size()]);
    }

    @Override
    public Subscription[] getJMSSubscriptions(String topicName) throws EventBrokerException {
        try {
            Subscription[] subscriptionsArray = new Subscription[]{};
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            if (!resourcePath.endsWith("/")) {
                resourcePath = resourcePath + "/";
            }
            if (userRegistry.resourceExists(resourcePath = resourcePath + "jms.subscriptions")) {
                Collection subscriptionCollection = (Collection)userRegistry.get(resourcePath);
                subscriptionsArray = new Subscription[subscriptionCollection.getChildCount()];
                int index = 0;
                for (String subs : subscriptionCollection.getChildren()) {
                    Collection subscription = (Collection)userRegistry.get(subs);
                    Subscription subscriptionDetails = new Subscription();
                    subscriptionDetails.setId(subscription.getProperty("Name"));
                    subscriptionDetails.setOwner(subscription.getProperty("Owner"));
                    subscriptionDetails.setCreatedTime(new Date(subscription.getCreatedTime().getTime()));
                    subscriptionsArray[index++] = subscriptionDetails;
                }
            }
            return subscriptionsArray;
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot read the registry resources ", e);
        }
    }

    private void addSubscriptions(String resourcePath, List<Subscription> subscriptions, Queue<String> pathsQueue, boolean withChildren) throws EventBrokerException {
        try {
            Resource resource;
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String subscriptionsPath = this.getSubscriptionsPath(resourcePath);
            if (userRegistry.resourceExists(subscriptionsPath)) {
                Collection collection = (Collection)userRegistry.get(subscriptionsPath);
                for (String subscriptionPath : collection.getChildren()) {
                    Resource subscriptionResource = userRegistry.get(subscriptionPath);
                    Subscription subscription = JavaUtil.getSubscription(subscriptionResource);
                    subscription.setTopicName(this.removeResourcePath(resourcePath));
                    if (subscriptionPath.endsWith("/")) {
                        subscriptionPath = subscriptionsPath.substring(0, subscriptionPath.lastIndexOf("/"));
                    }
                    subscription.setId(subscriptionPath.substring(subscriptionPath.lastIndexOf("/") + 1));
                    subscriptions.add(subscription);
                }
            }
            if (withChildren && (resource = userRegistry.get(resourcePath)) instanceof Collection) {
                Collection childResources = (Collection)resource;
                for (String childResourcePath : childResources.getChildren()) {
                    if ("ws.subscriptions".contains(childResourcePath) || "jms.subscriptions".contains(childResourcePath)) continue;
                    pathsQueue.add(childResourcePath);
                }
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot access the registry", e);
        }
    }

    private String getSubscriptionsPath(String topicName) {
        if (!topicName.endsWith("/")) {
            topicName = topicName + "/";
        }
        topicName = topicName + "ws.subscriptions";
        return topicName;
    }

    @Override
    public String[] getBackendRoles() throws EventBrokerException {
        UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        String[] cleanedRoles = new String[]{};
        try {
            String adminRole = EventBrokerHolder.getInstance().getRealmService().getBootstrapRealmConfiguration().getAdminRoleName();
            String[] allRoles = userRealm.getUserStoreManager().getRoleNames();
            if (allRoles != null && allRoles.length > 1) {
                ArrayList allRolesArrayList = new ArrayList();
                Collections.addAll(allRolesArrayList, allRoles);
                Iterator it = allRolesArrayList.iterator();
                while (it.hasNext()) {
                    String nextRole = (String)it.next();
                    if (!nextRole.equals(adminRole) && !nextRole.equals("system/wso2.anonymous.role")) continue;
                    it.remove();
                }
                cleanedRoles = allRolesArrayList.toArray(new String[allRolesArrayList.size()]);
            }
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Unable to get roles from user store", e);
        }
        return cleanedRoles;
    }

    @Override
    public boolean removeTopic(String topicName) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            this.removeRoleCreateForLoggedInUser(topicName);
            if (userRegistry.resourceExists(resourcePath)) {
                userRegistry.delete(resourcePath);
                return true;
            }
            return false;
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot access the config registry", e);
        }
    }

    @Override
    public boolean isTopicExists(String topicName) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            return userRegistry.resourceExists(resourcePath);
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot access the config registry");
        }
    }

    @Override
    public boolean checkUserHasAddTopicPermission(String username) throws EventBrokerException {
        boolean hasPermission = false;
        try {
            if (JavaUtil.isAdmin(username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_TOPIC_ADD, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (UserStoreException e) {
            String errorMessage = "Unable to get user store to check permissions.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventBrokerException(errorMessage, e);
        }
        return hasPermission;
    }

    @Override
    public boolean checkUserHasDeleteTopicPermission(String username) throws EventBrokerException {
        boolean hasPermission = false;
        try {
            if (JavaUtil.isAdmin(username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_TOPIC_DELETE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (UserStoreException e) {
            String errorMessage = "Unable to get user store to check permissions.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventBrokerException(errorMessage, e);
        }
        return hasPermission;
    }

    @Override
    public boolean checkUserHasDetailsTopicPermission(String username) throws EventBrokerException {
        boolean hasPermission = false;
        try {
            if (JavaUtil.isAdmin(username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_TOPIC_DETAILS, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (UserStoreException e) {
            String errorMessage = "Unable to get user store to check permissions.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventBrokerException(errorMessage, e);
        }
        return hasPermission;
    }

    @Override
    public boolean checkUserHasPublishTopicPermission(String topicName, String username) throws EventBrokerException {
        boolean hasPermission = false;
        String topicResourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        try {
            if (JavaUtil.isAdmin(username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, topicResourcePath, "publish")) {
                hasPermission = true;
            }
        }
        catch (UserStoreException e) {
            String errorMessage = "Unable to get user store to check permissions.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventBrokerException(errorMessage, e);
        }
        return hasPermission;
    }

    private static void authorizePermissionsToLoggedInUser(String username, String destinationName, String destinationId, UserRealm userRealm) throws UserStoreException {
        String roleName;
        String newDestinationName = destinationName.replace("@", AT_REPLACE_CHAR);
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String string = newDestinationName = newDestinationName.substring(0, 1).equalsIgnoreCase("/") ? newDestinationName.replaceFirst("/", "") : newDestinationName;
        if (CarbonContext.getThreadLocalCarbonContext().getTenantId() >= 0) {
            String destinationWithTenantDomain = tenantDomain + "/" + newDestinationName;
            roleName = UserCoreUtil.addInternalDomainName((String)(TOPIC_ROLE_PREFIX + destinationWithTenantDomain.replace(".", "-").replace("/", "-")));
        } else {
            roleName = UserCoreUtil.addInternalDomainName((String)(TOPIC_ROLE_PREFIX + newDestinationName.replace(".", "-").replace("/", "-")));
        }
        UserStoreManager userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
        if (!userStoreManager.isExistingRole(roleName)) {
            String[] user = new String[]{MultitenantUtils.getTenantAwareUsername((String)username)};
            userStoreManager.addRole(roleName, user, null);
            TopicManagerServiceImpl.grantPermissionToHierarchyLevel(userRealm, destinationId, roleName);
        } else {
            log.warn((Object)("Unable to provide permissions to the user,  " + username + ", to subscribe and publish to " + newDestinationName));
        }
    }

    private void removeRoleCreateForLoggedInUser(String destinationName) throws EventBrokerException {
        String roleName;
        String newDestinationName = destinationName.replace("@", AT_REPLACE_CHAR);
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (CarbonContext.getThreadLocalCarbonContext().getTenantId() >= 0) {
            String destinationWithTenantDomain = tenantDomain + "/" + newDestinationName;
            roleName = UserCoreUtil.addInternalDomainName((String)(TOPIC_ROLE_PREFIX + destinationWithTenantDomain.replace(".", "-").replace("/", "-")));
        } else {
            roleName = UserCoreUtil.addInternalDomainName((String)(TOPIC_ROLE_PREFIX + newDestinationName.replace(".", "-").replace("/", "-")));
        }
        try {
            UserStoreManager userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            AuthorizationManager authorizationManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager();
            if (userStoreManager.isExistingRole(roleName)) {
                userStoreManager.deleteRole(roleName);
                authorizationManager.clearResourceAuthorizations(JavaUtil.getResourcePath(destinationName, this.getTopicStoragePath()));
            }
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Error while deleting " + newDestinationName, e);
        }
    }
}

