/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.event.core.internal.delivery.jms;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.event.core.Message;
import org.wso2.carbon.andes.event.core.NotificationManager;
import org.wso2.carbon.andes.event.core.delivery.DeliveryManager;
import org.wso2.carbon.andes.event.core.exception.EventBrokerException;
import org.wso2.carbon.andes.event.core.internal.delivery.jms.JMSMessageListener;
import org.wso2.carbon.andes.event.core.internal.delivery.jms.JMSSubscriptionDetails;
import org.wso2.carbon.andes.event.core.internal.ds.EventBrokerHolder;
import org.wso2.carbon.andes.event.core.subscription.Subscription;
import org.wso2.carbon.context.CarbonContext;

public abstract class JMSDeliveryManager
implements DeliveryManager {
    private static final Log log = LogFactory.getLog(JMSDeliveryManager.class);
    private NotificationManager notificationManager;
    private Map<String, JMSSubscriptionDetails> subscriptionIDSessionDetailsMap = new ConcurrentHashMap<String, JMSSubscriptionDetails>();
    private boolean isDeactivated;

    protected JMSDeliveryManager() {
    }

    protected abstract Properties getInitialContextProperties(String var1, String var2);

    protected abstract TopicConnectionFactory getTopicConnectionFactory(InitialContext var1) throws EventBrokerException;

    protected abstract String getTopicName(String var1);

    public TopicConnection getTopicConnection(String userName) throws EventBrokerException {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(this.getInitialContextProperties(userName, EventBrokerHolder.getInstance().getQpidServerDetails().getAccessKey()));
            TopicConnectionFactory topicConnectionFactory = this.getTopicConnectionFactory(initialContext);
            TopicConnection topicConnection = topicConnectionFactory.createTopicConnection();
            topicConnection.start();
            TopicConnection topicConnection2 = topicConnection;
            return topicConnection2;
        }
        catch (NamingException e) {
            throw new EventBrokerException("Can not create the initial context", e);
        }
        catch (JMSException | EventBrokerException e) {
            throw new EventBrokerException("Can not create topic connection", e);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException e) {
                    log.error((Object)"Can not close the inital context factory ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void subscribe(Subscription subscription) throws EventBrokerException {
        if (this.isDeactivated()) {
            return;
        }
        if (this.subscriptionIDSessionDetailsMap.containsKey(subscription.getId())) {
            log.warn((Object)("There is an subscription already exists for the subscription with id " + subscription.getId()));
            return;
        }
        JMSMessageListener jmsMessageListener = new JMSMessageListener(this.notificationManager, subscription);
        try {
            TopicConnection topicConnection = this.getTopicConnection(subscription.getOwner());
            TopicSession topicSession = topicConnection.createTopicSession(false, 1);
            String topicName = "";
            topicName = subscription.getTenantDomain() != null && !subscription.getTenantDomain().equals("carbon.super") ? (!subscription.getTopicName().startsWith("/") ? this.getTopicName(subscription.getTenantDomain() + "/" + subscription.getTopicName()) : this.getTopicName(subscription.getTenantDomain() + subscription.getTopicName())) : this.getTopicName(subscription.getTopicName());
            Topic topic = topicSession.createTopic(topicName);
            if (!topic.toString().startsWith("topic://amq.topic")) {
                topic = topicSession.createTopic("BURL:" + topicName);
            }
            TopicSubscriber topicSubscriber = topicSession.createDurableSubscriber(topic, subscription.getId());
            topicSubscriber.setMessageListener((MessageListener)jmsMessageListener);
            this.subscriptionIDSessionDetailsMap.put(subscription.getId(), new JMSSubscriptionDetails(topicSubscriber, topicSession, topicConnection));
        }
        catch (JMSException e) {
            throw new EventBrokerException("Can not subscribe to topic " + subscription.getTopicName() + " " + e.getMessage(), e);
        }
    }

    @Override
    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Override
    public void publish(Message message, String topicName, int deliveryMode) throws EventBrokerException {
        if (this.isDeactivated()) {
            return;
        }
        try {
            String tenantDomain;
            TopicConnection topicConnection;
            TopicSession topicSession;
            Topic topic;
            String userName = this.getLoggedInUserName();
            if (userName == null || userName.equals("")) {
                userName = "wso2.system.user";
            }
            if (!(topic = (topicSession = (topicConnection = this.getTopicConnection(userName)).createTopicSession(false, 1)).createTopic(topicName = (tenantDomain = EventBrokerHolder.getInstance().getTenantDomain()) != null && !tenantDomain.equals("carbon.super") ? tenantDomain + "/" + this.getTopicName(topicName) : this.getTopicName(topicName))).toString().startsWith("topic://amq.topic")) {
                topic = topicSession.createTopic("BURL:" + topicName);
            }
            TopicPublisher topicPublisher = topicSession.createPublisher(topic);
            topicPublisher.setDeliveryMode(deliveryMode);
            TextMessage textMessage = topicSession.createTextMessage(message.getMessage());
            Map<String, String> properties = message.getProperties();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                textMessage.setStringProperty(entry.getKey(), entry.getValue());
            }
            if (CarbonContext.getThreadLocalCarbonContext().getTenantDomain() != null) {
                textMessage.setStringProperty("TenantDomain", CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
            }
            topicPublisher.publish((javax.jms.Message)textMessage);
            topicPublisher.close();
            topicSession.close();
            topicConnection.stop();
            topicConnection.close();
        }
        catch (JMSException e) {
            throw new EventBrokerException("Can not publish to topic " + topicName + " " + e.getMessage(), e);
        }
    }

    @Override
    public void unSubscribe(String id) throws EventBrokerException {
        JMSSubscriptionDetails jmsSubscriptionDetails = this.subscriptionIDSessionDetailsMap.remove(id);
        if (jmsSubscriptionDetails != null) {
            jmsSubscriptionDetails.close();
        }
    }

    @Override
    public void renewSubscription(Subscription subscription) throws EventBrokerException {
        JMSSubscriptionDetails jmsSubscriptionDetails = this.subscriptionIDSessionDetailsMap.get(subscription.getId());
        try {
            if (jmsSubscriptionDetails != null) {
                jmsSubscriptionDetails.renewSubscription(subscription);
            }
        }
        catch (JMSException e) {
            throw new EventBrokerException("Can not renew the subscription ", e);
        }
    }

    @Override
    public void cleanUp() throws EventBrokerException {
        this.setDeactivated(true);
        for (JMSSubscriptionDetails jmsSubscriptionDetails : this.subscriptionIDSessionDetailsMap.values()) {
            jmsSubscriptionDetails.close();
        }
    }

    private String getLoggedInUserName() {
        String userName = "";
        userName = CarbonContext.getThreadLocalCarbonContext().getTenantId() > -1 ? CarbonContext.getThreadLocalCarbonContext().getUsername() + "!" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain() : CarbonContext.getThreadLocalCarbonContext().getUsername();
        return userName;
    }

    public synchronized boolean isDeactivated() {
        return this.isDeactivated;
    }

    public synchronized void setDeactivated(boolean deactivated) {
        this.isDeactivated = deactivated;
    }

    @Override
    public void initializeTenant() throws EventBrokerException {
    }
}

