/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.event.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.event.core.Message;
import org.wso2.carbon.andes.event.core.delivery.DeliveryManager;
import org.wso2.carbon.andes.event.core.exception.EventBrokerException;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class EventPublisher
implements Runnable {
    private static final Log log = LogFactory.getLog(EventPublisher.class);
    private Message message;
    private String topicName;
    private DeliveryManager delivaryManager;
    private int deliveryMode;
    private int tenantID;
    private String username;

    public EventPublisher(Message message, String topicName, DeliveryManager delivaryManager, int deliveryMode, int tenantID, String username) {
        this.message = message;
        this.topicName = topicName;
        this.delivaryManager = delivaryManager;
        this.deliveryMode = deliveryMode;
        this.tenantID = tenantID;
        this.username = username;
    }

    @Override
    public void run() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantID);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(this.username);
            this.delivaryManager.publish(this.message, this.topicName, this.deliveryMode);
        }
        catch (EventBrokerException e) {
            log.error((Object)"Can not publish the message ", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

