/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.template.manager.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.event.template.manager.core.DeployableTemplate;
import org.wso2.carbon.event.template.manager.core.TemplateDeployer;
import org.wso2.carbon.event.template.manager.core.TemplateDeploymentException;
import org.wso2.carbon.event.template.manager.core.exception.TemplateManagerException;
import org.wso2.carbon.event.template.manager.core.internal.ds.TemplateManagerValueHolder;
import org.wso2.carbon.event.template.manager.core.internal.util.TemplateManagerConstants;
import org.wso2.carbon.event.template.manager.core.structure.configuration.AttributeMapping;
import org.wso2.carbon.event.template.manager.core.structure.configuration.ScenarioConfiguration;
import org.wso2.carbon.event.template.manager.core.structure.configuration.StreamMapping;
import org.wso2.carbon.event.template.manager.core.structure.domain.Artifact;
import org.wso2.carbon.event.template.manager.core.structure.domain.Domain;
import org.wso2.carbon.event.template.manager.core.structure.domain.Scenario;
import org.wso2.carbon.event.template.manager.core.structure.domain.Script;
import org.wso2.carbon.event.template.manager.core.structure.domain.Template;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class TemplateManagerHelper {
    private static final Log log = LogFactory.getLog(TemplateManagerHelper.class);
    private static final String EXECUTION_PLAN_NAME_ANNOTATION = "@Plan:name";
    private static final String DEFINE_STREAM = "define stream ";
    private static final String FROM = "from ";
    private static final String SELECT = "select ";
    private static final String AS = " as ";
    private static final String INSERT_INTO = "insert into ";

    private TemplateManagerHelper() {
    }

    public static Map<String, Domain> loadDomains() {
        File folder = new File(TemplateManagerConstants.TEMPLATE_DOMAIN_PATH);
        HashMap<String, Domain> domains = new HashMap<String, Domain>();
        File[] files = folder.listFiles();
        if (files != null) {
            for (File fileEntry : files) {
                if (!fileEntry.isFile() || !fileEntry.getName().endsWith("xml")) continue;
                Domain domain = TemplateManagerHelper.unmarshalDomain(fileEntry);
                if (domain != null) {
                    try {
                        TemplateManagerHelper.validateTemplateDomainConfig(domain);
                    }
                    catch (TemplateManagerException e) {
                        log.error((Object)("Invalid Template Domain configuration file found: " + fileEntry.getName()), (Throwable)e);
                    }
                    domains.put(domain.getName(), domain);
                    continue;
                }
                log.error((Object)("Invalid Template Domain configuration file found: " + fileEntry.getName()));
            }
        }
        return domains;
    }

    private static Domain unmarshalDomain(File fileEntry) {
        Domain domain = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Domain.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            XMLStreamReader xmlStreamReader = TemplateManagerHelper.getXMLInputFactory().createXMLStreamReader(new StreamSource(fileEntry));
            domain = (Domain)jaxbUnmarshaller.unmarshal(xmlStreamReader);
        }
        catch (JAXBException | XMLStreamException e) {
            log.error((Object)("JAXB Exception when unmarshalling domain template file at " + fileEntry.getPath()), e);
        }
        return domain;
    }

    private static ScenarioConfiguration unmarshalConfiguration(Object configFileContent) {
        ScenarioConfiguration scenarioConfiguration = null;
        try {
            StringReader reader = new StringReader(new String((byte[])configFileContent));
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ScenarioConfiguration.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            XMLStreamReader xmlStreamReader = TemplateManagerHelper.getXMLInputFactory().createXMLStreamReader(new StreamSource(reader));
            scenarioConfiguration = (ScenarioConfiguration)jaxbUnmarshaller.unmarshal(xmlStreamReader);
        }
        catch (JAXBException | XMLStreamException e) {
            log.error((Object)"JAXB Exception occurred when unmarshalling configuration ", e);
        }
        return scenarioConfiguration;
    }

    public static void validateTemplateDomainConfig(Domain domain) throws TemplateManagerException {
        if (domain.getScenarios() == null || domain.getScenarios().getScenario() == null || domain.getScenarios().getScenario().isEmpty()) {
            throw new TemplateManagerException("There are no template configurations in the domain " + domain.getName());
        }
    }

    public static void deployArtifacts(ScenarioConfiguration configuration, Domain domain, ScriptEngine scriptEngine) throws TemplateDeploymentException {
        Object deployer;
        if (domain.getCommonArtifacts() != null) {
            HashMap<String, Integer> artifactTypeCountingMap = new HashMap<String, Integer>();
            for (Artifact artifact : domain.getCommonArtifacts().getArtifact()) {
                String artifactType = artifact.getType();
                Integer artifactCount = (Integer)artifactTypeCountingMap.get(artifactType);
                if (artifactCount == null) {
                    artifactCount = 1;
                } else {
                    Integer n = artifactCount;
                    Integer n2 = artifactCount = Integer.valueOf(artifactCount + 1);
                }
                String artifactId = TemplateManagerHelper.getCommonArtifactId(domain.getName(), artifactType, artifactCount);
                DeployableTemplate deployableTemplate = new DeployableTemplate();
                deployableTemplate.setArtifact(artifact.getValue());
                deployableTemplate.setConfiguration(configuration);
                deployableTemplate.setArtifactId(artifactId);
                deployer = TemplateManagerValueHolder.getTemplateDeployers().get(artifact.getType());
                if (deployer != null) {
                    deployer.deployIfNotDoneAlready(deployableTemplate);
                    artifactTypeCountingMap.put(artifactType, artifactCount);
                    continue;
                }
                throw new TemplateDeploymentException("A deployer doesn't exist for template type " + artifact.getType());
            }
        }
        for (Scenario scenario : domain.getScenarios().getScenario()) {
            if (!scenario.getType().equals(configuration.getScenario())) continue;
            HashMap<String, Integer> artifactTypeCountingMap = new HashMap<String, Integer>();
            for (Template template : scenario.getTemplates().getTemplate()) {
                String artifactType = template.getType();
                Integer artifactCount = (Integer)artifactTypeCountingMap.get(artifactType);
                if (artifactCount == null) {
                    artifactCount = 1;
                } else {
                    deployer = artifactCount;
                    Integer n = artifactCount = Integer.valueOf(artifactCount + 1);
                }
                String artifactId = TemplateManagerHelper.getTemplatedArtifactId(domain.getName(), scenario.getType(), configuration.getName(), artifactType, artifactCount);
                TemplateDeployer deployer2 = TemplateManagerValueHolder.getTemplateDeployers().get(template.getType());
                if (deployer2 != null) {
                    DeployableTemplate deployableTemplate = new DeployableTemplate();
                    String updatedScript = TemplateManagerHelper.updateArtifactParameters(configuration, template.getValue(), scriptEngine);
                    deployableTemplate.setArtifact(updatedScript);
                    deployableTemplate.setConfiguration(configuration);
                    deployableTemplate.setArtifactId(artifactId);
                    deployer2.deployArtifact(deployableTemplate);
                    artifactTypeCountingMap.put(artifactType, artifactCount);
                    continue;
                }
                throw new TemplateDeploymentException("A deployer doesn't exist for template type " + template.getType());
            }
        }
    }

    public static ScriptEngine createJavaScriptEngine(Domain domain) throws TemplateDeploymentException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("JavaScript");
        if (scriptEngine == null) {
            log.warn((Object)"JavaScript engine is not available. Function calls in the templates cannot be evaluated");
        } else if (domain != null && domain.getScripts() != null && domain.getScripts().getScript() != null) {
            Path scriptDirectory = Paths.get(TemplateManagerConstants.TEMPLATE_SCRIPT_PATH, new String[0]);
            if (Files.exists(scriptDirectory, LinkOption.NOFOLLOW_LINKS) && Files.isDirectory(scriptDirectory, new LinkOption[0])) {
                for (Script script : domain.getScripts().getScript()) {
                    String src = script.getSrc();
                    String content = script.getContent();
                    if (src != null) {
                        Path scriptFile = scriptDirectory.resolve(src).normalize();
                        if (Files.exists(scriptFile, LinkOption.NOFOLLOW_LINKS) && Files.isReadable(scriptFile)) {
                            if (!scriptFile.startsWith(scriptDirectory)) {
                                throw new TemplateDeploymentException("Script file " + scriptFile.toAbsolutePath() + " is not in the permitted directory " + scriptDirectory.toAbsolutePath());
                            }
                            try {
                                scriptEngine.eval(Files.newBufferedReader(scriptFile, Charset.defaultCharset()));
                            }
                            catch (ScriptException e) {
                                throw new TemplateDeploymentException("Error in JavaScript " + scriptFile.toAbsolutePath() + ": " + e.getMessage(), e);
                            }
                            catch (IOException e) {
                                throw new TemplateDeploymentException("Error in reading JavaScript file: " + scriptFile.toAbsolutePath());
                            }
                        } else {
                            throw new TemplateDeploymentException("JavaScript file not exist at: " + scriptFile.toAbsolutePath() + " or not readable.");
                        }
                    }
                    if (content == null) continue;
                    try {
                        scriptEngine.eval(content);
                    }
                    catch (ScriptException e) {
                        throw new TemplateDeploymentException("JavaScript declared in " + domain.getName() + " has error", e);
                    }
                }
            } else {
                log.warn((Object)("Script directory not found at: " + scriptDirectory.toAbsolutePath()));
            }
        }
        return scriptEngine;
    }

    private static String replaceScriptExpressions(String content, ScriptEngine scriptEngine) throws TemplateDeploymentException {
        StringBuffer buffer = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{\\s*(([a-zA-Z_][0-9a-zA-Z_]*\\.)|(\\'[^\\']*\\'\\.)|(\\\"[^\\\"]*\\\"\\.)|(new\\s*))?[a-zA-Z_][0-9a-zA-Z_]*\\s*(\\(\\s*(((\\'[^\\']*\\')|(\\\"[^\\\"]*\\\")|([+-]?\\d+(\\.\\d)?\\d*)|true|false)\\s*(\\,\\s*((\\'[^\\']*\\')|(\\\"[^\\\"]*\\\")|([+-]?\\d+(\\.\\d)?\\d*)|true|false))*)?\\s*\\))?(\\.[a-zA-Z_][0-9a-zA-Z_]*\\s*(\\(\\s*(((\\'[^\\']*\\')|(\\\"[^\\\"]*\\\")|([+-]?\\d+(\\.\\d)?\\d*)|true|false)\\s*(\\,\\s*((\\'[^\\']*\\')|(\\\"[^\\\"]*\\\")|([+-]?\\d+(\\.\\d)?\\d*)|true|false))*)?\\s*\\))?)*\\s*\\;?\\}");
        Matcher matcher = pattern.matcher(content);
        int scriptEvaluatorPrefixLength = "${".length();
        int scriptEvaluatorSuffixLength = "}".length();
        if (scriptEngine == null && matcher.find()) {
            throw new TemplateDeploymentException("JavaScript engine is not available in the current JRE to evaluate the function calls given in the template.");
        }
        while (matcher.find()) {
            String expression = matcher.group();
            int expressionLength = expression.length();
            String scriptToEvaluate = expression.substring(scriptEvaluatorPrefixLength, expressionLength - scriptEvaluatorSuffixLength);
            String result = "";
            try {
                Object output = scriptEngine.eval(scriptToEvaluate);
                if (output != null) {
                    result = output.toString();
                }
            }
            catch (ScriptException e) {
                throw new TemplateDeploymentException("Error in evaluating JavaScript expression: " + expression, e);
            }
            matcher.appendReplacement(buffer, result);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String updateArtifactParameters(ScenarioConfiguration config, String script, ScriptEngine scriptEngine) throws TemplateDeploymentException {
        String updatedScript = script;
        if (config.getParameterMap() != null && script != null) {
            for (Map.Entry<String, String> parameterMapEntry : config.getParameterMap().entrySet()) {
                updatedScript = updatedScript.replaceAll("\\$" + parameterMapEntry.getKey().toString(), parameterMapEntry.getValue().toString());
            }
        }
        return TemplateManagerHelper.replaceScriptExpressions(updatedScript, scriptEngine);
    }

    public static void unDeployExistingArtifact(String artifactId, String type) throws TemplateDeploymentException {
        TemplateDeployer deployer = TemplateManagerValueHolder.getTemplateDeployers().get(type);
        deployer.undeployArtifact(artifactId);
    }

    public static List<String> getStreamIDsToBeMapped(ScenarioConfiguration configuration, Domain domain, ScriptEngine scriptEngine) throws TemplateDeploymentException {
        ArrayList<String> streamIdList = new ArrayList<String>();
        for (Scenario scenario : domain.getScenarios().getScenario()) {
            if (!configuration.getScenario().equals(scenario.getType())) continue;
            if (scenario.getStreamMappings() == null || scenario.getStreamMappings().getStreamMapping() == null || scenario.getStreamMappings().getStreamMapping().isEmpty()) break;
            for (org.wso2.carbon.event.template.manager.core.structure.domain.StreamMapping streamMapping : scenario.getStreamMappings().getStreamMapping()) {
                String toStream = streamMapping.getTo();
                for (Map.Entry<String, String> entry : configuration.getParameterMap().entrySet()) {
                    toStream = toStream.replaceAll("\\$" + entry.getKey().toString(), entry.getValue().toString());
                }
                streamIdList.add(TemplateManagerHelper.replaceScriptExpressions(toStream, scriptEngine));
            }
            return streamIdList;
        }
        return null;
    }

    public static String generateExecutionPlan(List<StreamMapping> streamMappingList, String planName) throws TemplateManagerException {
        String planNameStatement = "@Plan:name('" + planName + "') \n\n";
        StringBuilder importStatementBuilder = new StringBuilder();
        StringBuilder exportStatementBuilder = new StringBuilder();
        StringBuilder queryBuilder = new StringBuilder();
        for (StreamMapping streamMapping : streamMappingList) {
            String fromStreamId = streamMapping.getFrom();
            String toStreamId = streamMapping.getTo();
            String internalFromStreamId = TemplateManagerHelper.getInternalStreamId(fromStreamId);
            String internalToStreamId = TemplateManagerHelper.getInternalStreamId(toStreamId);
            importStatementBuilder.append(TemplateManagerHelper.generateDefineStreamStatements(DefineStreamTypes.IMPORT, fromStreamId, internalFromStreamId)).append("\n\n");
            exportStatementBuilder.append(TemplateManagerHelper.generateDefineStreamStatements(DefineStreamTypes.EXPORT, toStreamId, internalToStreamId)).append("\n\n");
            queryBuilder.append(FROM).append(internalFromStreamId).append(" \n").append(SELECT);
            for (AttributeMapping attributeMapping : streamMapping.getAttributeMappings().getAttributeMapping()) {
                queryBuilder.append(attributeMapping.getFrom()).append(AS).append(attributeMapping.getTo()).append(", ");
            }
            queryBuilder.deleteCharAt(queryBuilder.length() - 2);
            queryBuilder.append("\n").append(INSERT_INTO).append(internalToStreamId).append(";\n\n");
        }
        return planNameStatement + importStatementBuilder.toString() + exportStatementBuilder.toString() + queryBuilder.toString();
    }

    private static String getInternalStreamId(String streamId) {
        String internalStreamId = streamId.replace(":", "__");
        return internalStreamId.replace(".", "_");
    }

    private static String generateDefineStreamStatements(DefineStreamTypes type, String streamId, String internalStreamId) throws TemplateManagerException {
        try {
            StreamDefinition streamDefinition = TemplateManagerValueHolder.getEventStreamService().getStreamDefinition(streamId);
            if (streamDefinition == null) {
                throw new TemplateManagerException("No stream has being deployed with Stream ID: " + streamId);
            }
            String statement = "@" + type.toString() + "('" + streamId + "')\n";
            StringBuilder streamDefBuilder = new StringBuilder(DEFINE_STREAM + internalStreamId + " (");
            if (streamDefinition.getMetaData() != null) {
                for (Attribute metaAttribute : streamDefinition.getMetaData()) {
                    streamDefBuilder.append("meta_").append(metaAttribute.getName()).append(" ").append(metaAttribute.getType()).append(", ");
                }
            }
            if (streamDefinition.getCorrelationData() != null) {
                for (Attribute corrAttribute : streamDefinition.getCorrelationData()) {
                    streamDefBuilder.append("correlation_").append(corrAttribute.getName()).append(" ").append(corrAttribute.getType()).append(", ");
                }
            }
            if (streamDefinition.getPayloadData() != null) {
                for (Attribute payloadAttribute : streamDefinition.getPayloadData()) {
                    streamDefBuilder.append(payloadAttribute.getName()).append(" ").append(payloadAttribute.getType()).append(", ");
                }
            }
            streamDefBuilder.delete(streamDefBuilder.length() - 2, streamDefBuilder.length() - 1);
            streamDefBuilder.append(");");
            String toStreamDefinitionStr = streamDefBuilder.toString();
            statement = statement + toStreamDefinitionStr;
            return statement;
        }
        catch (EventStreamConfigurationException e) {
            throw new TemplateManagerException("Failed to get stream definition for Stream ID: " + streamId, e);
        }
    }

    public static void saveToRegistry(ScenarioConfiguration configuration) throws TemplateManagerException {
        try {
            UserRegistry registry = TemplateManagerValueHolder.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            StringWriter fileContent = new StringWriter();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ScenarioConfiguration.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            jaxbMarshaller.marshal((Object)configuration, (Writer)fileContent);
            Resource resource = registry.newResource();
            resource.setContent((Object)fileContent.toString());
            String resourceCollectionPath = "/repository/components/org.wso2.carbon.event.template.manager.core/template-config/" + configuration.getDomain();
            String resourcePath = resourceCollectionPath + "/" + configuration.getName() + ".xml";
            if (!registry.resourceExists(resourceCollectionPath)) {
                registry.put(resourceCollectionPath, (Resource)registry.newCollection());
            }
            if (registry.resourceExists(resourcePath)) {
                registry.delete(resourcePath);
            }
            resource.setMediaType("application/xml");
            registry.put(resourcePath, resource);
        }
        catch (JAXBException e) {
            throw new TemplateManagerException("Could not marshall Scenario: " + configuration.getName() + ", for Domain: " + configuration.getDomain() + ". Could not save to registry.", e);
        }
        catch (RegistryException e) {
            throw new TemplateManagerException("Could not save Scenario: " + configuration.getName() + ", for Domain: " + configuration.getDomain() + ", to the registry.", e);
        }
    }

    public static void deleteConfigWithoutUndeploy(String domainName, String configName) throws TemplateManagerException {
        try {
            UserRegistry registry = TemplateManagerValueHolder.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            registry.delete("/repository/components/org.wso2.carbon.event.template.manager.core/template-config/" + domainName + "/" + configName + ".xml");
        }
        catch (RegistryException e) {
            throw new TemplateManagerException("Failed to delete scenario from the registry. Scenario name: " + configName + ", Domain name: " + domainName, e);
        }
    }

    public static ScenarioConfiguration getConfiguration(String path) throws TemplateManagerException {
        ScenarioConfiguration scenarioConfiguration = null;
        try {
            Resource configFile;
            UserRegistry registry = TemplateManagerValueHolder.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            if (registry.resourceExists(path) && (configFile = registry.get(path)) != null) {
                scenarioConfiguration = TemplateManagerHelper.unmarshalConfiguration(configFile.getContent());
            }
        }
        catch (RegistryException e) {
            throw new TemplateManagerException("Registry exception occurred when accessing files at /repository/components/org.wso2.carbon.event.template.manager.core/template-config", e);
        }
        return scenarioConfiguration;
    }

    public static String getTemplatedArtifactId(String domainName, String scenarioName, String scenarioConfigName, String artifactType, int sequenceNumber) {
        return domainName + "-" + scenarioName + "-" + scenarioConfigName + "-" + artifactType + sequenceNumber;
    }

    public static String getStreamMappingPlanId(String domainName, String scenarioConfigName) {
        return domainName + "-" + scenarioConfigName + "-" + "StreamMappingPlan";
    }

    public static String getCommonArtifactId(String domainName, String artifactType, int sequenceNumber) {
        return domainName + "-" + artifactType + sequenceNumber;
    }

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        return xmlInputFactory;
    }

    private static enum DefineStreamTypes {
        IMPORT,
        EXPORT;

    }
}

