/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.template.manager.core.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.template.manager.core.TemplateManagerService;
import org.wso2.carbon.event.template.manager.core.exception.TemplateManagerException;
import org.wso2.carbon.event.template.manager.core.internal.CarbonTemplateManagerService;
import org.wso2.carbon.event.template.manager.core.internal.ds.TemplateManagerValueHolder;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;

@Component(name="org.wso2.carbon.event.template.manager.core.TemplateManagerService", immediate=true)
public class TemplateManagerServiceDS {
    private static final Log log = LogFactory.getLog(TemplateManagerServiceDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            CarbonTemplateManagerService templateManagerService = new CarbonTemplateManagerService();
            context.getBundleContext().registerService(TemplateManagerService.class.getName(), (Object)templateManagerService, null);
            TemplateManagerValueHolder.setTemplateManagerService(templateManagerService);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Execution manager core service deployed successfully");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Execution manager core service cannot be deployed ", (Throwable)e);
        }
        catch (TemplateManagerException e) {
            log.error((Object)"Execution manager core service cannot be deployed", (Throwable)e);
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) throws RegistryException {
        TemplateManagerValueHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        TemplateManagerValueHolder.setRegistryService(null);
    }

    @Reference(name="eventStreamService.service", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        TemplateManagerValueHolder.setEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        TemplateManagerValueHolder.setEventStreamService(null);
    }
}

