/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.template.manager.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.template.manager.core.DeployableTemplate;
import org.wso2.carbon.event.template.manager.core.TemplateDeployer;
import org.wso2.carbon.event.template.manager.core.TemplateDeploymentException;
import org.wso2.carbon.event.template.manager.core.TemplateManagerService;
import org.wso2.carbon.event.template.manager.core.exception.TemplateManagerException;
import org.wso2.carbon.event.template.manager.core.internal.ds.TemplateManagerValueHolder;
import org.wso2.carbon.event.template.manager.core.internal.util.TemplateManagerHelper;
import org.wso2.carbon.event.template.manager.core.structure.configuration.ScenarioConfiguration;
import org.wso2.carbon.event.template.manager.core.structure.configuration.StreamMapping;
import org.wso2.carbon.event.template.manager.core.structure.configuration.StreamMappings;
import org.wso2.carbon.event.template.manager.core.structure.domain.Artifact;
import org.wso2.carbon.event.template.manager.core.structure.domain.Domain;
import org.wso2.carbon.event.template.manager.core.structure.domain.Scenario;
import org.wso2.carbon.event.template.manager.core.structure.domain.Template;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class CarbonTemplateManagerService
implements TemplateManagerService {
    private static final Log log = LogFactory.getLog(CarbonTemplateManagerService.class);
    private Map<String, Domain> domains = TemplateManagerHelper.loadDomains();

    @Override
    public List<String> saveConfiguration(ScenarioConfiguration configuration) throws TemplateManagerException {
        try {
            UserRegistry registry = TemplateManagerValueHolder.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            String resourceCollectionPath = "/repository/components/org.wso2.carbon.event.template.manager.core/template-config/" + configuration.getDomain();
            String resourcePath = resourceCollectionPath + "/" + configuration.getName() + ".xml";
            if (registry.resourceExists(resourcePath)) {
                throw new TemplateManagerException("Could not edit the Scenario because another scenario with same name '" + configuration.getName() + "' already exists.");
            }
            return this.processSaveConfiguration(configuration);
        }
        catch (RegistryException e) {
            throw new TemplateManagerException("Could not load the registry for Tenant: " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true), e);
        }
    }

    @Override
    public List<String> editConfiguration(ScenarioConfiguration configuration) throws TemplateManagerException {
        return this.processSaveConfiguration(configuration);
    }

    @Override
    public void saveStreamMapping(List<StreamMapping> streamMappingList, String scenarioConfigName, String domainName) throws TemplateManagerException {
        try {
            String resourceCollectionPath = "/repository/components/org.wso2.carbon.event.template.manager.core/template-config/" + domainName;
            String resourcePath = resourceCollectionPath + "/" + scenarioConfigName + ".xml";
            ScenarioConfiguration scenarioConfiguration = TemplateManagerHelper.getConfiguration(resourcePath);
            StreamMappings streamMappings = new StreamMappings();
            streamMappings.setStreamMapping(streamMappingList);
            scenarioConfiguration.setStreamMappings(streamMappings);
            TemplateManagerHelper.saveToRegistry(scenarioConfiguration);
            String planName = TemplateManagerHelper.getStreamMappingPlanId(domainName, scenarioConfigName);
            String executionPlan = TemplateManagerHelper.generateExecutionPlan(streamMappingList, planName);
            DeployableTemplate deployableTemplate = new DeployableTemplate();
            deployableTemplate.setArtifact(executionPlan);
            deployableTemplate.setConfiguration(scenarioConfiguration);
            deployableTemplate.setArtifactId(planName);
            TemplateDeployer deployer = TemplateManagerValueHolder.getTemplateDeployers().get("realtime");
            if (deployer == null) {
                throw new TemplateManagerException("A deployer doesn't exist for template type realtime");
            }
            deployer.deployArtifact(deployableTemplate);
        }
        catch (TemplateDeploymentException e) {
            throw new TemplateManagerException("Failed to deploy stream-mapping-execution plan, hence event flow will not be complete for Template Configuration: " + scenarioConfigName + " in domain: " + domainName, e);
        }
    }

    @Override
    public Collection<Domain> getAllDomains() {
        return this.domains.values();
    }

    @Override
    public Collection<ScenarioConfiguration> getConfigurations(String domainName) throws TemplateManagerException {
        ArrayList<ScenarioConfiguration> scenarioConfigurations = new ArrayList<ScenarioConfiguration>();
        String domainFilePath = "/repository/components/org.wso2.carbon.event.template.manager.core/template-config/" + domainName;
        try {
            Resource resource;
            UserRegistry registry = TemplateManagerValueHolder.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            if (registry.resourceExists(domainFilePath) && (resource = registry.get(domainFilePath)) instanceof org.wso2.carbon.registry.core.Collection) {
                this.loadConfigurations(((org.wso2.carbon.registry.core.Collection)resource).getChildren(), scenarioConfigurations);
            }
        }
        catch (RegistryException e) {
            throw new TemplateManagerException("Registry exception occurred when accessing files at /repository/components/org.wso2.carbon.event.template.manager.core/template-config", e);
        }
        return scenarioConfigurations;
    }

    private void loadConfigurations(String[] filePaths, Collection<ScenarioConfiguration> scenarioConfigurations) throws TemplateManagerException {
        for (String filePath : filePaths) {
            scenarioConfigurations.add(TemplateManagerHelper.getConfiguration(filePath));
        }
    }

    @Override
    public Domain getDomain(String domainName) {
        return this.domains.get(domainName);
    }

    @Override
    public ScenarioConfiguration getConfiguration(String domainName, String configName) throws TemplateManagerException {
        return TemplateManagerHelper.getConfiguration("/repository/components/org.wso2.carbon.event.template.manager.core/template-config/" + domainName + "/" + configName + ".xml");
    }

    @Override
    public void deleteConfiguration(String domainName, String configName) throws TemplateManagerException {
        ScenarioConfiguration scenarioConfig = null;
        try {
            scenarioConfig = TemplateManagerHelper.getConfiguration("/repository/components/org.wso2.carbon.event.template.manager.core/template-config/" + domainName + "/" + configName + ".xml");
            UserRegistry registry = TemplateManagerValueHolder.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            registry.delete("/repository/components/org.wso2.carbon.event.template.manager.core/template-config/" + domainName + "/" + configName + ".xml");
        }
        catch (RegistryException e) {
            log.error((Object)("Configuration exception when deleting registry configuration file " + configName + " of Domain " + domainName), (Throwable)e);
        }
        try {
            Object artifactType;
            Domain domain = this.getDomain(domainName);
            for (Scenario scenario : domain.getScenarios().getScenario()) {
                if (!scenarioConfig.getScenario().equals(scenario.getType())) continue;
                HashMap<Object, Integer> artifactTypeCountingMap = new HashMap<Object, Integer>();
                for (Template template : scenario.getTemplates().getTemplate()) {
                    artifactType = template.getType();
                    Integer artifactCount = (Integer)artifactTypeCountingMap.get(artifactType);
                    if (artifactCount == null) {
                        artifactCount = 1;
                    } else {
                        Integer n = artifactCount;
                        Integer n2 = artifactCount = Integer.valueOf(artifactCount + 1);
                    }
                    String artifactId = TemplateManagerHelper.getTemplatedArtifactId(domainName, scenario.getType(), configName, (String)artifactType, artifactCount);
                    TemplateManagerHelper.unDeployExistingArtifact(artifactId, template.getType());
                    artifactTypeCountingMap.put(artifactType, artifactCount);
                }
                String streamMappingPlanName = TemplateManagerHelper.getStreamMappingPlanId(domainName, scenarioConfig.getName());
                TemplateManagerHelper.unDeployExistingArtifact(streamMappingPlanName, "realtime");
                break;
            }
            if (this.getConfigurations(domainName).isEmpty() && domain.getCommonArtifacts() != null) {
                HashMap<String, Integer> artifactTypeCountingMap = new HashMap<String, Integer>();
                for (Artifact artifact : domain.getCommonArtifacts().getArtifact()) {
                    String artifactType2 = artifact.getType();
                    Integer artifactCount = (Integer)artifactTypeCountingMap.get(artifact.getType());
                    if (artifactCount == null) {
                        artifactCount = 1;
                    } else {
                        artifactType = artifactCount;
                        Integer n = artifactCount = Integer.valueOf(artifactCount + 1);
                    }
                    String artifactId = TemplateManagerHelper.getCommonArtifactId(domainName, artifactType2, artifactCount);
                    TemplateManagerHelper.unDeployExistingArtifact(artifactId, artifactType2);
                    artifactTypeCountingMap.put(artifactType2, artifactCount);
                }
            }
        }
        catch (TemplateDeploymentException e) {
            log.error((Object)("Configuration exception when un deploying script " + configName + " of Domain " + domainName), (Throwable)e);
        }
    }

    private List<String> processSaveConfiguration(ScenarioConfiguration configuration) throws TemplateManagerException {
        try {
            Domain domain = this.domains.get(configuration.getDomain());
            TemplateManagerHelper.saveToRegistry(configuration);
            ScriptEngine scriptEngine = TemplateManagerHelper.createJavaScriptEngine(domain);
            TemplateManagerHelper.deployArtifacts(configuration, domain, scriptEngine);
            return TemplateManagerHelper.getStreamIDsToBeMapped(configuration, this.getDomain(configuration.getDomain()), scriptEngine);
        }
        catch (TemplateDeploymentException e) {
            TemplateManagerHelper.deleteConfigWithoutUndeploy(configuration.getDomain(), configuration.getName());
            throw new TemplateManagerException("Failed to save Scenario: " + configuration.getName() + ", for Domain: " + configuration.getDomain(), e);
        }
    }
}

