/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.ui.executionPlan.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.ui.EventProcessorUIUtils;
import org.wso2.carbon.event.processor.ui.executionPlan.flow.siddhi.visitor.SiddhiFlowCompiler;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSourceReader;
import org.wso2.carbon.ndatasource.ui.stub.NDataSourceAdminDataSourceException;
import org.wso2.carbon.ndatasource.ui.stub.NDataSourceAdminStub;
import org.wso2.carbon.ndatasource.ui.stub.core.services.xsd.WSDataSourceInfo;
import org.wso2.carbon.ndatasource.ui.stub.core.services.xsd.WSDataSourceMetaInfo;
import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class ExtractJsonValueImpl {
    private static final Log log = LogFactory.getLog(ExtractJsonValueImpl.class);
    private String executionPlanText;
    private List<String> streamId = new ArrayList<String>();
    private List<String> streamAnno = new ArrayList<String>();
    private List<String> streamElement = new ArrayList<String>();
    private List<String> streamText = new ArrayList<String>();
    private List<String> streamMapId = new ArrayList<String>();
    private List<String> streamDefinition = new ArrayList<String>();
    private List<String> triggerName = new ArrayList<String>();
    private List<String> triggerText = new ArrayList<String>();
    private List<String> tableId = new ArrayList<String>();
    private List<String> tableText = new ArrayList<String>();
    private List<String> functionName = new ArrayList<String>();
    private List<String> functionText = new ArrayList<String>();
    private List<JsonArray> inputStream = new ArrayList<JsonArray>();
    private List<JsonArray> innerStream_in = new ArrayList<JsonArray>();
    private List<JsonArray> outputStream = new ArrayList<JsonArray>();
    private List<JsonArray> innerStream_out = new ArrayList<JsonArray>();
    private List<String> queryID = new ArrayList<String>();
    private List<String> queryName = new ArrayList<String>();
    private List<String> queryText = new ArrayList<String>();
    private List<String> queryWithPartition = new ArrayList<String>();
    private List<String> partitionWithText = new ArrayList<String>();
    private List<String> partitionText = new ArrayList<String>();
    private List<String> partitionWithStream = new ArrayList<String>();
    private List<JsonArray> partitionWithAttribute = new ArrayList<JsonArray>();
    private List<JsonArray> partitionWithCondition = new ArrayList<JsonArray>();
    private List<List<String>> partitionAttributeToolTip = new ArrayList<List<String>>();

    public void setJsonValues(String executionPlan, ServletConfig config, HttpSession session, HttpServletRequest request) {
        StringBuilder executionPlan_String = SiddhiFlowCompiler.parseString(executionPlan);
        this.createStreamDefinition(executionPlan, config, session, request);
        JsonElement jsonElement = new JsonParser().parse(executionPlan_String.toString());
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonArray executionPlanArray = jsonObject.getAsJsonArray("ExecutionPlan");
        for (int k = 0; k < executionPlanArray.size(); ++k) {
            if (executionPlanArray.get(k).getAsJsonObject().get("Stream") != null) {
                JsonArray streamArray = executionPlanArray.get(k).getAsJsonObject().getAsJsonArray("Stream");
                this.setStreamJsonValue(streamArray);
            }
            if (executionPlanArray.get(k).getAsJsonObject().get("Table") != null) {
                JsonArray tableArray = executionPlanArray.get(k).getAsJsonObject().getAsJsonArray("Table");
                this.setTableJsonValue(tableArray);
            }
            if (executionPlanArray.get(k).getAsJsonObject().get("Query") != null) {
                JsonArray queryArray = executionPlanArray.get(k).getAsJsonObject().getAsJsonArray("Query");
                this.setQueryJsonValue(queryArray, null);
            }
            if (executionPlanArray.get(k).getAsJsonObject().get("Trigger") != null) {
                JsonArray triggerArray = executionPlanArray.get(k).getAsJsonObject().getAsJsonArray("Trigger");
                this.setTriggerJsonValue(triggerArray);
            }
            if (executionPlanArray.get(k).getAsJsonObject().get("Function") != null) {
                JsonArray functionArray = executionPlanArray.get(k).getAsJsonObject().getAsJsonArray("Function");
                this.setTriggerJsonValue(functionArray);
            }
            if (executionPlanArray.get(k).getAsJsonObject().get("Partition") != null) {
                JsonArray partitionArray = executionPlanArray.get(k).getAsJsonObject().getAsJsonArray("Partition");
                this.setPartitionJsonValue(partitionArray);
            }
            if (executionPlanArray.get(k).getAsJsonObject().get("executionPlan_Text") == null) continue;
            this.executionPlanText = executionPlanArray.get(k).getAsJsonObject().get("executionPlan_Text").toString();
        }
    }

    private void createStreamDefinition(String executionPlan, ServletConfig config, HttpSession session, HttpServletRequest request) {
        SiddhiManager manager = new SiddhiManager();
        try {
            NDataSourceAdminStub stub = EventProcessorUIUtils.getNDataSourceAdminStub(config, session, request);
            WSDataSourceInfo[] allDataSources = stub.getAllDataSources();
            RDBMSDataSourceReader dsReader = new RDBMSDataSourceReader();
            for (WSDataSourceInfo info : allDataSources) {
                WSDataSourceMetaInfo metaInfo = info.getDsMetaInfo();
                Object dsObject = dsReader.createDataSource(metaInfo.getDefinition().getDsXMLConfiguration(), false);
                if (!(dsObject instanceof DataSource)) continue;
                manager.setDataSource(metaInfo.getName(), (DataSource)dsObject);
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error in getting data sources from NDataSourceAdminService", (Throwable)axisFault);
        }
        catch (RemoteException e) {
            log.error((Object)"Error in getting data sources from NDataSourceAdminService", (Throwable)e);
        }
        catch (NDataSourceAdminDataSourceException e) {
            log.error((Object)"Error in getting data sources from NDataSourceAdminService", (Throwable)e);
        }
        catch (DataSourceException e) {
            log.error((Object)"Error in getting data sources from NDataSourceAdminService", (Throwable)e);
        }
        String executionPlanCleaned = executionPlan.replaceAll("@from\\(.*?\\)", "");
        ExecutionPlanRuntime executionPlanRuntime = manager.createExecutionPlanRuntime(executionPlanCleaned);
        Map streamDefinitionMap = executionPlanRuntime.getStreamDefinitionMap();
        ArrayList<List> attributeList = new ArrayList<List>();
        for (AbstractDefinition ab : streamDefinitionMap.values()) {
            this.streamMapId.add(ab.getId());
            attributeList.add(ab.getAttributeList());
        }
        for (int j = 0; j < attributeList.size(); ++j) {
            StringBuilder stream = new StringBuilder();
            stream.append("\"define stream ").append(this.streamMapId.get(j)).append(" (");
            for (int i = 0; i < ((List)attributeList.get(j)).size(); ++i) {
                stream.append(" ").append(((Attribute)((List)attributeList.get(j)).get(i)).getName()).append(" ").append(((Attribute)((List)attributeList.get(j)).get(i)).getType().toString().toLowerCase()).append(",");
            }
            stream = new StringBuilder(stream.substring(0, stream.length() - 1));
            stream.append(")\"");
            this.streamDefinition.add(stream.toString());
        }
    }

    private void setStreamJsonValue(JsonArray streamArray) {
        for (int i = 0; i < streamArray.size(); ++i) {
            JsonObject streamObj = streamArray.get(i).getAsJsonObject();
            this.streamText.add(streamObj.get("stream_Text").toString());
            this.streamId.add(streamObj.get("streamId").toString());
            this.streamAnno.add(streamObj.get("annoName").toString());
            this.streamElement.add(streamObj.get("annoElement").toString());
        }
    }

    private void setTriggerJsonValue(JsonArray trigerArray) {
        for (int i = 0; i < trigerArray.size(); ++i) {
            JsonObject streamObj = trigerArray.get(i).getAsJsonObject();
            this.triggerName.add(streamObj.get("triggerName").toString());
            this.triggerText.add(streamObj.get("triggerText").toString());
        }
    }

    private void setFunctionJsonValue(JsonArray trigerArray) {
        for (int i = 0; i < trigerArray.size(); ++i) {
            JsonObject streamObj = trigerArray.get(i).getAsJsonObject();
            this.functionName.add(streamObj.get("functionName").toString());
            this.functionText.add(streamObj.get("functionText").toString());
        }
    }

    private void setTableJsonValue(JsonArray tableArray) {
        for (int i = 0; i < tableArray.size(); ++i) {
            JsonObject streamObj = tableArray.get(i).getAsJsonObject();
            this.tableText.add(streamObj.get("table_Text").toString());
            this.tableId.add(streamObj.get("tableId").toString());
        }
    }

    private void setQueryJsonValue(JsonArray queryArray, String partitionWith) {
        for (int i = 0; i < queryArray.size(); ++i) {
            JsonObject queryObj = queryArray.get(i).getAsJsonObject();
            this.queryName.add(queryObj.get("annotationElement").toString());
            this.queryText.add(queryObj.get("query_Text").toString().replaceAll("'", "\\\\'"));
            this.queryWithPartition.add(partitionWith);
            if (queryObj.get("inputStream").isJsonObject()) {
                JsonObject inputStreamObj = queryObj.getAsJsonObject("inputStream");
                this.inputStream.add(inputStreamObj.get("streamId").getAsJsonArray());
                this.innerStream_in.add(inputStreamObj.get("innerStream").getAsJsonArray());
            } else {
                JsonArray inputArray = queryObj.get("inputStream").getAsJsonArray();
                StringBuilder stream = new StringBuilder("[");
                StringBuilder inner = new StringBuilder("[");
                for (int l = 0; l < inputArray.size(); ++l) {
                    JsonObject jObj = inputArray.get(l).getAsJsonObject();
                    stream.append(jObj.get("streamId").getAsString()).append(",");
                    inner.append(jObj.get("innerStream").getAsString()).append(",");
                }
                stream = new StringBuilder(stream.substring(0, stream.length() - 1));
                stream.append("]");
                inner = new StringBuilder(inner.substring(0, inner.length() - 1));
                inner.append("]");
                JsonElement streamElement = new JsonParser().parse(stream.toString());
                JsonArray streamArray = streamElement.getAsJsonArray();
                JsonElement innerElement = new JsonParser().parse(inner.toString());
                JsonArray innerArray = innerElement.getAsJsonArray();
                this.inputStream.add(streamArray);
                this.innerStream_in.add(innerArray);
            }
            JsonObject outputStreamObj = queryObj.getAsJsonObject("outputStream");
            this.outputStream.add(outputStreamObj.get("streamId").getAsJsonArray());
            this.innerStream_out.add(outputStreamObj.get("innerStream").getAsJsonArray());
        }
    }

    private void setPartitionJsonValue(JsonArray partitionArray) {
        for (int m = 0; m < partitionArray.size(); ++m) {
            JsonObject partitionObj = partitionArray.get(m).getAsJsonObject();
            this.partitionWithText.add(partitionObj.get("Partition_with_Text").toString());
            this.partitionText.add(partitionObj.get("Partition_Text").toString());
            JsonArray partitionWith = partitionObj.getAsJsonArray("PartitionWith");
            JsonObject partitionWithObj = partitionWith.get(0).getAsJsonObject();
            this.partitionWithStream.add(partitionWithObj.get("Partition_Stream").toString());
            this.partitionWithAttribute.add(partitionWithObj.get("attribute").getAsJsonArray());
            this.partitionWithCondition.add(partitionWithObj.get("condition").getAsJsonArray());
            for (int j = 0; j < partitionObj.get("Query_size").getAsInt(); ++j) {
                JsonArray partitionQuery_Array = partitionObj.getAsJsonArray("Query_" + j);
                JsonObject partitionQuery_Obj = partitionQuery_Array.get(0).getAsJsonObject();
                JsonArray queryArray = partitionQuery_Obj.getAsJsonObject().getAsJsonArray("Query");
                this.setQueryJsonValue(queryArray, partitionObj.get("Partition_with_Text").toString());
            }
        }
    }

    public List<List<String>> getPartitionAttributeToolTip() {
        for (int i = 0; i < this.partitionWithAttribute.size(); ++i) {
            ArrayList<String> attribute_toolTip = new ArrayList<String>();
            for (int j = 0; j < this.partitionWithAttribute.get(i).size(); ++j) {
                if (!this.partitionWithCondition.get(i).toString().equals("[null]")) {
                    JsonArray attribute = this.partitionWithAttribute.get(i);
                    JsonArray condition = this.partitionWithCondition.get(i);
                    if (j == 0) {
                        attribute_toolTip.add("\"" + attribute.get(j).getAsString() + " : " + condition.get(j).getAsString() + "\"");
                        continue;
                    }
                    attribute_toolTip.add("\"\\n" + attribute.get(j).getAsString() + " : " + condition.get(j).getAsString() + "\"");
                    continue;
                }
                attribute_toolTip.add(null);
            }
            this.partitionAttributeToolTip.add(attribute_toolTip);
        }
        return this.partitionAttributeToolTip;
    }

    public List<String> getQueryID() {
        for (int i = 0; i < this.queryName.size(); ++i) {
            this.queryID.add("\"Q_" + i + "\"");
        }
        return this.queryID;
    }

    public String getExecutionPlanText() {
        return this.executionPlanText;
    }

    public List<String> getStreamId() {
        return this.streamId;
    }

    public List<String> getStreamAnno() {
        return this.streamAnno;
    }

    public List<String> getStreamElement() {
        return this.streamElement;
    }

    public List<String> getStreamText() {
        return this.streamText;
    }

    public List<String> getTableId() {
        return this.tableId;
    }

    public List<String> getTableText() {
        return this.tableText;
    }

    public List<String> getTriggerId() {
        return this.triggerName;
    }

    public List<String> getTriggerText() {
        return this.triggerText;
    }

    public List<String> getFunctionId() {
        return this.functionName;
    }

    public List<String> getFunctionText() {
        return this.functionText;
    }

    public List<JsonArray> getInputStream() {
        return this.inputStream;
    }

    public List<JsonArray> getInnerInputStream() {
        return this.innerStream_in;
    }

    public List<JsonArray> getInnerOutputStream() {
        return this.innerStream_out;
    }

    public List<JsonArray> getOutputStream() {
        return this.outputStream;
    }

    public List<String> getQueryText() {
        return this.queryText;
    }

    public List<String> getQueryName() {
        return this.queryName;
    }

    public List<String> getPartitionWithQuery() {
        return this.queryWithPartition;
    }

    public List<String> getPartitionWithText() {
        return this.partitionWithText;
    }

    public List<String> getPartitionText() {
        return this.partitionText;
    }

    public List<JsonArray> getPartitionWithAttribute() {
        return this.partitionWithAttribute;
    }

    public List<String> getPartitionWithStream() {
        return this.partitionWithStream;
    }

    public List<String> getStreamMapId() {
        return this.streamMapId;
    }

    public List<String> getStreamDefinition() {
        return this.streamDefinition;
    }
}

