/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.ui.executionPlan.flow;

import com.google.gson.JsonArray;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.ui.executionPlan.flow.ExtractJsonValueImpl;

public class ExecutionPlanFlow {
    private static final Log log = LogFactory.getLog(ExecutionPlanFlow.class);

    public String getExecutionPlanFlow(String executionPlanString, ServletConfig config, HttpSession session, HttpServletRequest request) {
        try {
            JsonArray inner;
            int j;
            JsonArray stream;
            int i;
            ExtractJsonValueImpl converter = new ExtractJsonValueImpl();
            converter.setJsonValues(executionPlanString, config, session, request);
            StringBuilder executionPlanFlow = new StringBuilder(" '{ \"nodes\": [ ");
            List<String> streamId = converter.getStreamId();
            List<String> streamText = converter.getStreamText();
            List<String> streamAnno = converter.getStreamAnno();
            List<String> streamElement = converter.getStreamElement();
            List<String> streamMapId = converter.getStreamMapId();
            List<String> streamDefinition = converter.getStreamDefinition();
            List<String> tableId = converter.getTableId();
            List<String> tableText = converter.getTableText();
            List<String> triggerId = converter.getTriggerId();
            List<String> triggerText = converter.getTriggerText();
            List<String> functionId = converter.getFunctionId();
            List<String> functionText = converter.getFunctionText();
            List<String> query_text = converter.getQueryText();
            List<String> queryName = converter.getQueryName();
            List<String> queryId = converter.getQueryID();
            List<JsonArray> inputStream = converter.getInputStream();
            List<JsonArray> innerInputStream = converter.getInnerInputStream();
            List<JsonArray> outputStream = converter.getOutputStream();
            List<JsonArray> innerOutputStream = converter.getInnerOutputStream();
            List<String> queryPartitionWith = converter.getPartitionWithQuery();
            List<String> partitionWithText = converter.getPartitionWithText();
            List<String> partitionText = converter.getPartitionText();
            List<JsonArray> attribute = converter.getPartitionWithAttribute();
            List<List<String>> partitionAttributeToolTip = converter.getPartitionAttributeToolTip();
            for (i = 0; i < streamId.size(); ++i) {
                if (streamAnno.get(i).equals("null")) continue;
                if (streamElement.get(i).equals("null")) {
                    executionPlanFlow.append("{ \"id\": \"").append(i).append("\", \"label\":").append(streamId.get(i)).append(",");
                } else {
                    executionPlanFlow.append("{ \"id\": ").append(streamElement.get(i).toUpperCase()).append(", \"label\":").append(streamElement.get(i)).append(",");
                }
                executionPlanFlow.append("\"toolTip\": ").append(streamText.get(i)).append(",");
                if (streamAnno.get(i).equals("\"Import\"")) {
                    executionPlanFlow.append("\"nodeclass\": \"I\"").append("},");
                    continue;
                }
                if (!streamAnno.get(i).equals("\"Export\"")) continue;
                executionPlanFlow.append("\"nodeclass\": \"E\"").append("},");
            }
            for (i = 0; i < tableId.size(); ++i) {
                executionPlanFlow.append("{ \"id\": ").append(tableId.get(i).toUpperCase()).append(", \"label\":").append(tableId.get(i)).append(",");
                executionPlanFlow.append("\"toolTip\": ").append(tableText.get(i)).append(",");
                executionPlanFlow.append("\"nodeTable\": \"T\"").append("},");
            }
            for (i = 0; i < triggerId.size(); ++i) {
                executionPlanFlow.append("{ \"id\": ").append(triggerId.get(i).toUpperCase()).append(", \"label\":").append(triggerId.get(i)).append(",");
                executionPlanFlow.append("\"toolTip\": ").append(triggerText.get(i)).append(",");
                executionPlanFlow.append("\"nodeTable\": \"TR\"").append("},");
            }
            for (i = 0; i < functionId.size(); ++i) {
                executionPlanFlow.append("{ \"id\": ").append(functionId.get(i).toUpperCase()).append(", \"label\":").append(functionId.get(i)).append(",");
                executionPlanFlow.append("\"toolTip\": ").append(functionText.get(i)).append(",");
                executionPlanFlow.append("\"nodeTable\": \"TR\"").append("},");
            }
            for (i = 0; i < inputStream.size(); ++i) {
                stream = inputStream.get(i);
                for (j = 0; j < stream.size(); ++j) {
                    String inId;
                    executionPlanFlow.append("{ \"id\":\"").append(stream.get(j).getAsString().toUpperCase()).append("\", \"label\":\"").append(stream.get(j).getAsString()).append("\",");
                    inner = innerInputStream.get(i);
                    String isInner = "true";
                    if (inner.get(j).getAsString().equals(isInner)) {
                        executionPlanFlow.append("\"parent\": ").append(queryPartitionWith.get(i).toUpperCase()).append(",");
                    }
                    for (int k = 0; k < tableId.size(); ++k) {
                        inId = "\"" + stream.get(j).getAsString() + "\"";
                        if (!tableId.get(k).equals(inId)) continue;
                        executionPlanFlow.append("\"nodeTable\": \"T\"").append(",");
                        executionPlanFlow.append("\"toolTip\": ").append(tableText.get(k)).append(",");
                    }
                    for (int l = 0; l < streamMapId.size(); ++l) {
                        inId = stream.get(j).getAsString();
                        if (!streamMapId.get(l).equals(inId)) continue;
                        executionPlanFlow.append("\"toolTip\": ").append(streamDefinition.get(l)).append(",");
                    }
                    executionPlanFlow.append("\"nodeclass\": \"S\"").append("},");
                }
            }
            for (i = 0; i < outputStream.size(); ++i) {
                if (outputStream.get(i).getAsString().equals("null")) continue;
                stream = outputStream.get(i);
                for (j = 0; j < stream.size(); ++j) {
                    String outId;
                    executionPlanFlow.append("{ \"id\":\"").append(stream.get(j).getAsString().toUpperCase()).append("\", \"label\":\"").append(stream.get(j).getAsString()).append("\",");
                    inner = innerOutputStream.get(i);
                    if (inner.get(j).getAsString().equals("\"true\"")) {
                        executionPlanFlow.append("\"parent\": ").append(queryPartitionWith.get(i).toUpperCase()).append(",");
                    }
                    for (int k = 0; k < tableId.size(); ++k) {
                        outId = "\"" + stream.get(j).getAsString() + "\"";
                        if (!tableId.get(k).equals(outId)) continue;
                        executionPlanFlow.append("\"nodeTable\": \"T\"").append(",");
                        executionPlanFlow.append("\"toolTip\": ").append(tableText.get(k)).append(",");
                    }
                    for (int l = 0; l < streamMapId.size(); ++l) {
                        outId = stream.get(j).getAsString();
                        if (!streamMapId.get(l).equals(outId)) continue;
                        executionPlanFlow.append("\"toolTip\": ").append(streamDefinition.get(l)).append(",");
                    }
                    executionPlanFlow.append("\"nodeclass\": \"S\"").append("},");
                }
            }
            for (i = 0; i < queryName.size(); ++i) {
                executionPlanFlow.append("{ \"id\": ").append(queryId.get(i)).append(", \"label\":").append(queryName.get(i)).append(",");
                if (queryPartitionWith.get(i) != null) {
                    executionPlanFlow.append("\"parent\": ").append(queryPartitionWith.get(i).toUpperCase()).append(",");
                }
                executionPlanFlow.append("\"toolTip\": ").append(query_text.get(i)).append(",\"nodeclass\": \"Q\"").append("},");
            }
            for (i = 0; i < attribute.size(); ++i) {
                executionPlanFlow.append("{ \"id\": ").append(attribute.get(i).toString().toUpperCase()).append(", \"label\":").append(attribute.get(i).toString()).append(",\"nodeclass\": \"P\"").append(",\"parent\": ").append(partitionWithText.get(i).toUpperCase()).append(",\"toolTip\": ").append(partitionAttributeToolTip.get(i).toString()).append("},");
            }
            executionPlanFlow = new StringBuilder(executionPlanFlow.substring(0, executionPlanFlow.length() - 1));
            executionPlanFlow.append("], \"partitionWith\": [ ");
            for (i = 0; i < partitionWithText.size(); ++i) {
                executionPlanFlow.append("{ \"id\": ").append(partitionWithText.get(i).toUpperCase()).append(", \"label\":").append("\"*\"").append(",\"nodeclass\": \"PW\"").append(",\"toolTip\": ").append(partitionText.get(i)).append("},");
            }
            executionPlanFlow = new StringBuilder(executionPlanFlow.substring(0, executionPlanFlow.length() - 1));
            executionPlanFlow.append("], \"edges\": [ ");
            for (i = 0; i < outputStream.size(); ++i) {
                if (outputStream.get(i).getAsString().equals("null")) continue;
                stream = outputStream.get(i);
                for (j = 0; j < stream.size(); ++j) {
                    executionPlanFlow.append("  { \"from\": ").append(queryId.get(i)).append(", \"to\":\"").append(stream.get(j).getAsString().toUpperCase()).append("\" },");
                }
            }
            for (i = 0; i < inputStream.size(); ++i) {
                stream = inputStream.get(i);
                for (j = 0; j < stream.size(); ++j) {
                    inner = innerInputStream.get(i);
                    if (!inner.get(j).getAsString().equals("true")) {
                        if (queryPartitionWith.get(i) == null) {
                            executionPlanFlow.append("  { \"from\": \"").append(stream.get(j).getAsString().toUpperCase()).append("\", \"to\":").append(queryId.get(i)).append(" },");
                            continue;
                        }
                        for (int k = 0; k < partitionWithText.size(); ++k) {
                            if (!queryPartitionWith.get(i).equals(partitionWithText.get(k))) continue;
                            executionPlanFlow.append("  { \"from\": \"").append(stream.get(j).getAsString().toUpperCase()).append("\", \"to\":").append(attribute.get(k).toString().toUpperCase()).append(" },");
                            executionPlanFlow.append("  { \"from\": ").append(attribute.get(k).toString().toUpperCase()).append(", \"to\":").append(queryId.get(i)).append(" },");
                        }
                        continue;
                    }
                    executionPlanFlow.append("  { \"from\": \"").append(stream.get(j).getAsString().toUpperCase()).append("\", \"to\":").append(queryId.get(i)).append(" },");
                }
            }
            for (i = 0; i < inputStream.size(); ++i) {
                stream = inputStream.get(i);
                for (j = 0; j < stream.size(); ++j) {
                    String inStream = "\"" + stream.get(j).getAsString() + "\"";
                    for (int k = 0; k < streamId.size(); ++k) {
                        if (streamId.get(k).equals(inStream) && !streamElement.get(k).equals("null")) {
                            executionPlanFlow.append("  { \"from\": ").append(streamElement.get(k).toUpperCase()).append(", \"to\":\"").append(stream.get(j).getAsString().toUpperCase()).append("\" },");
                            continue;
                        }
                        if (!streamId.get(k).equals(inStream) || !streamAnno.get(k).equals("\"Import\"")) continue;
                        executionPlanFlow.append("  { \"from\": \"").append(k).append("\", \"to\":\"").append(stream.get(j).getAsString().toUpperCase()).append("\" },");
                    }
                }
            }
            for (i = 0; i < outputStream.size(); ++i) {
                if (outputStream.get(i).getAsString().equals("null")) continue;
                stream = outputStream.get(i);
                for (j = 0; j < stream.size(); ++j) {
                    String outStream = "\"" + stream.get(j).getAsString() + "\"";
                    for (int k = 0; k < streamId.size(); ++k) {
                        if (streamId.get(k).equals(outStream) && !streamElement.get(k).equals("null")) {
                            executionPlanFlow.append("  { \"from\": \"").append(stream.get(j).getAsString().toUpperCase()).append("\", \"to\":").append(streamElement.get(k).toUpperCase()).append(" },");
                            continue;
                        }
                        if (!streamId.get(k).equals(outStream) || !streamAnno.get(k).equals("\"Export\"")) continue;
                        executionPlanFlow.append("  { \"from\": \"").append(stream.get(j).getAsString().toUpperCase()).append("\", \"to\":\"").append(k).append("\" },");
                    }
                }
            }
            executionPlanFlow = new StringBuilder(executionPlanFlow.substring(0, executionPlanFlow.length() - 1));
            executionPlanFlow.append("]}'");
            return executionPlanFlow.toString();
        }
        catch (RuntimeException e) {
            log.error((Object)("Error in visualizing execution plan '" + executionPlanString + "', " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

