/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.event.processor.stub.EventProcessorAdminServiceStub;
import org.wso2.carbon.event.processor.stub.types.StreamDefinitionDto;
import org.wso2.carbon.event.stream.stub.EventStreamAdminServiceStub;
import org.wso2.carbon.ndatasource.ui.stub.NDataSourceAdminStub;
import org.wso2.carbon.ui.CarbonUIUtil;

public class EventProcessorUIUtils {
    public static EventProcessorAdminServiceStub getEventProcessorAdminService(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session) + "EventProcessorAdminService.EventProcessorAdminServiceHttpsSoap12Endpoint";
        EventProcessorAdminServiceStub stub = new EventProcessorAdminServiceStub(configContext, serverURL);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        ServiceClient client = stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        return stub;
    }

    public static EventStreamAdminServiceStub getEventStreamAdminService(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session) + "EventStreamAdminService.EventStreamAdminServiceHttpsSoap12Endpoint";
        EventStreamAdminServiceStub stub = new EventStreamAdminServiceStub(configContext, serverURL);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        ServiceClient client = stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        return stub;
    }

    public static NDataSourceAdminStub getNDataSourceAdminStub(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session) + "NDataSourceAdmin";
        NDataSourceAdminStub stub = new NDataSourceAdminStub(configContext, serverURL);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        ServiceClient client = stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        return stub;
    }

    public static String getJsonStreamDefinition(StreamDefinitionDto streamDefinitionDto) {
        JsonObject rootObject = new JsonObject();
        if (streamDefinitionDto == null) {
            return "";
        }
        rootObject.add("name", (JsonElement)new JsonPrimitive(streamDefinitionDto.getName()));
        rootObject.add("version", (JsonElement)new JsonPrimitive("1.0.0"));
        JsonArray metaData = new JsonArray();
        if (streamDefinitionDto.getMetaData() != null) {
            for (String metaAttribute : streamDefinitionDto.getMetaData()) {
                String[] attributeParts = metaAttribute.trim().split(" ");
                JsonObject attribute = new JsonObject();
                attribute.add("name", (JsonElement)new JsonPrimitive(attributeParts[0]));
                attribute.add("type", (JsonElement)new JsonPrimitive(attributeParts[1].toLowerCase()));
                metaData.add((JsonElement)attribute);
            }
        }
        rootObject.add("metaData", (JsonElement)metaData);
        JsonArray correlationData = new JsonArray();
        if (streamDefinitionDto.getCorrelationData() != null) {
            for (String correlationAttribute : streamDefinitionDto.getCorrelationData()) {
                String[] attributeParts = correlationAttribute.trim().split(" ");
                JsonObject attribute = new JsonObject();
                attribute.add("name", (JsonElement)new JsonPrimitive(attributeParts[0]));
                attribute.add("type", (JsonElement)new JsonPrimitive(attributeParts[1].toLowerCase()));
                correlationData.add((JsonElement)attribute);
            }
        }
        rootObject.add("correlationData", (JsonElement)correlationData);
        JsonArray payloadData = new JsonArray();
        if (streamDefinitionDto.getPayloadData() != null) {
            for (String payloadAttribute : streamDefinitionDto.getPayloadData()) {
                String[] attributeParts = payloadAttribute.trim().split(" ");
                JsonObject attribute = new JsonObject();
                attribute.add("name", (JsonElement)new JsonPrimitive(attributeParts[0]));
                attribute.add("type", (JsonElement)new JsonPrimitive(attributeParts[1].toLowerCase()));
                payloadData.add((JsonElement)attribute);
            }
        }
        rootObject.add("payloadData", (JsonElement)payloadData);
        return rootObject.toString();
    }
}

