/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.util;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.text.ParseException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.SameSiteCookie;
import org.wso2.carbon.core.ServletCookie;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oidc.session.DefaultOIDCSessionStateManager;
import org.wso2.carbon.identity.oidc.session.OIDCSessionManager;
import org.wso2.carbon.identity.oidc.session.OIDCSessionStateManager;
import org.wso2.carbon.identity.oidc.session.config.OIDCSessionManagementConfiguration;

public class OIDCSessionManagementUtil {
    private static final String RANDOM_ALG_SHA1 = "SHA1PRNG";
    private static final String DIGEST_ALG_SHA256 = "SHA-256";
    private static final String OIDC_SESSION_STATE_MANAGER_CONFIG = "OAuth.OIDCSessionStateManager";
    private static final OIDCSessionManager sessionManager = new OIDCSessionManager();
    private static OIDCSessionStateManager oidcSessionStateManager;
    private static final Log log;

    private OIDCSessionManagementUtil() {
    }

    public static OIDCSessionManager getSessionManager() {
        return sessionManager;
    }

    public static String getSessionStateParam(String clientId, String rpCallBackUrl, String opBrowserState) {
        return OIDCSessionManagementUtil.getOIDCessionStateManager().getSessionStateParam(clientId, rpCallBackUrl, opBrowserState);
    }

    public static String addSessionStateToURL(String url, String sessionState, String responseType) {
        if (StringUtils.isNotBlank((String)url) && StringUtils.isNotBlank((String)sessionState)) {
            if (OAuth2Util.isImplicitResponseType((String)responseType) || OAuth2Util.isHybridResponseType((String)responseType)) {
                if (url.indexOf(35) > 0) {
                    return url + "&" + "session_state" + "=" + sessionState;
                }
                return url + "#" + "session_state" + "=" + sessionState;
            }
            if (url.indexOf(63) > 0) {
                return url + "&" + "session_state" + "=" + sessionState;
            }
            return url + "?" + "session_state" + "=" + sessionState;
        }
        return url;
    }

    public static String addSessionStateToURL(String url, String clientId, String rpCallBackUrl, Cookie opBrowserStateCookie, String responseType) {
        String sessionStateParam = OIDCSessionManagementUtil.getSessionStateParam(clientId, rpCallBackUrl, opBrowserStateCookie == null ? null : opBrowserStateCookie.getValue());
        return OIDCSessionManagementUtil.addSessionStateToURL(url, sessionStateParam, responseType);
    }

    public static Cookie getOPBrowserStateCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !cookie.getName().equals("opbs")) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Cookie addOPBrowserStateCookie(HttpServletResponse response) {
        return OIDCSessionManagementUtil.getOIDCessionStateManager().addOPBrowserStateCookie(response);
    }

    public static Cookie removeOPBrowserStateCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("opbs")) continue;
                ServletCookie servletCookie = new ServletCookie(cookie.getName(), cookie.getValue());
                servletCookie.setMaxAge(0);
                servletCookie.setSecure(true);
                servletCookie.setPath("/");
                servletCookie.setSameSite(SameSiteCookie.NONE);
                response.addCookie((Cookie)servletCookie);
                return cookie;
            }
        }
        return null;
    }

    public static String getOrigin(String url) {
        try {
            URI uri = new URI(url);
            return uri.getScheme() + "://" + uri.getAuthority();
        }
        catch (URISyntaxException e) {
            log.error((Object)("Error while parsing URL origin of " + url + ". URL seems to be malformed."));
            return null;
        }
    }

    public static String getOIDCLogoutConsentURL() {
        return OAuth2Util.buildServiceUrl((String)"/authenticationendpoint/oauth2_logout_consent.do", (String)OIDCSessionManagementConfiguration.getInstance().getOIDCLogoutConsentPageUrl());
    }

    public static String getOIDCLogoutURL() {
        return OAuth2Util.buildServiceUrl((String)"/authenticationendpoint/oauth2_logout.do", (String)OIDCSessionManagementConfiguration.getInstance().getOIDCLogoutPageUrl());
    }

    public static String getErrorPageURL(String errorCode, String errorMessage) {
        String errorPageUrl;
        block2: {
            errorPageUrl = OAuth2Util.OAuthURL.getOAuth2ErrorPageUrl();
            try {
                errorPageUrl = errorPageUrl + "?oauthErrorCode=" + URLEncoder.encode(errorCode, "UTF-8") + "&" + "oauthErrorMsg" + "=" + URLEncoder.encode(errorMessage, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Error while encoding the error page url", (Throwable)e);
            }
        }
        return errorPageUrl;
    }

    public static boolean getOpenIDConnectSkipeUserConsent() {
        return OAuthServerConfiguration.getInstance().getOpenIDConnectSkipeUserConsentConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OIDCSessionStateManager getOIDCessionStateManager() {
        if (oidcSessionStateManager != null) return oidcSessionStateManager;
        Class<OIDCSessionManagementUtil> clazz = OIDCSessionManagementUtil.class;
        synchronized (OIDCSessionManagementUtil.class) {
            if (oidcSessionStateManager != null) return oidcSessionStateManager;
            OIDCSessionManagementUtil.initOIDCSessionStateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return oidcSessionStateManager;
        }
    }

    private static void initOIDCSessionStateManager() {
        String oidcSessionStateManagerClassName = IdentityUtil.getProperty((String)OIDC_SESSION_STATE_MANAGER_CONFIG);
        if (StringUtils.isNotBlank((String)oidcSessionStateManagerClassName)) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(oidcSessionStateManagerClassName);
                oidcSessionStateManager = (OIDCSessionStateManager)clazz.newInstance();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("An instance of " + oidcSessionStateManagerClassName + " is created for OIDCSessionManagementUtil."));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                String errorMsg = "Error when instantiating the OIDCSessionStateManager : " + oidcSessionStateManagerClassName + ". Defaulting to DefaultOIDCSessionStateManager";
                log.error((Object)errorMsg, (Throwable)e);
                oidcSessionStateManager = new DefaultOIDCSessionStateManager();
            }
        } else {
            oidcSessionStateManager = new DefaultOIDCSessionStateManager();
        }
    }

    public static boolean handleAlreadyLoggedOutSessionsGracefully() {
        return OIDCSessionManagementConfiguration.getInstance().handleAlreadyLoggedOutSessionsGracefully();
    }

    public static JWT decryptWithRSA(String tenantDomain, String idToken) throws IdentityOAuth2Exception {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
        try {
            RSAPrivateKey privateKey;
            if (!tenantDomain.equals("carbon.super")) {
                String ksName = tenantDomain.trim().replace(".", "-");
                String jksName = ksName + ".jks";
                privateKey = (RSAPrivateKey)keyStoreManager.getPrivateKey(jksName, tenantDomain);
            } else {
                privateKey = (RSAPrivateKey)keyStoreManager.getDefaultPrivateKey();
            }
            EncryptedJWT encryptedJWT = EncryptedJWT.parse((String)idToken);
            RSADecrypter decrypter = new RSADecrypter((PrivateKey)privateKey);
            encryptedJWT.decrypt((JWEDecrypter)decrypter);
            return encryptedJWT;
        }
        catch (JOSEException | ParseException e) {
            throw new IdentityOAuth2Exception("Error occurred while decrypting the JWE.", e);
        }
        catch (Exception e) {
            throw new IdentityOAuth2Exception("Error occurred while retrieving private key for decryption.", (Throwable)e);
        }
    }

    public static String extractClientIDFromDecryptedIDToken(JWT decryptedIDToken) throws ParseException {
        String clientId = (String)decryptedIDToken.getJWTClaimsSet().getClaims().get("azp");
        if (StringUtils.isBlank((String)clientId)) {
            clientId = (String)decryptedIDToken.getJWTClaimsSet().getAudience().get(0);
            log.info((Object)"Provided ID Token does not contain azp claim with client ID. Hence client ID is extracted from the aud claim in the ID Token.");
        }
        return clientId;
    }

    public static boolean isIDTokenEncrypted(String idToken) {
        return StringUtils.countMatches((String)idToken, (String)".") == 4;
    }

    static {
        log = LogFactory.getLog(OIDCSessionManagementUtil.class);
    }
}

