/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oidc.session.OIDCSessionManagerException;
import org.wso2.carbon.identity.oidc.session.util.OIDCSessionManagementUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class OIDCSessionIFrameServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(OIDCSessionIFrameServlet.class);
    private static final String CLIENT_ORIGIN_PLACE_HOLDER = "CLIENT_ORIGIN";
    private static final String ERROR_RESPONSE = "<html><body>Invalid OP IFrame Request</body></html>";
    private static final String OP_IFRAME_RESOURCE = "op_iframe.html";
    private static final long serialVersionUID = 601536694998426357L;
    private static StringBuilder opIFrame = null;

    public void init() throws ServletException {
        this.loadOPIFrame();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        String clientId = request.getParameter("client_id");
        try {
            if (StringUtils.isBlank((String)clientId)) {
                throw new OIDCSessionManagerException("Invalid request. client_id not found in request as parameter.");
            }
            String callbackURL = this.getCallbackURL(request, clientId);
            String clientOrigin = OIDCSessionManagementUtil.getOrigin(callbackURL);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Client Origin : " + clientOrigin));
            }
            response.getWriter().print(this.getOPIFrame(clientOrigin));
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            log.error((Object)("Error while retrieving OAuth application information for the provided client id : " + clientId + ", " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            response.getWriter().print(ERROR_RESPONSE);
        }
        catch (OIDCSessionManagerException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            response.getWriter().print(ERROR_RESPONSE);
        }
    }

    private String getCallbackURL(HttpServletRequest request, String clientId) throws InvalidOAuthClientException, IdentityOAuth2Exception, OIDCSessionManagerException {
        OAuthAppDAO oAuthAppDAO = new OAuthAppDAO();
        OAuthAppDO oAuthAppDO = oAuthAppDAO.getAppInformation(clientId);
        String configuredCallbackURL = oAuthAppDO.getCallbackUrl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requested client_id : " + clientId + " Configured callbackUrl : " + configuredCallbackURL));
        }
        if (StringUtils.isBlank((String)configuredCallbackURL)) {
            throw new OIDCSessionManagerException("CallbackURL is empty in service provider configuration, clientId : " + clientId);
        }
        if (configuredCallbackURL.startsWith("regexp=")) {
            String regexp;
            String rpIFrameReqCallbackURL;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Regex value found for callback url in service provider.");
            }
            if (StringUtils.isBlank((String)(rpIFrameReqCallbackURL = request.getParameter("redirect_uri")))) {
                throw new OIDCSessionManagerException("Invalid request. redirect_uri not found in request as parameter. It is mandatory because of there is regex pattern for callback url in service provider configuration. client_id : " + clientId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Requested redirect_uri from rp IFrame : " + rpIFrameReqCallbackURL));
            }
            if (rpIFrameReqCallbackURL.matches(regexp = configuredCallbackURL.substring("regexp=".length()))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Requested redirect_uri is matched with the regex in service provider.");
                }
                configuredCallbackURL = rpIFrameReqCallbackURL;
            } else {
                throw new OIDCSessionManagerException("Invalid request. redirect_uri is not matched with the regex that is configured in the service provider, client_id : " + clientId);
            }
        }
        return configuredCallbackURL;
    }

    private String getOPIFrame(String clientOrigin) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put(CLIENT_ORIGIN_PLACE_HOLDER, clientOrigin);
        StrSubstitutor substitutor = new StrSubstitutor(valuesMap);
        return substitutor.replace(opIFrame.toString());
    }

    private void loadOPIFrame() {
        opIFrame = new StringBuilder();
        Path opIframeHtmlPath = Paths.get(CarbonUtils.getCarbonHome(), "repository", "resources", "identity", "pages", OP_IFRAME_RESOURCE);
        if (Files.exists(opIframeHtmlPath, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(opIframeHtmlPath, new OpenOption[0]);){
                int i;
                while ((i = inputStream.read()) > 0) {
                    opIFrame.append((char)i);
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to load OP IFrame", (Throwable)e);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to load OP IFrame from external directory path: " + opIframeHtmlPath));
            }
            try (InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(OP_IFRAME_RESOURCE);){
                int i;
                while ((i = inputStream.read()) > 0) {
                    opIFrame.append((char)i);
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to load OP IFrame", (Throwable)e);
            }
        }
    }
}

