/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.servlet;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.CommonAuthenticationHandler;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationRequest;
import org.wso2.carbon.identity.application.authentication.framework.model.CommonAuthRequestWrapper;
import org.wso2.carbon.identity.application.authentication.framework.model.CommonAuthResponseWrapper;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oidc.session.OIDCSessionManagementException;
import org.wso2.carbon.identity.oidc.session.OIDCSessionState;
import org.wso2.carbon.identity.oidc.session.backchannellogout.LogoutRequestSender;
import org.wso2.carbon.identity.oidc.session.cache.OIDCSessionDataCache;
import org.wso2.carbon.identity.oidc.session.cache.OIDCSessionDataCacheEntry;
import org.wso2.carbon.identity.oidc.session.cache.OIDCSessionDataCacheKey;
import org.wso2.carbon.identity.oidc.session.handler.OIDCLogoutHandler;
import org.wso2.carbon.identity.oidc.session.internal.OIDCSessionManagementComponentServiceHolder;
import org.wso2.carbon.identity.oidc.session.util.OIDCSessionManagementUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OIDCLogoutServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(OIDCLogoutServlet.class);
    private static final String REQUEST_PARAM_SP = "sp";
    private static final long serialVersionUID = -9203934217770142011L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Cookie opBrowserStateCookie = OIDCSessionManagementUtil.getOPBrowserStateCookie(request);
        if (opBrowserStateCookie == null) {
            String msg = "opbs cookie not received. Missing session state.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            if (OIDCSessionManagementUtil.handleAlreadyLoggedOutSessionsGracefully()) {
                this.handleMissingSessionStateGracefully(request, response);
                return;
            }
            if (log.isDebugEnabled()) {
                msg = "HandleAlreadyLoggedOutSessionsGracefully configuration disabled. Missing session state is handled by redirecting to error page instead of default logout page.";
                log.debug((Object)msg);
            }
            String redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg);
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
            return;
        }
        if (!OIDCSessionManagementUtil.getSessionManager().sessionExists(opBrowserStateCookie.getValue())) {
            String msg = "No valid session found for the received session state.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            if (OIDCSessionManagementUtil.handleAlreadyLoggedOutSessionsGracefully()) {
                this.handleMissingSessionStateGracefully(request, response);
                return;
            }
            if (log.isDebugEnabled()) {
                msg = "HandleAlreadyLoggedOutSessionsGracefully configuration enabled. No valid session found is handled by redirecting to error page instead of default logout page.";
                log.debug((Object)msg);
            }
            String redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg);
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
            return;
        }
        String consent = request.getParameter("consent");
        if (StringUtils.isNotBlank((String)consent)) {
            if (consent.equals("approve")) {
                this.sendToFrameworkForLogout(request, response);
                return;
            }
        } else {
            boolean skipConsent;
            String sessionDataKey = request.getParameter("sessionDataKey");
            if (sessionDataKey != null) {
                this.handleLogoutResponseFromFramework(request, response);
                return;
            }
            String idTokenHint = request.getParameter("id_token_hint");
            try {
                skipConsent = this.getOpenIDConnectSkipUserConsent(request);
            }
            catch (ParseException e) {
                log.error((Object)"Error while getting clientId from the IdTokenHint.", (Throwable)e);
                String redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", "ID token signature validation failed.");
                response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
                return;
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)"Error while getting service provider from the clientId.", (Throwable)e);
                String redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", "ID token signature validation failed.");
                response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
                return;
            }
            if (skipConsent) {
                if (StringUtils.isNotBlank((String)idTokenHint)) {
                    String redirectURL = this.processLogoutRequest(request, response);
                    if (StringUtils.isNotBlank((String)redirectURL)) {
                        response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
                        return;
                    }
                } else {
                    OIDCSessionDataCacheEntry cacheEntry = new OIDCSessionDataCacheEntry();
                    this.setStateParameterInCache(request, cacheEntry);
                    this.addSessionDataToCache(opBrowserStateCookie.getValue(), cacheEntry);
                }
                this.sendToFrameworkForLogout(request, response);
                return;
            }
            this.sendToConsentUri(request, response);
            return;
        }
        String redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", "End User denied the logout request");
        redirectURL = this.generatePostLogoutRedirectUrl(redirectURL, opBrowserStateCookie);
        response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
    }

    private String generatePostLogoutRedirectUrl(String redirectURL, Cookie opBrowserStateCookie) throws UnsupportedEncodingException {
        OIDCSessionDataCacheEntry cacheEntry;
        boolean postLogoutRedirectUriRedirectIsEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"OAuth.OpenIDConnect.RedirectToPostLogoutUriOnConsentDenial"));
        if (postLogoutRedirectUriRedirectIsEnabled && (cacheEntry = this.getSessionDataFromCache(opBrowserStateCookie.getValue())) != null && cacheEntry.getPostLogoutRedirectUri() != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("error", "access_denied");
            params.put("error_description", "End User denied the logout request");
            if (cacheEntry.getState() != null) {
                params.put("state", cacheEntry.getState());
            }
            redirectURL = FrameworkUtils.buildURLWithQueryParams((String)cacheEntry.getPostLogoutRedirectUri(), params);
        }
        return redirectURL;
    }

    private String processLogoutRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String clientId;
        String redirectURL = null;
        Cookie opBrowserStateCookie = OIDCSessionManagementUtil.getOPBrowserStateCookie(request);
        String idTokenHint = request.getParameter("id_token_hint");
        String postLogoutRedirectUri = request.getParameter("post_logout_redirect_uri");
        String state = request.getParameter("state");
        String appTenantDomain = null;
        try {
            if (OIDCSessionManagementUtil.isIDTokenEncrypted(idTokenHint)) {
                appTenantDomain = request.getParameter("tenant_domain");
                JWT decryptedIDToken = OIDCSessionManagementUtil.decryptWithRSA(appTenantDomain, idTokenHint);
                clientId = OIDCSessionManagementUtil.extractClientIDFromDecryptedIDToken(decryptedIDToken);
            } else {
                if (!this.validateIdToken(idTokenHint)) {
                    String msg = "ID token signature validation failed.";
                    log.error((Object)msg);
                    redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg);
                    return redirectURL;
                }
                clientId = this.extractClientFromIdToken(idTokenHint);
                appTenantDomain = OAuth2Util.getTenantDomainOfOauthApp((String)clientId);
                OAuth2Util.validateRequestTenantDomain((String)appTenantDomain);
            }
            OAuthAppDAO appDAO = new OAuthAppDAO();
            OAuthAppDO oAuthAppDO = appDAO.getAppInformation(clientId);
            String spName = this.getServiceProviderName(clientId, appTenantDomain);
            this.setSPAttributeToRequest(request, spName, appTenantDomain);
            if (!this.validatePostLogoutUri(postLogoutRedirectUri, oAuthAppDO.getCallbackUrl())) {
                String msg = "Post logout URI does not match with registered callback URI.";
                redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg);
                return FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request);
            }
        }
        catch (ParseException e) {
            String msg = "No valid session found for the received session state.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg);
            return FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request);
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            String msg = "Error occurred while getting application information. Client id not found.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, e);
            }
            redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg);
            return FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("client_id", clientId);
        paramMap.put("tenant_domain", appTenantDomain);
        OIDCSessionDataCacheEntry cacheEntry = new OIDCSessionDataCacheEntry();
        cacheEntry.setIdToken(idTokenHint);
        cacheEntry.setPostLogoutRedirectUri(postLogoutRedirectUri);
        cacheEntry.setState(state);
        cacheEntry.setParamMap(new ConcurrentHashMap<String, String>(paramMap));
        this.addSessionDataToCache(opBrowserStateCookie.getValue(), cacheEntry);
        return redirectURL;
    }

    private boolean validateIdToken(String idToken) {
        String tenantDomain = this.getTenantDomainForSignatureValidation(idToken);
        if (StringUtils.isEmpty((String)tenantDomain)) {
            return false;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        try {
            RSAPublicKey publicKey;
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
            if (!tenantDomain.equals("carbon.super")) {
                String ksName = tenantDomain.trim().replace(".", "-");
                String jksName = ksName + ".jks";
                publicKey = (RSAPublicKey)keyStoreManager.getKeyStore(jksName).getCertificate(tenantDomain).getPublicKey();
            } else {
                publicKey = (RSAPublicKey)keyStoreManager.getDefaultPublicKey();
            }
            SignedJWT signedJWT = SignedJWT.parse((String)idToken);
            RSASSAVerifier verifier = new RSASSAVerifier(publicKey);
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (JOSEException | ParseException e) {
            log.error((Object)"Error occurred while validating id token signature.");
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while validating id token signature.");
            return false;
        }
    }

    private String getTenantDomainForSignatureValidation(String idToken) {
        String tenantDomain;
        boolean isJWTSignedWithSPKey = OAuthServerConfiguration.getInstance().isJWTSignedWithSPKey();
        if (log.isDebugEnabled()) {
            log.debug((Object)("'SignJWTWithSPKey' property is set to : " + isJWTSignedWithSPKey));
        }
        try {
            String clientId = this.extractClientFromIdToken(idToken);
            if (isJWTSignedWithSPKey) {
                OAuthAppDO oAuthAppDO = OAuth2Util.getAppInformationByClientId((String)clientId);
                tenantDomain = OAuth2Util.getTenantDomainOfOauthApp((OAuthAppDO)oAuthAppDO);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JWT signature will be validated with the service provider's tenant domain : " + tenantDomain));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"JWT signature will be validated with user tenant domain.");
                }
                tenantDomain = this.extractTenantDomainFromIdToken(idToken);
            }
        }
        catch (ParseException e) {
            log.error((Object)"Error occurred while extracting client id from id token", (Throwable)e);
            return null;
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            log.error((Object)"Error occurred while getting oauth application information.", e);
            return null;
        }
        return tenantDomain;
    }

    private void sendToConsentUri(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String idTokenHint = request.getParameter("id_token_hint");
        String redirectURL = OIDCSessionManagementUtil.getOIDCLogoutConsentURL();
        if (idTokenHint != null) {
            redirectURL = this.processLogoutRequest(request, response);
            if (StringUtils.isNotBlank((String)redirectURL)) {
                response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
                return;
            }
            redirectURL = OIDCSessionManagementUtil.getOIDCLogoutConsentURL();
        } else {
            OIDCSessionDataCacheEntry cacheEntry = new OIDCSessionDataCacheEntry();
            this.setStateParameterInCache(request, cacheEntry);
            Cookie opBrowserStateCookie = OIDCSessionManagementUtil.getOPBrowserStateCookie(request);
            this.addSessionDataToCache(opBrowserStateCookie.getValue(), cacheEntry);
        }
        response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
    }

    private void setStateParameterInCache(HttpServletRequest request, OIDCSessionDataCacheEntry cacheEntry) {
        String state = request.getParameter("state");
        cacheEntry.setState(state);
    }

    private String appendStateQueryParam(String redirectURL, String stateParam) throws UnsupportedEncodingException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("state", stateParam);
        if (StringUtils.isNotEmpty((String)stateParam)) {
            redirectURL = FrameworkUtils.buildURLWithQueryParams((String)redirectURL, paramMap);
        }
        return redirectURL;
    }

    private boolean validatePostLogoutUri(String postLogoutUri, String registeredCallbackUri) {
        if (StringUtils.isEmpty((String)postLogoutUri)) {
            return true;
        }
        String regexp = null;
        if (registeredCallbackUri.startsWith("regexp=")) {
            regexp = registeredCallbackUri.substring("regexp=".length());
        }
        if (regexp != null && postLogoutUri.matches(regexp)) {
            return true;
        }
        if (registeredCallbackUri.equals(postLogoutUri)) {
            return true;
        }
        log.warn((Object)"Provided Post logout redirect URL does not match the registered callback url.");
        return false;
    }

    private String extractClientFromIdToken(String idToken) throws ParseException {
        String clientId = (String)SignedJWT.parse((String)idToken).getJWTClaimsSet().getClaims().get("azp");
        if (StringUtils.isBlank((String)clientId)) {
            clientId = (String)SignedJWT.parse((String)idToken).getJWTClaimsSet().getAudience().get(0);
            log.info((Object)"Provided ID Token does not contain azp claim with client ID. Client ID is extracted from the aud claim in the ID Token.");
        }
        return clientId;
    }

    private String extractTenantDomainFromIdToken(String idToken) throws ParseException {
        String tenantDomain = null;
        Map realm = null;
        JWTClaimsSet claimsSet = SignedJWT.parse((String)idToken).getJWTClaimsSet();
        if (claimsSet.getClaims().get("realm") instanceof Map) {
            realm = (Map)claimsSet.getClaims().get("realm");
        }
        if (realm != null) {
            tenantDomain = (String)realm.get("tenant");
        }
        if (StringUtils.isBlank(tenantDomain)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to retrieve tenant domain from 'realm' claim. Hence falling back to 'sub' claim.");
            }
            tenantDomain = MultitenantUtils.getTenantDomain((String)claimsSet.getSubject());
            if (log.isDebugEnabled()) {
                log.debug((Object)("User tenant domain derived from 'sub' claim of JWT. Tenant domain : " + tenantDomain));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("User tenant domain found in 'realm' claim of JWT. Tenant domain : " + tenantDomain));
        }
        return tenantDomain;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void sendToFrameworkForLogout(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.triggerLogoutHandlersForPreLogout(request, response);
        }
        catch (OIDCSessionManagementException e) {
            log.error((Object)"Error executing logout handlers on pre logout.");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error executing logout handlers on pre logout.", (Throwable)((Object)e));
            }
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)OIDCSessionManagementUtil.getErrorPageURL("server_error", "User logout failed."), (HttpServletRequest)request));
        }
        String sessionDataKey = UUID.randomUUID().toString();
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("sessionDataKey", new String[]{sessionDataKey});
        authenticationRequest.setRequestQueryParams(map);
        authenticationRequest.addRequestQueryParam("commonAuthLogout", new String[]{"true"});
        try {
            authenticationRequest.setCommonAuthCallerPath(ServiceURLBuilder.create().addPath(new String[]{"/oidc/logout"}).build().getRelativeInternalURL());
        }
        catch (URLBuilderException e) {
            log.error((Object)"Error building commonauth caller path to send logout request to framework.", (Throwable)e);
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)OIDCSessionManagementUtil.getErrorPageURL("server_error", "User logout failed."), (HttpServletRequest)request));
        }
        authenticationRequest.setPost(true);
        Cookie opBrowserStateCookie = OIDCSessionManagementUtil.getOPBrowserStateCookie(request);
        OIDCSessionDataCacheEntry cacheEntry = this.getSessionDataFromCache(opBrowserStateCookie.getValue());
        if (cacheEntry != null) {
            authenticationRequest.setRelyingParty((String)cacheEntry.getParamMap().get("client_id"));
            authenticationRequest.setTenantDomain((String)cacheEntry.getParamMap().get("tenant_domain"));
            this.addSessionDataToCache(sessionDataKey, cacheEntry);
        }
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String headerName = e.nextElement().toString();
            authenticationRequest.addHeader(headerName, request.getHeader(headerName));
        }
        AuthenticationRequestCacheEntry authenticationRequestCacheEntry = new AuthenticationRequestCacheEntry(authenticationRequest);
        this.addAuthenticationRequestToRequest(request, authenticationRequestCacheEntry);
        this.sendRequestToFramework(request, response, sessionDataKey, "oidc");
    }

    private void handleLogoutResponseFromFramework(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sessionDataKey = request.getParameter("sessionDataKey");
        OIDCSessionDataCacheEntry cacheEntry = this.getSessionDataFromCache(sessionDataKey);
        if (cacheEntry != null) {
            if (log.isDebugEnabled()) {
                String clientId = (String)cacheEntry.getParamMap().get("client_id");
                log.debug((Object)("Logout request received from client: " + clientId));
                Cookie opbsCookie = OIDCSessionManagementUtil.getOPBrowserStateCookie(request);
                if (opbsCookie != null) {
                    String obpsCookieValue = opbsCookie.getValue();
                    OIDCSessionState sessionState = OIDCSessionManagementUtil.getSessionManager().getOIDCSessionState(obpsCookieValue);
                    if (sessionState != null) {
                        String sidClaim = sessionState.getSidClaim();
                        log.debug((Object)("Logout request received for sessionId: " + sidClaim));
                    }
                }
            }
            this.doBackChannelLogout(request);
            String redirectURL = cacheEntry.getPostLogoutRedirectUri();
            if (redirectURL == null) {
                redirectURL = OIDCSessionManagementUtil.getOIDCLogoutURL();
            }
            try {
                this.triggerLogoutHandlersForPostLogout(request, response);
            }
            catch (OIDCSessionManagementException e) {
                log.error((Object)"Error executing logout handlers on post logout.");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Error executing logout handlers on post logout.", (Throwable)((Object)e));
                }
                response.sendRedirect(FrameworkUtils.getRedirectURL((String)OIDCSessionManagementUtil.getErrorPageURL("server_error", "User logout failed."), (HttpServletRequest)request));
            }
            redirectURL = this.appendStateQueryParam(redirectURL, cacheEntry.getState());
            this.removeSessionDataFromCache(sessionDataKey);
            Cookie opBrowserStateCookie = OIDCSessionManagementUtil.removeOPBrowserStateCookie(request, response);
            OIDCSessionManagementUtil.getSessionManager().removeOIDCSessionState(opBrowserStateCookie.getValue());
            this.clearTokenBindingElements((String)cacheEntry.getParamMap().get("client_id"), request, response);
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
        } else {
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)OIDCSessionManagementUtil.getErrorPageURL("server_error", "User logout failed"), (HttpServletRequest)request));
        }
    }

    private void triggerLogoutHandlersForPostLogout(HttpServletRequest request, HttpServletResponse response) throws OIDCSessionManagementException {
        List<OIDCLogoutHandler> oidcLogoutHandlers = OIDCSessionManagementComponentServiceHolder.getOIDCLogoutHandlers();
        for (OIDCLogoutHandler oidcLogoutHandler : oidcLogoutHandlers) {
            oidcLogoutHandler.handlePostLogout(request, response);
        }
    }

    private void triggerLogoutHandlersForPreLogout(HttpServletRequest request, HttpServletResponse response) throws OIDCSessionManagementException {
        List<OIDCLogoutHandler> oidcLogoutHandlers = OIDCSessionManagementComponentServiceHolder.getOIDCLogoutHandlers();
        for (OIDCLogoutHandler oidcLogoutHandler : oidcLogoutHandlers) {
            oidcLogoutHandler.handlePreLogout(request, response);
        }
    }

    private void addAuthenticationRequestToRequest(HttpServletRequest request, AuthenticationRequestCacheEntry authRequest) {
        request.setAttribute("authRequest", (Object)authRequest);
    }

    private void sendRequestToFramework(HttpServletRequest request, HttpServletResponse response, String sessionDataKey, String type) throws ServletException, IOException {
        CommonAuthenticationHandler commonAuthenticationHandler = new CommonAuthenticationHandler();
        CommonAuthRequestWrapper requestWrapper = new CommonAuthRequestWrapper(request);
        requestWrapper.setParameter("sessionDataKey", sessionDataKey);
        requestWrapper.setParameter("type", type);
        CommonAuthResponseWrapper responseWrapper = new CommonAuthResponseWrapper(response);
        commonAuthenticationHandler.doGet((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper);
        Object object = request.getAttribute("authenticatorFlowStatus");
        if (object != null) {
            AuthenticatorFlowStatus status = (AuthenticatorFlowStatus)object;
            if (status == AuthenticatorFlowStatus.INCOMPLETE) {
                if (responseWrapper.isRedirect()) {
                    response.sendRedirect(responseWrapper.getRedirectURL());
                } else if (responseWrapper.getContent().length > 0) {
                    responseWrapper.write();
                }
            } else {
                this.handleLogoutResponseFromFramework((HttpServletRequest)requestWrapper, response);
            }
        } else {
            this.handleLogoutResponseFromFramework((HttpServletRequest)requestWrapper, response);
        }
    }

    private void addSessionDataToCache(String sessionDataKey, OIDCSessionDataCacheEntry cacheEntry) {
        OIDCSessionDataCacheKey cacheKey = new OIDCSessionDataCacheKey(sessionDataKey);
        OIDCSessionDataCache.getInstance().addToCache((Serializable)((Object)cacheKey), (Serializable)((Object)cacheEntry));
    }

    private OIDCSessionDataCacheEntry getSessionDataFromCache(String sessionDataKey) {
        OIDCSessionDataCacheKey cacheKey = new OIDCSessionDataCacheKey(sessionDataKey);
        return (OIDCSessionDataCacheEntry)((Object)OIDCSessionDataCache.getInstance().getValueFromCache((Serializable)((Object)cacheKey)));
    }

    private void removeSessionDataFromCache(String sessionDataKey) {
        OIDCSessionDataCacheKey cacheKey = new OIDCSessionDataCacheKey(sessionDataKey);
        OIDCSessionDataCache.getInstance().clearCacheEntry((Serializable)((Object)cacheKey));
    }

    private boolean getOpenIDConnectSkipUserConsent(HttpServletRequest request) throws ParseException, IdentityOAuth2Exception {
        String idTokenHint = request.getParameter("id_token_hint");
        boolean skipLogoutConsent = OAuthServerConfiguration.getInstance().getOpenIDConnectSkipLogoutConsentConfig();
        if (skipLogoutConsent) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Server wide configuration is to skip the logout consent. So continue without checking for the service provider level configuration.");
            }
            return true;
        }
        if (StringUtils.isNotBlank((String)idTokenHint)) {
            String clientId;
            if (OIDCSessionManagementUtil.isIDTokenEncrypted(idTokenHint)) {
                String tenantDomain = request.getParameter("tenant_domain");
                JWT decryptedIDToken = OIDCSessionManagementUtil.decryptWithRSA(tenantDomain, idTokenHint);
                clientId = OIDCSessionManagementUtil.extractClientIDFromDecryptedIDToken(decryptedIDToken);
            } else {
                if (!this.validateIdToken(idTokenHint)) {
                    throw new IdentityOAuth2Exception("ID token signature validation failed.");
                }
                clientId = this.extractClientFromIdToken(idTokenHint);
            }
            ServiceProvider serviceProvider = OAuth2Util.getServiceProvider((String)clientId);
            if (serviceProvider != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Get the skip logout consent from service provider with client ID: " + clientId));
                }
                return FrameworkUtils.isLogoutConsentPageSkippedForSP((ServiceProvider)serviceProvider);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Could not able to identify the service provider, so prompting the logout consent.");
        }
        return false;
    }

    private void doBackChannelLogout(HttpServletRequest request) {
        LogoutRequestSender.getInstance().sendLogoutRequests(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending backchannel logout request.");
        }
    }

    private void setSPAttributeToRequest(HttpServletRequest req, String spName, String tenantDomain) {
        req.setAttribute(REQUEST_PARAM_SP, (Object)spName);
        req.setAttribute("tenantDomain", (Object)tenantDomain);
    }

    private String getServiceProviderName(String clientId, String tenantDomain) {
        String spName = null;
        try {
            spName = OIDCSessionManagementComponentServiceHolder.getApplicationMgtService().getServiceProviderNameByClientId(clientId, "oauth2", tenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)("Error while getting Service provider name for client Id:" + clientId + " in tenant: " + tenantDomain), (Throwable)e);
        }
        return spName;
    }

    private void handleMissingSessionStateGracefully(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String msg;
        String clientId;
        String redirectURL = OIDCSessionManagementUtil.getOIDCLogoutURL();
        String idTokenHint = request.getParameter("id_token_hint");
        String postLogoutRedirectUri = request.getParameter("post_logout_redirect_uri");
        if (StringUtils.isEmpty((String)idTokenHint) || StringUtils.isEmpty((String)postLogoutRedirectUri)) {
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
            return;
        }
        try {
            if (OIDCSessionManagementUtil.isIDTokenEncrypted(idTokenHint)) {
                String tenantDomain = request.getParameter("tenant_domain");
                JWT decryptedIDToken = OIDCSessionManagementUtil.decryptWithRSA(tenantDomain, idTokenHint);
                clientId = OIDCSessionManagementUtil.extractClientIDFromDecryptedIDToken(decryptedIDToken);
            } else {
                clientId = this.extractClientFromIdToken(idTokenHint);
            }
        }
        catch (ParseException e) {
            String msg2 = "Error occurred while extracting data from id token.";
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while retrieving client id from id token.", (Throwable)e);
            }
            redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg2);
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
            return;
        }
        catch (IdentityOAuth2Exception e) {
            String msg3 = "Error occurred while decrypting the id token (JWE).";
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while decrypting the id token (JWE).", (Throwable)e);
            }
            redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg3);
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
            return;
        }
        if (!this.validateIdToken(idTokenHint) && !OIDCSessionManagementUtil.isIDTokenEncrypted(idTokenHint)) {
            String msg4 = "ID token signature validation failed.";
            if (log.isDebugEnabled()) {
                log.debug((Object)(msg4 + " Client id from id token: " + clientId));
            }
            redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg4);
            response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
            return;
        }
        try {
            String callbackUrl = new OAuthAppDAO().getAppInformation(clientId).getCallbackUrl();
            redirectURL = this.validatePostLogoutUri(postLogoutRedirectUri, callbackUrl) ? postLogoutRedirectUri : OIDCSessionManagementUtil.getErrorPageURL("access_denied", "Post logout URI does not match with registered callback URI.");
        }
        catch (InvalidOAuthClientException e) {
            msg = "Error occurred while getting application information. Client id not found.";
            if (log.isDebugEnabled()) {
                log.debug((Object)(msg + " Client id from id token: " + clientId), (Throwable)e);
            }
            redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg);
        }
        catch (IdentityOAuth2Exception e) {
            msg = "Error occurred while getting application information. Client id not found.";
            log.error((Object)(msg + " Client id from id token: " + clientId), (Throwable)e);
            redirectURL = OIDCSessionManagementUtil.getErrorPageURL("access_denied", msg);
        }
        response.sendRedirect(FrameworkUtils.getRedirectURL((String)redirectURL, (HttpServletRequest)request));
    }

    private void clearTokenBindingElements(String clientId, HttpServletRequest request, HttpServletResponse response) {
        OAuthAppDO oAuthAppDO;
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId((String)clientId);
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            log.error((Object)("Failed to load the app information for the client id: " + clientId), e);
            return;
        }
        if (StringUtils.isBlank((String)oAuthAppDO.getTokenBindingType())) {
            return;
        }
        List<TokenBinder> tokenBinders = OIDCSessionManagementComponentServiceHolder.getInstance().getTokenBinders();
        if (tokenBinders.isEmpty()) {
            return;
        }
        tokenBinders.stream().filter(t -> oAuthAppDO.getTokenBindingType().equals(t.getBindingType())).findAny().ifPresent(t -> t.clearTokenBindingElements(request, response));
    }
}

