/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oidc.session.handler.OIDCLogoutHandler;
import org.wso2.carbon.user.core.service.RealmService;

public class OIDCSessionManagementComponentServiceHolder {
    private static OIDCSessionManagementComponentServiceHolder instance = new OIDCSessionManagementComponentServiceHolder();
    private static HttpService httpService;
    private static RealmService realmService;
    private static List<OIDCLogoutHandler> oidcPostLogoutHandlers;
    private static ApplicationManagementService applicationMgtService;
    private List<TokenBinder> tokenBinders = new ArrayList<TokenBinder>();

    private OIDCSessionManagementComponentServiceHolder() {
    }

    public static OIDCSessionManagementComponentServiceHolder getInstance() {
        return instance;
    }

    public static HttpService getHttpService() {
        return httpService;
    }

    public static void setHttpService(HttpService httpService) {
        OIDCSessionManagementComponentServiceHolder.httpService = httpService;
    }

    public static void setRealmService(RealmService realmService) {
        OIDCSessionManagementComponentServiceHolder.realmService = realmService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static List<OIDCLogoutHandler> getOIDCLogoutHandlers() {
        return Collections.unmodifiableList(oidcPostLogoutHandlers);
    }

    public static void addPostLogoutHandler(OIDCLogoutHandler oidcPostLogoutHandler) {
        oidcPostLogoutHandlers.add(oidcPostLogoutHandler);
    }

    public static void removePostLogoutHandler(OIDCLogoutHandler oidcPostLogoutHandler) {
        oidcPostLogoutHandlers.remove(oidcPostLogoutHandler);
    }

    public static ApplicationManagementService getApplicationMgtService() {
        return applicationMgtService;
    }

    public static void setApplicationMgtService(ApplicationManagementService applicationMgtService) {
        OIDCSessionManagementComponentServiceHolder.applicationMgtService = applicationMgtService;
    }

    public List<TokenBinder> getTokenBinders() {
        return this.tokenBinders;
    }

    public void addTokenBinder(TokenBinder tokenBinder) {
        this.tokenBinders.add(tokenBinder);
    }

    public void removeTokenBinder(TokenBinder tokenBinder) {
        this.tokenBinders.remove(tokenBinder);
    }

    static {
        oidcPostLogoutHandlers = new ArrayList<OIDCLogoutHandler>();
    }
}

