/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.internal;

import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.http.helper.ContextPathServletAdaptor;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.oauth.common.token.bindings.TokenBinderInfo;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinder;
import org.wso2.carbon.identity.oidc.session.backchannellogout.ClaimProviderImpl;
import org.wso2.carbon.identity.oidc.session.handler.OIDCLogoutEventHandler;
import org.wso2.carbon.identity.oidc.session.handler.OIDCLogoutHandler;
import org.wso2.carbon.identity.oidc.session.internal.OIDCSessionManagementComponentServiceHolder;
import org.wso2.carbon.identity.oidc.session.servlet.OIDCLogoutServlet;
import org.wso2.carbon.identity.oidc.session.servlet.OIDCSessionIFrameServlet;
import org.wso2.carbon.identity.openidconnect.ClaimProvider;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.oidc.session.component", immediate=true)
public class OIDCSessionManagementComponent {
    private static final Log log = LogFactory.getLog(OIDCSessionManagementComponent.class);

    protected void activate(ComponentContext context) {
        HttpService httpService = OIDCSessionManagementComponentServiceHolder.getHttpService();
        ContextPathServletAdaptor sessionIFrameServlet = new ContextPathServletAdaptor((Servlet)new OIDCSessionIFrameServlet(), "/oidc/checksession");
        try {
            httpService.registerServlet("/oidc/checksession", (Servlet)sessionIFrameServlet, null, null);
        }
        catch (Exception e) {
            String msg = "Error when registering OIDC Session IFrame Servlet via the HttpService.";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        ContextPathServletAdaptor logoutServlet = new ContextPathServletAdaptor((Servlet)new OIDCLogoutServlet(), "/oidc/logout");
        try {
            httpService.registerServlet("/oidc/logout", (Servlet)logoutServlet, null, null);
        }
        catch (Exception e) {
            String msg = "Error when registering OIDC Logout Servlet via the HttpService.";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        if (log.isDebugEnabled()) {
            log.info((Object)"OIDC Session Management bundle is activated");
        }
        ClaimProviderImpl claimProviderImpl = new ClaimProviderImpl();
        try {
            context.getBundleContext().registerService(ClaimProvider.class.getName(), (Object)claimProviderImpl, null);
        }
        catch (Exception e) {
            String msg = "Error when registering ClaimProvider service";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"ClaimProvider bundle is activated");
        }
        try {
            context.getBundleContext().registerService(AbstractEventHandler.class.getName(), (Object)new OIDCLogoutEventHandler(), null);
        }
        catch (Exception e) {
            String msg = "Error when registering OIDCLogoutEventHandler.";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.info((Object)"OIDC Session Management bundle is deactivated");
        }
    }

    @Reference(name="osgi.http.service", service=HttpService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the HTTP Service in OIDC Session Management bundle");
        }
        OIDCSessionManagementComponentServiceHolder.setHttpService(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the HTTP Service in OIDC Session Management bundle");
        }
        OIDCSessionManagementComponentServiceHolder.setHttpService(null);
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service.");
        }
        OIDCSessionManagementComponentServiceHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service.");
        }
        OIDCSessionManagementComponentServiceHolder.setRealmService(null);
    }

    @Reference(name="oidc.logout.handlers", service=OIDCLogoutHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterOIDCLogoutHandler")
    protected void registerOIDCLogoutHandler(OIDCLogoutHandler oidcLogoutHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering OIDC Logout Handler: " + oidcLogoutHandler.getClass().getName()));
        }
        OIDCSessionManagementComponentServiceHolder.addPostLogoutHandler(oidcLogoutHandler);
    }

    protected void unregisterOIDCLogoutHandler(OIDCLogoutHandler oidcLogoutHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-registering OIDC Logout Handler: " + oidcLogoutHandler.getClass().getName()));
        }
        OIDCSessionManagementComponentServiceHolder.removePostLogoutHandler(oidcLogoutHandler);
    }

    @Reference(name="identity.application.management.component", service=ApplicationManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetApplicationMgtService")
    protected void setApplicationMgtService(ApplicationManagementService applicationMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ApplicationManagementService set in OIDC session management bundle");
        }
        OIDCSessionManagementComponentServiceHolder.setApplicationMgtService(applicationMgtService);
    }

    protected void unsetApplicationMgtService(ApplicationManagementService applicationMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ApplicationManagementService unset in OIDC session management bundle");
        }
        OIDCSessionManagementComponentServiceHolder.setApplicationMgtService(null);
    }

    @Reference(name="token.binding.service", service=TokenBinderInfo.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetTokenBinderInfo")
    protected void setTokenBinderInfo(TokenBinderInfo tokenBinderInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting the token binder for: " + tokenBinderInfo.getBindingType()));
        }
        if (tokenBinderInfo instanceof TokenBinder) {
            OIDCSessionManagementComponentServiceHolder.getInstance().addTokenBinder((TokenBinder)tokenBinderInfo);
        }
    }

    protected void unsetTokenBinderInfo(TokenBinderInfo tokenBinderInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-setting the token binder for: " + tokenBinderInfo.getBindingType()));
        }
        if (tokenBinderInfo instanceof TokenBinder) {
            OIDCSessionManagementComponentServiceHolder.getInstance().removeTokenBinder((TokenBinder)tokenBinderInfo);
        }
    }
}

