/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.handler;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.event.IdentityEventConstants;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.oidc.session.backchannellogout.LogoutRequestSender;
import org.wso2.carbon.identity.oidc.session.util.OIDCSessionManagementUtil;

public class OIDCLogoutEventHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(OIDCLogoutEventHandler.class);
    private static final String COMMON_AUTH_CALLER_PATH = "commonAuthCallerPath";

    public void handleEvent(Event event) throws IdentityEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(event.getEventName() + " event received to OIDCLogoutEventHandler."));
        }
        if (StringUtils.equals((String)event.getEventName(), (String)IdentityEventConstants.EventName.SESSION_TERMINATE.name())) {
            HttpServletRequest request = this.getHttpRequestFromEvent(event);
            Cookie opbsCookie = null;
            if (request != null) {
                if (StringUtils.equals((String)request.getParameter("type"), (String)"oidc")) {
                    return;
                }
                opbsCookie = OIDCSessionManagementUtil.getOPBrowserStateCookie(request);
            }
            if (this.hasOPBSCookieValue(opbsCookie)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OPBS cookie with value " + opbsCookie.getValue() + " found. Initiating session termination."));
                }
                LogoutRequestSender.getInstance().sendLogoutRequests(request);
                OIDCSessionManagementUtil.getSessionManager().removeOIDCSessionState(opbsCookie.getValue());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"There is no valid OIDC based service provider in the session to be terminated by the OIDCLogoutEventHandler.");
            }
        }
    }

    public String getName() {
        return "OIDCLogoutEventHandler";
    }

    private HttpServletRequest getHttpRequestFromEvent(Event event) {
        return (HttpServletRequest)event.getEventProperties().get("request");
    }

    private boolean hasOPBSCookieValue(Cookie opbsCookie) {
        String opbsCookieValue = null;
        if (opbsCookie != null) {
            opbsCookieValue = opbsCookie.getValue();
        }
        return StringUtils.isNotBlank(opbsCookieValue);
    }
}

