/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.config;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class OIDCSessionManagementConfiguration {
    private static final Log log = LogFactory.getLog(OIDCSessionManagementConfiguration.class);
    private static OIDCSessionManagementConfiguration instance;
    private String oidcLogoutConsentPageUrl = null;
    private String oidcLogoutPageUrl = null;
    private boolean handleAlreadyLoggedOutSessionsGracefully = false;
    private static final String CONFIG_ELEM_OAUTH = "OAuth";

    private OIDCSessionManagementConfiguration() {
        this.buildConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OIDCSessionManagementConfiguration getInstance() {
        CarbonUtils.checkSecurity();
        if (instance != null) return instance;
        Class<OIDCSessionManagementConfiguration> clazz = OIDCSessionManagementConfiguration.class;
        synchronized (OIDCSessionManagementConfiguration.class) {
            if (instance != null) return instance;
            instance = new OIDCSessionManagementConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getOIDCLogoutConsentPageUrl() {
        return this.oidcLogoutConsentPageUrl;
    }

    public String getOIDCLogoutPageUrl() {
        return this.oidcLogoutPageUrl;
    }

    private void buildConfiguration() {
        IdentityConfigParser configParser = IdentityConfigParser.getInstance();
        OMElement oauthConfigElement = configParser.getConfigElement(CONFIG_ELEM_OAUTH);
        if (oauthConfigElement == null) {
            log.warn((Object)"Error in OAuth Configuration. OAuth element is not available");
            return;
        }
        OMElement element = oauthConfigElement.getFirstChildWithName(this.getQNameWithIdentityNS("OIDCLogoutConsentPage"));
        if (element != null && StringUtils.isNotBlank((String)element.getText())) {
            this.oidcLogoutConsentPageUrl = IdentityUtil.fillURLPlaceholders((String)element.getText());
        }
        if ((element = oauthConfigElement.getFirstChildWithName(this.getQNameWithIdentityNS("OIDCLogoutPage"))) != null && StringUtils.isNotBlank((String)element.getText())) {
            this.oidcLogoutPageUrl = IdentityUtil.fillURLPlaceholders((String)element.getText());
        }
        if ((element = oauthConfigElement.getFirstChildWithName(this.getQNameWithIdentityNS("HandleAlreadyLoggedOutSessionsGracefully"))) != null) {
            this.handleAlreadyLoggedOutSessionsGracefully = Boolean.parseBoolean(element.getText());
        }
    }

    private QName getQNameWithIdentityNS(String localPart) {
        return new QName("http://wso2.org/projects/carbon/carbon.xml", localPart);
    }

    public boolean handleAlreadyLoggedOutSessionsGracefully() {
        return this.handleAlreadyLoggedOutSessionsGracefully;
    }
}

