/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.cache;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.oidc.session.cache.OIDCSessionParticipantCacheEntry;
import org.wso2.carbon.identity.oidc.session.cache.OIDCSessionParticipantCacheKey;

public class OIDCSessionParticipantCache
extends BaseCache<OIDCSessionParticipantCacheKey, OIDCSessionParticipantCacheEntry> {
    private static final Log log = LogFactory.getLog(OIDCSessionParticipantCache.class);
    private static final String OIDC_SESSION_PARTICIPANT_CACHE_NAME = "OIDCSessionParticipantCache";
    private static volatile OIDCSessionParticipantCache instance;

    private OIDCSessionParticipantCache() {
        super(OIDC_SESSION_PARTICIPANT_CACHE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OIDCSessionParticipantCache getInstance() {
        if (instance != null) return instance;
        Class<OIDCSessionParticipantCache> clazz = OIDCSessionParticipantCache.class;
        synchronized (OIDCSessionParticipantCache.class) {
            if (instance != null) return instance;
            instance = new OIDCSessionParticipantCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(OIDCSessionParticipantCacheKey key, OIDCSessionParticipantCacheEntry entry) {
        super.addToCache((Serializable)((Object)key), (Serializable)((Object)entry));
        SessionDataStore.getInstance().storeSessionData(key.getSessionID(), OIDC_SESSION_PARTICIPANT_CACHE_NAME, (Object)entry);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Session corresponding to the key : " + key.getSessionID() + " added to cache and persistence queue."));
        }
    }

    public OIDCSessionParticipantCacheEntry getValueFromCache(OIDCSessionParticipantCacheKey key) {
        OIDCSessionParticipantCacheEntry entry = (OIDCSessionParticipantCacheEntry)((Object)super.getValueFromCache((Serializable)((Object)key)));
        if (entry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session corresponding to the key : " + key.getSessionID() + " cannot be found. Retrieving from session persistence store."));
            }
            entry = (OIDCSessionParticipantCacheEntry)((Object)SessionDataStore.getInstance().getSessionData(key.getSessionID(), OIDC_SESSION_PARTICIPANT_CACHE_NAME));
        }
        return entry;
    }

    public void clearCacheEntry(OIDCSessionParticipantCacheKey key) {
        super.clearCacheEntry((Serializable)((Object)key));
        SessionDataStore.getInstance().clearSessionData(key.getSessionID(), OIDC_SESSION_PARTICIPANT_CACHE_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Session corresponding to the key : " + key.getSessionID() + " cleared from cache and remove request added to persistence queue."));
        }
    }
}

