/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.cache;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.oidc.session.cache.OIDCBackChannelAuthCodeCacheEntry;
import org.wso2.carbon.identity.oidc.session.cache.OIDCBackChannelAuthCodeCacheKey;

public class OIDCBackChannelAuthCodeCache
extends BaseCache<OIDCBackChannelAuthCodeCacheKey, OIDCBackChannelAuthCodeCacheEntry> {
    private static final Log log = LogFactory.getLog(OIDCBackChannelAuthCodeCache.class);
    private static final String OIDC_BACKCHANNEL_DATA_CACHE_NAME = "OIDCBackChannelAuthCodeCache";
    private static volatile OIDCBackChannelAuthCodeCache instance;

    public OIDCBackChannelAuthCodeCache() {
        super(OIDC_BACKCHANNEL_DATA_CACHE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OIDCBackChannelAuthCodeCache getInstance() {
        if (instance != null) return instance;
        Class<OIDCBackChannelAuthCodeCache> clazz = OIDCBackChannelAuthCodeCache.class;
        synchronized (OIDCBackChannelAuthCodeCache.class) {
            if (instance != null) return instance;
            instance = new OIDCBackChannelAuthCodeCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(OIDCBackChannelAuthCodeCacheKey key, OIDCBackChannelAuthCodeCacheEntry entry) {
        super.addToCache((Serializable)((Object)key), (Serializable)((Object)entry));
        SessionDataStore.getInstance().storeSessionData(key.getAuthCode(), OIDC_BACKCHANNEL_DATA_CACHE_NAME, (Object)entry);
        if (log.isDebugEnabled()) {
            log.debug((Object)"SessionID added to cache and persistence queue.");
        }
    }

    public OIDCBackChannelAuthCodeCacheEntry getValueFromCache(OIDCBackChannelAuthCodeCacheKey key) {
        OIDCBackChannelAuthCodeCacheEntry entry = (OIDCBackChannelAuthCodeCacheEntry)((Object)super.getValueFromCache((Serializable)((Object)key)));
        if (entry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SessionID cannot be found. Retrieving from session persistence store.");
            }
            entry = (OIDCBackChannelAuthCodeCacheEntry)((Object)SessionDataStore.getInstance().getSessionData(key.getAuthCode(), OIDC_BACKCHANNEL_DATA_CACHE_NAME));
        }
        return entry;
    }

    public void clearCacheEntry(OIDCBackChannelAuthCodeCacheKey key) {
        super.clearCacheEntry((Serializable)((Object)key));
        SessionDataStore.getInstance().clearSessionData(key.getAuthCode(), OIDC_BACKCHANNEL_DATA_CACHE_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session ID cleared from cache and remove request added to persistence queue.");
        }
    }
}

