/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.backchannellogout;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oidc.session.backchannellogout.DefaultLogoutTokenBuilder;

public class LogoutRequestSender {
    private static final Log log = LogFactory.getLog(LogoutRequestSender.class);
    private static ExecutorService threadPool = Executors.newFixedThreadPool(2);
    private static LogoutRequestSender instance = new LogoutRequestSender();
    private static final String LOGOUT_TOKEN = "logout_token";

    private LogoutRequestSender() {
    }

    public static LogoutRequestSender getInstance() {
        return instance;
    }

    public void sendLogoutRequests(HttpServletRequest request) {
        Map<String, String> logoutTokenList = this.getLogoutTokenList(request);
        if (MapUtils.isNotEmpty(logoutTokenList)) {
            for (Map.Entry<String, String> logoutTokenMap : logoutTokenList.entrySet()) {
                String logoutToken = logoutTokenMap.getKey();
                String bcLogoutUrl = logoutTokenMap.getValue();
                threadPool.submit(new LogoutReqSenderTask(logoutToken, bcLogoutUrl));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"A logoutReqSenderTask is assigned to the thread pool");
            }
        }
    }

    private Map<String, String> getLogoutTokenList(HttpServletRequest request) {
        Map<String, String> logoutTokenList = null;
        try {
            DefaultLogoutTokenBuilder logoutTokenBuilder = new DefaultLogoutTokenBuilder();
            logoutTokenList = logoutTokenBuilder.buildLogoutToken(request);
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            log.error((Object)("Error while initializing " + DefaultLogoutTokenBuilder.class), e);
        }
        return logoutTokenList;
    }

    private class LogoutReqSenderTask
    implements Runnable {
        private String logoutToken;
        private String backChannelLogouturl;

        public LogoutReqSenderTask(String logoutToken, String backChannelLogouturl) {
            this.logoutToken = logoutToken;
            this.backChannelLogouturl = backChannelLogouturl;
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting backchannel logout request to: " + this.backChannelLogouturl));
            }
            ArrayList<BasicNameValuePair> logoutReqParams = new ArrayList<BasicNameValuePair>();
            String hostNameVerificationEnabledProperty = IdentityUtil.getProperty((String)"SSOService.SLOHostNameVerificationEnabled");
            boolean isHostNameVerificationEnabled = true;
            if ("false".equalsIgnoreCase(hostNameVerificationEnabledProperty)) {
                isHostNameVerificationEnabled = false;
            }
            try {
                CloseableHttpClient httpClient = !isHostNameVerificationEnabled ? HttpClients.custom().setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).build() : HttpClients.createDefault();
                logoutReqParams.add(new BasicNameValuePair(LogoutRequestSender.LOGOUT_TOKEN, this.logoutToken));
                HttpPost httpPost = new HttpPost(this.backChannelLogouturl);
                try {
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(logoutReqParams));
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Error while sending logout token", (Throwable)e);
                }
                HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Backchannel logout response: " + response.getStatusLine()));
                }
            }
            catch (IOException e) {
                log.error((Object)("Error sending logout requests to: " + this.backChannelLogouturl), (Throwable)e);
            }
        }
    }
}

