/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.backchannellogout;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oidc.session.OIDCSessionState;
import org.wso2.carbon.identity.oidc.session.backchannellogout.LogoutTokenBuilder;
import org.wso2.carbon.identity.oidc.session.util.OIDCSessionManagementUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class DefaultLogoutTokenBuilder
implements LogoutTokenBuilder {
    private static final Log log = LogFactory.getLog(DefaultLogoutTokenBuilder.class);
    private OAuthServerConfiguration config = OAuthServerConfiguration.getInstance();
    private JWSAlgorithm signatureAlgorithm = OAuth2Util.mapSignatureAlgorithmForJWSAlgorithm((String)this.config.getIdTokenSignatureAlgorithm());
    private static final String OPENID_IDP_ENTITY_ID = "IdPEntityId";
    private static final String ERROR_GET_RESIDENT_IDP = "Error while getting Resident Identity Provider of '%s' tenant.";

    @Override
    public Map<String, String> buildLogoutToken(HttpServletRequest request) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        Set<String> sessionParticipants;
        HashMap<String, String> logoutTokenList = new HashMap<String, String>();
        OIDCSessionState sessionState = this.getSessionState(request);
        if (sessionState != null && !(sessionParticipants = this.getSessionParticipants(sessionState)).isEmpty()) {
            for (String clientID : sessionParticipants) {
                OAuthAppDO oAuthAppDO = this.getOAuthAppDO(clientID);
                String backChannelLogoutUrl = oAuthAppDO.getBackChannelLogoutUrl();
                String tenantDomain = oAuthAppDO.getAppOwner().getTenantDomain();
                if (StringUtils.equals((String)clientID, (String)this.getClientId(request, tenantDomain)) || !StringUtils.isNotBlank((String)backChannelLogoutUrl)) continue;
                JWTClaimsSet jwtClaimsSet = this.buildJwtToken(sessionState, this.getTenanatDomain(oAuthAppDO), clientID);
                String logoutToken = OAuth2Util.signJWT((JWTClaimsSet)jwtClaimsSet, (JWSAlgorithm)this.signatureAlgorithm, (String)this.getSigningTenantDomain(oAuthAppDO)).serialize();
                logoutTokenList.put(logoutToken, backChannelLogoutUrl);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Logout token created for the client: " + clientID));
            }
        }
        return logoutTokenList;
    }

    private JWTClaimsSet buildJwtToken(OIDCSessionState sessionState, String tenantDomain, String clientID) throws IdentityOAuth2Exception {
        String sub = sessionState.getAuthenticatedUser();
        String jti = UUID.randomUUID().toString();
        String iss = this.getIssuer(tenantDomain);
        List<String> audience = this.getAudience(clientID);
        long logoutTokenValidityInMillis = this.getLogoutTokenExpiryInMillis();
        long currentTimeInMillis = Calendar.getInstance().getTimeInMillis();
        Date iat = new Date(currentTimeInMillis);
        String sid = this.getSidClaim(sessionState);
        JSONObject event = new JSONObject().put("http://schemas.openidnet/event/backchannel-logout", (Object)new JSONObject());
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder();
        jwtClaimsSetBuilder.subject(sub);
        jwtClaimsSetBuilder.issuer(iss);
        jwtClaimsSetBuilder.audience(audience);
        jwtClaimsSetBuilder.claim("jti", (Object)jti);
        jwtClaimsSetBuilder.claim("event", (Object)event);
        jwtClaimsSetBuilder.expirationTime(new Date(currentTimeInMillis + logoutTokenValidityInMillis));
        jwtClaimsSetBuilder.claim("iat", (Object)iat);
        jwtClaimsSetBuilder.claim("sid", (Object)sid);
        return jwtClaimsSetBuilder.build();
    }

    private String getClientId(HttpServletRequest request, String tenantDomain) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        String clientId = null;
        String idToken = this.getIdToken(request);
        if (idToken != null) {
            if (OIDCSessionManagementUtil.isIDTokenEncrypted(idToken)) {
                try {
                    JWT decryptedIDToken = OIDCSessionManagementUtil.decryptWithRSA(tenantDomain, idToken);
                    clientId = OIDCSessionManagementUtil.extractClientIDFromDecryptedIDToken(decryptedIDToken);
                }
                catch (ParseException e) {
                    log.error((Object)"Error in extracting the client ID from the ID token.");
                }
                return clientId;
            }
        } else {
            log.debug((Object)"IdTokenHint is not found in the request ");
            return null;
        }
        clientId = this.getClientIdFromIDTokenHint(idToken);
        if (this.validateIdTokenHint(clientId, idToken).booleanValue()) {
            return clientId;
        }
        log.debug((Object)"Id Token is not valid");
        return null;
    }

    private String getSigningTenantDomain(OAuthAppDO oAuthAppDO) {
        boolean isJWTSignedWithSPKey = OAuthServerConfiguration.getInstance().isJWTSignedWithSPKey();
        String signingTenantDomain = isJWTSignedWithSPKey ? this.getTenanatDomain(oAuthAppDO) : oAuthAppDO.getUser().getTenantDomain();
        return signingTenantDomain;
    }

    private OIDCSessionState getSessionState(HttpServletRequest request) {
        Cookie opbsCookie = OIDCSessionManagementUtil.getOPBrowserStateCookie(request);
        if (opbsCookie != null) {
            String obpsCookieValue = opbsCookie.getValue();
            OIDCSessionState sessionState = OIDCSessionManagementUtil.getSessionManager().getOIDCSessionState(obpsCookieValue);
            return sessionState;
        }
        return null;
    }

    private Set<String> getSessionParticipants(OIDCSessionState sessionState) {
        Set<String> sessionParticipants = sessionState.getSessionParticipants();
        return sessionParticipants;
    }

    private String getSidClaim(OIDCSessionState sessionState) {
        String sidClaim = sessionState.getSidClaim();
        return sidClaim;
    }

    private IdentityProvider getResidentIdp(String tenantDomain) throws IdentityOAuth2Exception {
        try {
            return IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            String errorMsg = String.format(ERROR_GET_RESIDENT_IDP, tenantDomain);
            throw new IdentityOAuth2Exception(errorMsg, (Throwable)e);
        }
    }

    private String getIssuer(String tenantDomain) throws IdentityOAuth2Exception {
        IdentityProvider identityProvider = this.getResidentIdp(tenantDomain);
        FederatedAuthenticatorConfig[] fedAuthnConfigs = identityProvider.getFederatedAuthenticatorConfigs();
        FederatedAuthenticatorConfig oidcAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"openidconnect");
        String issuer = IdentityApplicationManagementUtil.getProperty((Property[])oidcAuthenticatorConfig.getProperties(), (String)OPENID_IDP_ENTITY_ID).getValue();
        return issuer;
    }

    private OAuthAppDO getOAuthAppDO(String clientID) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        OAuthAppDO oAuthAppDO = OAuth2Util.getAppInformationByClientId((String)clientID);
        return oAuthAppDO;
    }

    private String getTenanatDomain(OAuthAppDO oAuthAppDO) {
        String tenantDomain = OAuth2Util.getTenantDomainOfOauthApp((OAuthAppDO)oAuthAppDO);
        return tenantDomain;
    }

    private List<String> getAudience(String clientID) {
        ArrayList<String> audience = new ArrayList<String>();
        audience.add(clientID);
        return audience;
    }

    private long getLogoutTokenExpiryInMillis() {
        return (long)Integer.parseInt(this.config.getOpenIDConnectBCLogoutTokenExpiration()) * 1000L;
    }

    private String getIdToken(HttpServletRequest request) {
        String idTokenHint = request.getParameter("id_token_hint");
        if (idTokenHint != null) {
            return idTokenHint;
        }
        return null;
    }

    private String getClientIdFromIDTokenHint(String idTokenHint) {
        String clientId = null;
        if (StringUtils.isNotBlank((String)idTokenHint)) {
            try {
                clientId = this.extractClientFromIdToken(idTokenHint);
            }
            catch (ParseException e) {
                log.error((Object)"Error while decoding the ID Token Hint.", (Throwable)e);
            }
        }
        return clientId;
    }

    private String extractClientFromIdToken(String idToken) throws ParseException {
        return (String)SignedJWT.parse((String)idToken).getJWTClaimsSet().getAudience().get(0);
    }

    private Boolean validateIdTokenHint(String clientId, String idToken) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        String tenantDomain = this.getSigningTenantDomain(this.getOAuthAppDO(clientId));
        if (StringUtils.isEmpty((String)tenantDomain)) {
            return false;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        try {
            RSAPublicKey publicKey;
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
            if (!tenantDomain.equals("carbon.super")) {
                String ksName = tenantDomain.trim().replace(".", "-");
                String jksName = ksName + ".jks";
                publicKey = (RSAPublicKey)keyStoreManager.getKeyStore(jksName).getCertificate(tenantDomain).getPublicKey();
            } else {
                publicKey = (RSAPublicKey)keyStoreManager.getDefaultPublicKey();
            }
            SignedJWT signedJWT = SignedJWT.parse((String)idToken);
            RSASSAVerifier verifier = new RSASSAVerifier(publicKey);
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (JOSEException | ParseException e) {
            log.error((Object)"Error occurred while validating id token signature.", e);
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while validating id token signature.", (Throwable)e);
            return false;
        }
    }
}

