/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session.backchannellogout;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oidc.session.OIDCSessionState;
import org.wso2.carbon.identity.oidc.session.cache.OIDCBackChannelAuthCodeCache;
import org.wso2.carbon.identity.oidc.session.cache.OIDCBackChannelAuthCodeCacheEntry;
import org.wso2.carbon.identity.oidc.session.cache.OIDCBackChannelAuthCodeCacheKey;
import org.wso2.carbon.identity.oidc.session.util.OIDCSessionManagementUtil;
import org.wso2.carbon.identity.openidconnect.ClaimProvider;

public class ClaimProviderImpl
implements ClaimProvider {
    private static final Log log = LogFactory.getLog(ClaimProviderImpl.class);

    public Map<String, Object> getAdditionalClaims(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext, OAuth2AuthorizeRespDTO oAuth2AuthorizeRespDTO) throws IdentityOAuth2Exception {
        String claimValue;
        HashMap<String, Object> additionalClaims = new HashMap<String, Object>();
        OIDCSessionState previousSession = this.getSessionState(oAuthAuthzReqMessageContext);
        if (previousSession == null) {
            claimValue = UUID.randomUUID().toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)"sid claim is generated for auth request. ");
            }
        } else {
            claimValue = previousSession.getSidClaim();
            if (log.isDebugEnabled()) {
                log.debug((Object)"sid claim is found in the session state");
            }
        }
        additionalClaims.put("sid", claimValue);
        this.addSidToCacheWhenIDTokenIsEncrypted(oAuthAuthzReqMessageContext, claimValue);
        return additionalClaims;
    }

    private void addSidToCacheWhenIDTokenIsEncrypted(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext, String claimValue) throws IdentityOAuth2Exception {
        try {
            OAuthAppDO app = OAuth2Util.getAppInformationByClientId((String)oAuthAuthzReqMessageContext.getAuthorizationReqDTO().getConsumerKey());
            if (app.isIdTokenEncryptionEnabled()) {
                OIDCBackChannelAuthCodeCacheKey authCacheKey = new OIDCBackChannelAuthCodeCacheKey("sid");
                OIDCBackChannelAuthCodeCacheEntry sidCacheEntry = new OIDCBackChannelAuthCodeCacheEntry();
                sidCacheEntry.setSessionId(claimValue);
                OIDCBackChannelAuthCodeCache.getInstance().addToCache(authCacheKey, sidCacheEntry);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Adding sid to OIDCBackChannelAuthCodeCache since id token encryption is enabled.");
                }
            }
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Retrieving OAuthAppDO failed for the client id: " + oAuthAuthzReqMessageContext.getAuthorizationReqDTO().getConsumerKey(), (Throwable)e);
        }
    }

    public Map<String, Object> getAdditionalClaims(OAuthTokenReqMessageContext oAuthTokenReqMessageContext, OAuth2AccessTokenRespDTO oAuth2AccessTokenRespDTO) throws IdentityOAuth2Exception {
        HashMap<String, Object> additionalClaims = new HashMap<String, Object>();
        String claimValue = null;
        String accessCode = oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().getAuthorizationCode();
        OIDCBackChannelAuthCodeCacheEntry cacheEntry = this.getOIDCBackChannelAuthCodeCacheEntry(accessCode);
        if (cacheEntry != null) {
            claimValue = cacheEntry.getSessionId();
        }
        if (claimValue != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"sid claim is found in the session state");
            }
            additionalClaims.put("sid", claimValue);
        }
        return additionalClaims;
    }

    private OIDCSessionState getSessionState(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext) {
        Cookie[] cookies = oAuthAuthzReqMessageContext.getAuthorizationReqDTO().getCookie();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"opbs".equals(cookie.getName())) continue;
                OIDCSessionState previousSessionState = OIDCSessionManagementUtil.getSessionManager().getOIDCSessionState(cookie.getValue());
                return previousSessionState;
            }
        }
        return null;
    }

    private OIDCBackChannelAuthCodeCacheEntry getOIDCBackChannelAuthCodeCacheEntry(String authCode) {
        if (StringUtils.isBlank((String)authCode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getOIDCBackChannelAuthCodeCacheEntry returned null.");
            }
            return null;
        }
        OIDCBackChannelAuthCodeCacheKey cacheKey = new OIDCBackChannelAuthCodeCacheKey(authCode);
        OIDCBackChannelAuthCodeCacheEntry cacheEntry = OIDCBackChannelAuthCodeCache.getInstance().getValueFromCache(cacheKey);
        return cacheEntry;
    }
}

