/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session;

import org.wso2.carbon.identity.oidc.session.OIDCSessionState;
import org.wso2.carbon.identity.oidc.session.cache.OIDCSessionParticipantCache;
import org.wso2.carbon.identity.oidc.session.cache.OIDCSessionParticipantCacheEntry;
import org.wso2.carbon.identity.oidc.session.cache.OIDCSessionParticipantCacheKey;

public class OIDCSessionManager {
    public void storeOIDCSessionState(String sessionId, OIDCSessionState sessionState) {
        OIDCSessionParticipantCacheKey cacheKey = new OIDCSessionParticipantCacheKey();
        cacheKey.setSessionID(sessionId);
        OIDCSessionParticipantCacheEntry cacheEntry = new OIDCSessionParticipantCacheEntry();
        cacheEntry.setSessionState(sessionState);
        OIDCSessionParticipantCache.getInstance().addToCache(cacheKey, cacheEntry);
    }

    public OIDCSessionState getOIDCSessionState(String sessionId) {
        OIDCSessionParticipantCacheKey cacheKey = new OIDCSessionParticipantCacheKey();
        cacheKey.setSessionID(sessionId);
        OIDCSessionParticipantCacheEntry cacheEntry = OIDCSessionParticipantCache.getInstance().getValueFromCache(cacheKey);
        return cacheEntry == null ? null : cacheEntry.getSessionState();
    }

    public void restoreOIDCSessionState(String oldSessionId, String newSessionId, OIDCSessionState sessionState) {
        this.removeOIDCSessionState(oldSessionId);
        this.storeOIDCSessionState(newSessionId, sessionState);
    }

    public void removeOIDCSessionState(String sessionId) {
        OIDCSessionParticipantCacheKey cacheKey = new OIDCSessionParticipantCacheKey();
        cacheKey.setSessionID(sessionId);
        OIDCSessionParticipantCache.getInstance().clearCacheEntry(cacheKey);
    }

    public boolean sessionExists(String sessionId) {
        return this.getOIDCSessionState(sessionId) != null;
    }
}

