/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oidc.session;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.wso2.carbon.core.SameSiteCookie;
import org.wso2.carbon.core.ServletCookie;
import org.wso2.carbon.identity.oidc.session.OIDCSessionStateManager;
import org.wso2.carbon.identity.oidc.session.util.OIDCSessionManagementUtil;

public class DefaultOIDCSessionStateManager
implements OIDCSessionStateManager {
    private static final String RANDOM_ALG_SHA1 = "SHA1PRNG";
    private static final String DIGEST_ALG_SHA256 = "SHA-256";

    @Override
    public String getSessionStateParam(String clientId, String rpCallBackUrl, String opBrowserState) {
        try {
            String salt = DefaultOIDCSessionStateManager.generateSaltValue();
            String sessionStateDataString = clientId + " " + OIDCSessionManagementUtil.getOrigin(rpCallBackUrl) + " " + opBrowserState + " " + salt;
            MessageDigest digest = MessageDigest.getInstance(DIGEST_ALG_SHA256);
            digest.update(sessionStateDataString.getBytes(StandardCharsets.UTF_8));
            return DefaultOIDCSessionStateManager.bytesToHex(digest.digest()) + "." + salt;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error while calculating session state.", e);
        }
    }

    @Override
    public Cookie addOPBrowserStateCookie(HttpServletResponse response) {
        ServletCookie cookie = new ServletCookie("opbs", UUID.randomUUID().toString());
        cookie.setSecure(true);
        cookie.setPath("/");
        cookie.setSameSite(SameSiteCookie.NONE);
        response.addCookie((Cookie)cookie);
        return cookie;
    }

    private static String generateSaltValue() throws NoSuchAlgorithmException {
        byte[] bytes = new byte[16];
        SecureRandom secureRandom = SecureRandom.getInstance(RANDOM_ALG_SHA1);
        secureRandom.nextBytes(bytes);
        return Base64.encodeBase64URLSafeString((byte[])bytes);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte byt : bytes) {
            result.append(Integer.toString((byt & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }
}

