/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.query.api.definition.Attribute;

public class SumAttributeAggregator
extends AttributeAggregator {
    private SumAttributeAggregator sumOutputAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Sum aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.sumOutputAttributeAggregator = new SumAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.sumOutputAttributeAggregator = new SumAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.sumOutputAttributeAggregator = new SumAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.sumOutputAttributeAggregator = new SumAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Sum not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.sumOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.sumOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Sin cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.sumOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Sin cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        return this.sumOutputAttributeAggregator.reset();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return this.sumOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Object[] state) {
        this.sumOutputAttributeAggregator.restoreState(state);
    }

    class SumAttributeAggregatorLong
    extends SumAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private long value = 0L;

        SumAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            this.value += ((Long)data).longValue();
            return this.value;
        }

        @Override
        public Object processRemove(Object data) {
            this.value -= ((Long)data).longValue();
            return this.value;
        }

        @Override
        public Object reset() {
            this.value = 0L;
            return this.value;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Long>("Value", this.value)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.value = (Long)stateEntry.getValue();
        }
    }

    class SumAttributeAggregatorInt
    extends SumAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private long value = 0L;

        SumAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            this.value += ((Integer)data).longValue();
            return this.value;
        }

        @Override
        public Object processRemove(Object data) {
            this.value -= ((Integer)data).longValue();
            return this.value;
        }

        @Override
        public Object reset() {
            this.value = 0L;
            return this.value;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Long>("Value", this.value)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.value = (Long)stateEntry.getValue();
        }
    }

    class SumAttributeAggregatorFloat
    extends SumAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;

        SumAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            this.value += ((Float)data).doubleValue();
            return this.value;
        }

        @Override
        public Object processRemove(Object data) {
            this.value -= ((Float)data).doubleValue();
            return this.value;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            return this.value;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("Value", this.value)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.value = (Double)stateEntry.getValue();
        }
    }

    class SumAttributeAggregatorDouble
    extends SumAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;

        SumAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            this.value += ((Double)data).doubleValue();
            return this.value;
        }

        @Override
        public Object processRemove(Object data) {
            this.value -= ((Double)data).doubleValue();
            return this.value;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            return this.value;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("Value", this.value)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.value = (Double)stateEntry.getValue();
        }
    }
}

