/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.query.api.definition.Attribute;

public abstract class AttributeAggregator
implements EternalReferencedHolder,
Snapshotable {
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected ExecutionPlanContext executionPlanContext;
    protected String elementId;
    private int attributeSize;

    public void initAggregator(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        try {
            this.executionPlanContext = executionPlanContext;
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeSize = attributeExpressionExecutors.length;
            executionPlanContext.addEternalReferencedHolder(this);
            if (this.elementId == null) {
                this.elementId = "AttributeAggregator-" + executionPlanContext.getElementIdGenerator().createNewId();
            }
            this.init(attributeExpressionExecutors, executionPlanContext);
        }
        catch (Throwable t) {
            throw new ExecutionPlanCreationException(t);
        }
    }

    public AttributeAggregator cloneAggregator(String key) {
        try {
            AttributeAggregator attributeAggregator = (AttributeAggregator)this.getClass().newInstance();
            ExpressionExecutor[] innerExpressionExecutors = new ExpressionExecutor[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                innerExpressionExecutors[i] = this.attributeExpressionExecutors[i].cloneExecutor(key);
            }
            attributeAggregator.elementId = this.elementId + "-" + key;
            attributeAggregator.initAggregator(innerExpressionExecutors, this.executionPlanContext);
            attributeAggregator.start();
            return attributeAggregator;
        }
        catch (Exception e) {
            throw new ExecutionPlanRuntimeException("Exception in cloning " + this.getClass().getCanonicalName(), e);
        }
    }

    public synchronized Object process(ComplexEvent event) {
        if (this.attributeSize > 1) {
            Object[] data = new Object[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                data[i] = this.attributeExpressionExecutors[i].execute(event);
            }
            switch (event.getType()) {
                case CURRENT: {
                    return this.processAdd(data);
                }
                case EXPIRED: {
                    return this.processRemove(data);
                }
                case RESET: {
                    return this.reset();
                }
            }
        } else if (this.attributeSize == 1) {
            switch (event.getType()) {
                case CURRENT: {
                    return this.processAdd(this.attributeExpressionExecutors[0].execute(event));
                }
                case EXPIRED: {
                    return this.processRemove(this.attributeExpressionExecutors[0].execute(event));
                }
                case RESET: {
                    return this.reset();
                }
            }
        } else {
            switch (event.getType()) {
                case CURRENT: {
                    return this.processAdd(null);
                }
                case EXPIRED: {
                    return this.processRemove(null);
                }
                case RESET: {
                    return this.reset();
                }
            }
        }
        return null;
    }

    protected abstract void init(ExpressionExecutor[] var1, ExecutionPlanContext var2);

    public abstract Attribute.Type getReturnType();

    public abstract Object processAdd(Object var1);

    public abstract Object processAdd(Object[] var1);

    public abstract Object processRemove(Object var1);

    public abstract Object processRemove(Object[] var1);

    public abstract Object reset();

    @Override
    public String getElementId() {
        return this.elementId;
    }
}

