/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.snapshot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.GroupedComplexEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;

public class GroupByPerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter {
    private String id;
    private final Long value;
    private ScheduledExecutorService scheduledExecutorService;
    private Map<String, ComplexEvent> groupByKeyEvents = new LinkedHashMap<String, ComplexEvent>();
    private Scheduler scheduler;
    private long scheduledTime;
    private String queryName;

    public GroupByPerSnapshotOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, ExecutionPlanContext executionPlanContext, String queryName) {
        super(wrappedSnapshotOutputRateLimiter, executionPlanContext);
        this.queryName = queryName;
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        complexEventChunk.reset();
        GroupByPerSnapshotOutputRateLimiter groupByPerSnapshotOutputRateLimiter = this;
        synchronized (groupByPerSnapshotOutputRateLimiter) {
            complexEventChunk.reset();
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)object);
                    continue;
                }
                if (object.getType() != ComplexEvent.Type.CURRENT) continue;
                complexEventChunk.remove();
                this.tryFlushEvents(outputEventChunks, (ComplexEvent)object);
                GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)object;
                this.groupByKeyEvents.put(groupedComplexEvent.getGroupKey(), groupedComplexEvent.getComplexEvent());
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    private void tryFlushEvents(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event) {
        if (event.getTimestamp() >= this.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            for (ComplexEvent complexEvent : this.groupByKeyEvents.values()) {
                outputEventChunk.add(this.cloneComplexEvent(complexEvent));
            }
            outputEventChunks.add(outputEventChunk);
            this.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(this.scheduledTime);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this.scheduledExecutorService, this, this.executionPlanContext);
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.queryName);
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{this.groupByKeyEvents};
    }

    @Override
    public void restoreState(Object[] state) {
        this.groupByKeyEvents = (Map)state[0];
    }

    @Override
    public SnapshotOutputRateLimiter clone(String key, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter) {
        return new GroupByPerSnapshotOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, wrappedSnapshotOutputRateLimiter, this.executionPlanContext, this.queryName);
    }
}

