/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.query.output.callback.InsertIntoStreamCallback;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.query.output.callback.QueryCallback;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public abstract class OutputRateLimiter
implements EternalReferencedHolder,
Snapshotable {
    protected List<QueryCallback> queryCallbacks = new ArrayList<QueryCallback>();
    protected OutputCallback outputCallback = null;
    private boolean hasCallBack = false;
    private String elementId;
    protected ExecutionPlanContext executionPlanContext;
    protected LatencyTracker latencyTracker;
    protected LockWrapper lockWrapper;
    protected String queryName;

    public void init(ExecutionPlanContext executionPlanContext, LockWrapper lockWrapper, String queryName) {
        this.executionPlanContext = executionPlanContext;
        this.queryName = queryName;
        if (this.outputCallback != null && this.outputCallback instanceof InsertIntoStreamCallback) {
            this.lockWrapper = lockWrapper;
        }
        if (this.elementId == null) {
            this.elementId = "OutputRateLimiter-" + executionPlanContext.getElementIdGenerator().createNewId();
        }
        executionPlanContext.getSnapshotService().addSnapshotable(queryName, this);
    }

    protected void sendToCallBacks(ComplexEventChunk complexEventChunk) {
        if (this.latencyTracker != null) {
            this.latencyTracker.markOut();
        }
        if (this.lockWrapper != null) {
            this.lockWrapper.unlock();
        }
        if (!this.queryCallbacks.isEmpty()) {
            for (QueryCallback callback : this.queryCallbacks) {
                callback.receiveStreamEvent(complexEventChunk);
            }
        }
        if (this.outputCallback != null && complexEventChunk.getFirst() != null) {
            complexEventChunk.reset();
            while (complexEventChunk.hasNext()) {
                Object complexEvent = complexEventChunk.next();
                if (complexEvent.getType() == ComplexEvent.Type.EXPIRED) {
                    complexEvent.setType(ComplexEvent.Type.CURRENT);
                    continue;
                }
                if (complexEvent.getType() != ComplexEvent.Type.RESET) continue;
                complexEventChunk.remove();
            }
            this.outputCallback.send(complexEventChunk);
        }
    }

    public void addQueryCallback(QueryCallback callback) {
        this.queryCallbacks.add(callback);
        this.hasCallBack = true;
    }

    public void setOutputCallback(OutputCallback outputCallback) {
        this.outputCallback = outputCallback;
        if (outputCallback != null) {
            this.hasCallBack = true;
        }
    }

    public abstract void process(ComplexEventChunk var1);

    public OutputCallback getOutputCallback() {
        return this.outputCallback;
    }

    public boolean hasCallBack() {
        return this.hasCallBack;
    }

    public abstract OutputRateLimiter clone(String var1);

    @Override
    public String getElementId() {
        return this.elementId;
    }

    public void setLatencyTracker(LatencyTracker latencyTracker) {
        this.latencyTracker = latencyTracker;
    }
}

