/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;

public abstract class FunctionExecutor
implements ExpressionExecutor,
EternalReferencedHolder,
Snapshotable {
    private static final Logger log = Logger.getLogger(FunctionExecutor.class);
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected ExecutionPlanContext executionPlanContext;
    protected String elementId;
    private int attributeSize;
    protected String queryName;

    public void initExecutor(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext, String queryName) {
        try {
            this.executionPlanContext = executionPlanContext;
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeSize = attributeExpressionExecutors.length;
            this.queryName = queryName;
            executionPlanContext.addEternalReferencedHolder(this);
            if (this.elementId == null) {
                this.elementId = "FunctionExecutor-" + executionPlanContext.getElementIdGenerator().createNewId();
            }
            executionPlanContext.getSnapshotService().addSnapshotable(queryName, this);
            this.init(attributeExpressionExecutors, executionPlanContext);
        }
        catch (Throwable t) {
            throw new ExecutionPlanCreationException(t);
        }
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        try {
            FunctionExecutor functionExecutor = (FunctionExecutor)this.getClass().newInstance();
            ExpressionExecutor[] innerExpressionExecutors = new ExpressionExecutor[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                innerExpressionExecutors[i] = this.attributeExpressionExecutors[i].cloneExecutor(key);
            }
            functionExecutor.elementId = this.elementId + "-" + key;
            functionExecutor.initExecutor(innerExpressionExecutors, this.executionPlanContext, this.queryName);
            functionExecutor.start();
            return functionExecutor;
        }
        catch (Exception e) {
            throw new ExecutionPlanRuntimeException("Exception in cloning " + this.getClass().getCanonicalName(), e);
        }
    }

    protected abstract void init(ExpressionExecutor[] var1, ExecutionPlanContext var2);

    @Override
    public Object execute(ComplexEvent event) {
        try {
            switch (this.attributeSize) {
                case 0: {
                    return this.execute((Object)null);
                }
                case 1: {
                    return this.execute(this.attributeExpressionExecutors[0].execute(event));
                }
            }
            Object[] data = new Object[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                data[i] = this.attributeExpressionExecutors[i].execute(event);
            }
            return this.execute(data);
        }
        catch (Exception e) {
            log.error((Object)("Exception on execution plan '" + this.executionPlanContext.getName() + "' on class '" + this.getClass().getName() + "', " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected abstract Object execute(Object[] var1);

    protected abstract Object execute(Object var1);

    @Override
    public String getElementId() {
        return this.elementId;
    }
}

