/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class CoalesceFunctionExecutor
extends FunctionExecutor {
    private Attribute.Type returnType;

    @Override
    public void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length == 0) {
            throw new ExecutionPlanValidationException("Coalesce must have at least one parameter");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        for (ExpressionExecutor expressionExecutor : attributeExpressionExecutors) {
            if (type == expressionExecutor.getReturnType()) continue;
            throw new ExecutionPlanValidationException("Coalesce cannot have parameters with different type");
        }
        this.returnType = type;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    protected Object execute(Object[] obj) {
        for (Object aObj : obj) {
            if (aObj == null) continue;
            return aObj;
        }
        return null;
    }

    @Override
    protected Object execute(Object data) {
        return data;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return null;
    }

    @Override
    public void restoreState(Object[] state) {
    }
}

