/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.condition;

import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.condition.ConditionExpressionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;

public class OrConditionExpressionExecutor
extends ConditionExpressionExecutor {
    protected ExpressionExecutor leftConditionExecutor;
    protected ExpressionExecutor rightConditionExecutor;

    public OrConditionExpressionExecutor(ExpressionExecutor leftConditionExecutor, ExpressionExecutor rightConditionExecutor) {
        if (!leftConditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL) || !rightConditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL)) {
            if (!leftConditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL)) {
                throw new OperationNotSupportedException("Return type of condition executor " + leftConditionExecutor.toString() + " should be of type BOOL. Actual Type: " + leftConditionExecutor.getReturnType().toString());
            }
            if (!rightConditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL)) {
                throw new OperationNotSupportedException("Return type of condition executor " + rightConditionExecutor.toString() + " should be of type BOOL. Actual Type: " + rightConditionExecutor.getReturnType().toString());
            }
            throw new OperationNotSupportedException("Return type of condition executor " + leftConditionExecutor.toString() + " and condition executor" + rightConditionExecutor.toString() + "should be of type BOOL. Left executor: " + leftConditionExecutor.getReturnType().toString() + " Right executor: " + rightConditionExecutor.getReturnType().toString());
        }
        this.leftConditionExecutor = leftConditionExecutor;
        this.rightConditionExecutor = rightConditionExecutor;
    }

    @Override
    public Boolean execute(ComplexEvent event) {
        Boolean result = (Boolean)this.leftConditionExecutor.execute(event);
        if (result == Boolean.TRUE) {
            return Boolean.TRUE;
        }
        result = (Boolean)this.rightConditionExecutor.execute(event);
        if (result == Boolean.TRUE) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new OrConditionExpressionExecutor(this.leftConditionExecutor.cloneExecutor(key), this.rightConditionExecutor.cloneExecutor(key));
    }
}

