/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.event.state;

import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.state.StateEventFactory;

public class StateEventPool {
    private StateEventFactory eventFactory;
    private int size;
    private int index = 0;
    private StateEvent stateEventList;
    private long id = 0L;

    public StateEventPool(MetaStateEvent metaStateEvent, int size) {
        this.eventFactory = new StateEventFactory(metaStateEvent.getStreamEventCount(), metaStateEvent.getOutputDataAttributes().size());
        this.size = size;
    }

    public StateEvent borrowEvent() {
        if (this.index > 0) {
            StateEvent event = this.stateEventList;
            this.stateEventList = this.stateEventList.getNext();
            event.setNext(null);
            --this.index;
            event.setId(++this.id);
            return event;
        }
        StateEvent event = this.eventFactory.newInstance();
        event.setId(++this.id);
        return event;
    }

    public void returnEvents(StateEvent stateEvent) {
        if (stateEvent != null && this.index < this.size) {
            StateEvent first = stateEvent;
            StateEvent last = stateEvent;
            while (stateEvent != null) {
                last = stateEvent;
                ++this.index;
                stateEvent = stateEvent.getNext();
            }
            last.setNext(this.stateEventList);
            this.stateEventList = first;
        }
    }

    public int getBufferedEventsSize() {
        return this.index;
    }

    public int getSize() {
        return this.size;
    }
}

