/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.DataSourceMetaInfo;
import org.wso2.carbon.ndatasource.core.internal.DataSourceServiceComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class DataSourceUtils {
    private static Log log = LogFactory.getLog(DataSourceUtils.class);
    private static SecretResolver secretResolver;
    private static final String XML_DECLARATION = "xml-declaration";
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static final DocumentBuilderFactory dbf;
    private static ThreadLocal<String> dataSourceId;

    public static void setCurrentDataSourceId(String dsId) {
        dataSourceId.set(dsId);
    }

    public static String getCurrentDataSourceId() {
        return dataSourceId.get();
    }

    public static Registry getConfRegistryForTenant(int tenantId) throws DataSourceException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
            UserRegistry userRegistry = DataSourceServiceComponent.getRegistryService().getConfigSystemRegistry(tenantId);
            return userRegistry;
        }
        catch (RegistryException e) {
            throw new DataSourceException("Error in retrieving conf registry instance: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static Registry getGovRegistryForTenant(int tenantId) throws DataSourceException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
            UserRegistry userRegistry = DataSourceServiceComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
            return userRegistry;
        }
        catch (RegistryException e) {
            throw new DataSourceException("Error in retrieving gov registry instance: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static boolean nullAllowEquals(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null && rhs != null || lhs != null && rhs == null) {
            return false;
        }
        return lhs.equals(rhs);
    }

    public static String elementToString(Element element) {
        try {
            if (element == null) {
                return "";
            }
            Document document = element.getOwnerDocument();
            DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
            LSSerializer serializer = domImplLS.createLSSerializer();
            serializer.getDomConfig().setParameter(XML_DECLARATION, false);
            return serializer.writeToString(element);
        }
        catch (Exception e) {
            log.error((Object)("Error while convering element to string: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static Element stringToElement(String xml) {
        if (xml == null || xml.trim().length() == 0) {
            return null;
        }
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new ByteArrayInputStream(xml.getBytes())).getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)("Error while converting string to element: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private static synchronized String loadFromSecureVault(String alias) {
        if (secretResolver == null) {
            secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
            secretResolver.init(DataSourceServiceComponent.getSecretCallbackHandlerService().getSecretCallbackHandler());
        }
        return secretResolver.resolve(alias);
    }

    private static void secureLoadElement(Element element, boolean checkSecureVault) throws CryptoException {
        if (checkSecureVault) {
            Attr secureAttr = element.getAttributeNodeNS("http://org.wso2.securevault/configuration", "secretAlias");
            if (secureAttr != null) {
                element.setTextContent(DataSourceUtils.loadFromSecureVault(secureAttr.getValue()));
                element.removeAttributeNode(secureAttr);
            }
        } else {
            boolean encrypted;
            String encryptedStr = element.getAttribute("encrypted");
            if (encryptedStr != null && (encrypted = Boolean.parseBoolean(encryptedStr))) {
                element.setTextContent(new String(CryptoUtil.getDefaultCryptoUtil((ServerConfigurationService)DataSourceServiceComponent.getServerConfigurationService(), (RegistryService)DataSourceServiceComponent.getRegistryService()).base64DecodeAndDecrypt(element.getTextContent())));
            }
        }
        NodeList childNodes = element.getChildNodes();
        int count = childNodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node tmpNode = childNodes.item(i);
            if (!(tmpNode instanceof Element)) continue;
            DataSourceUtils.secureLoadElement((Element)tmpNode, checkSecureVault);
        }
    }

    private static void secureLoadOMElement(OMElement element, boolean checkSecureVault) throws CryptoException {
        if (checkSecureVault) {
            String alias = MiscellaneousUtil.getProtectedToken((String)element.getText());
            if (alias != null && !alias.isEmpty()) {
                element.setText(DataSourceUtils.loadFromSecureVault(alias));
            } else {
                OMAttribute secureAttr = element.getAttribute(new QName("http://org.wso2.securevault/configuration", "secretAlias"));
                if (secureAttr != null) {
                    element.setText(DataSourceUtils.loadFromSecureVault(secureAttr.getAttributeValue()));
                    element.removeAttribute(secureAttr);
                }
            }
        } else {
            boolean encrypted;
            String encryptedStr = element.getAttributeValue(new QName("encrypted"));
            if (encryptedStr != null && (encrypted = Boolean.parseBoolean(encryptedStr))) {
                element.setText(new String(CryptoUtil.getDefaultCryptoUtil((ServerConfigurationService)DataSourceServiceComponent.getServerConfigurationService(), (RegistryService)DataSourceServiceComponent.getRegistryService()).base64DecodeAndDecrypt(element.getText())));
            }
        }
        Iterator childNodes = element.getChildElements();
        while (childNodes.hasNext()) {
            OMElement tmpNode = (OMElement)childNodes.next();
            DataSourceUtils.secureLoadOMElement(tmpNode, checkSecureVault);
        }
    }

    public static void secureSaveElement(Element element) throws CryptoException {
        boolean encrypted;
        String encryptedStr = element.getAttribute("encrypted");
        if (encryptedStr != null && (encrypted = Boolean.parseBoolean(encryptedStr))) {
            element.setTextContent(CryptoUtil.getDefaultCryptoUtil((ServerConfigurationService)DataSourceServiceComponent.getServerConfigurationService(), (RegistryService)DataSourceServiceComponent.getRegistryService()).encryptAndBase64Encode(element.getTextContent().getBytes()));
        }
        NodeList childNodes = element.getChildNodes();
        int count = childNodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node tmpNode = childNodes.item(i);
            if (!(tmpNode instanceof Element)) continue;
            DataSourceUtils.secureSaveElement((Element)tmpNode);
        }
    }

    public static void secureResolveDocument(Document doc, boolean checkSecureVault) throws DataSourceException {
        Element element = doc.getDocumentElement();
        if (element != null) {
            try {
                DataSourceUtils.secureLoadElement(element, checkSecureVault);
            }
            catch (CryptoException e) {
                throw new DataSourceException("Error in secure load of data source meta info: " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    public static Document convertToDocument(File file) throws DataSourceException {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(file);
        }
        catch (Exception e) {
            throw new DataSourceException("Error in creating an XML document from file: " + e.getMessage(), e);
        }
    }

    public static Document convertToDocument(InputStream in) throws DataSourceException {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(in);
        }
        catch (Exception e) {
            throw new DataSourceException("Error in creating an XML document from stream: " + e.getMessage(), e);
        }
    }

    public static void secureResolveOMElement(OMElement doc, boolean checkSecureVault) throws DataSourceException {
        if (doc != null) {
            try {
                secretResolver = SecretResolverFactory.create((OMElement)doc, (boolean)true);
                DataSourceUtils.secureLoadOMElement(doc, checkSecureVault);
            }
            catch (CryptoException e) {
                throw new DataSourceException("Error in secure load of data source meta info: " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    public static OMElement convertToOMElement(File file) throws DataSourceException {
        try {
            OMElement documentElement = new StAXOMBuilder((InputStream)new FileInputStream(file)).getDocumentElement();
            return documentElement;
        }
        catch (Exception e) {
            throw new DataSourceException("Error in creating an XML document from file: " + e.getMessage(), e);
        }
    }

    public static OMElement convertToOMElement(InputStream in) throws DataSourceException {
        try {
            OMElement documentElement = new StAXOMBuilder(in).getDocumentElement();
            return documentElement;
        }
        catch (Exception e) {
            throw new DataSourceException("Error in creating an XML document from stream: " + e.getMessage(), e);
        }
    }

    public static InputStream elementToInputStream(Element element) {
        try {
            if (element == null) {
                return null;
            }
            String xmlString = DataSourceUtils.elementToString(element);
            ByteArrayInputStream stream = new ByteArrayInputStream(xmlString.getBytes());
            return stream;
        }
        catch (Exception e) {
            log.error((Object)("Error while convering element to InputStream: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static Element convertDataSourceMetaInfoToElement(DataSourceMetaInfo dsmInfo, Marshaller dsmMarshaller) throws DataSourceException {
        Element element;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            dsmMarshaller.marshal((Object)dsmInfo, (Node)document);
            element = document.getDocumentElement();
        }
        catch (Exception e) {
            throw new DataSourceException("Error in creating an XML document from stream: " + e.getMessage(), e);
        }
        return element;
    }

    static {
        dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        dataSourceId = new ThreadLocal<String>(){

            @Override
            protected synchronized String initialValue() {
                return null;
            }
        };
    }
}

