/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core.services;

import org.w3c.dom.Element;
import org.wso2.carbon.ndatasource.core.DataSourceMetaInfo;
import org.wso2.carbon.ndatasource.core.JNDIConfig;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;

public class WSDataSourceMetaInfo {
    private String name;
    private String description;
    private JNDIConfig jndiConfig;
    private boolean system;
    private WSDataSourceDefinition definition;

    public WSDataSourceMetaInfo() {
    }

    public WSDataSourceMetaInfo(DataSourceMetaInfo metaInfo) {
        this.name = metaInfo.getName();
        this.description = metaInfo.getDescription();
        this.jndiConfig = metaInfo.getJndiConfig();
        this.system = !metaInfo.isPersistable();
        this.definition = new WSDataSourceDefinition(metaInfo.getDefinition());
    }

    public DataSourceMetaInfo extractDataSourceMetaInfo() {
        DataSourceMetaInfo dsmInfo = new DataSourceMetaInfo();
        dsmInfo.setName(this.getName());
        dsmInfo.setDescription(this.getDescription());
        dsmInfo.setSystem(this.isSystem());
        dsmInfo.setJndiConfig(this.getJndiConfig());
        dsmInfo.setDefinition(this.getDefinition().extractDataSourceDefinition());
        return dsmInfo;
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JNDIConfig getJndiConfig() {
        return this.jndiConfig;
    }

    public void setJndiConfig(JNDIConfig jndiConfig) {
        this.jndiConfig = jndiConfig;
    }

    public WSDataSourceDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(WSDataSourceDefinition definition) {
        this.definition = definition;
    }

    public static class WSDataSourceDefinition {
        private String type;
        private String dsXMLConfiguration;

        public WSDataSourceDefinition() {
        }

        public WSDataSourceDefinition(DataSourceMetaInfo.DataSourceDefinition dsDef) {
            this.type = dsDef.getType();
            this.dsXMLConfiguration = DataSourceUtils.elementToString((Element)dsDef.getDsXMLConfiguration());
        }

        public DataSourceMetaInfo.DataSourceDefinition extractDataSourceDefinition() {
            DataSourceMetaInfo.DataSourceDefinition dsDef = new DataSourceMetaInfo.DataSourceDefinition();
            dsDef.setType(this.getType());
            dsDef.setDsXMLConfiguration(DataSourceUtils.stringToElement(this.getDsXMLConfiguration()));
            return dsDef;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDsXMLConfiguration() {
            return this.dsXMLConfiguration;
        }

        public void setDsXMLConfiguration(String dsXMLConfiguration) {
            this.dsXMLConfiguration = dsXMLConfiguration;
        }
    }
}

