/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core.services;

import java.util.ArrayList;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceInfo;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.core.services.WSDataSourceInfo;
import org.wso2.carbon.ndatasource.core.services.WSDataSourceMetaInfo;

public class NDataSourceAdminService
extends AbstractAdmin {
    public WSDataSourceInfo[] getAllDataSources() throws DataSourceException {
        ArrayList<WSDataSourceInfo> result = new ArrayList<WSDataSourceInfo>();
        for (CarbonDataSource cds : DataSourceManager.getInstance().getDataSourceRepository().getAllDataSources()) {
            result.add(new WSDataSourceInfo(new DataSourceInfo(cds.getDSMInfo(), cds.getDSStatus())));
        }
        return result.toArray(new WSDataSourceInfo[result.size()]);
    }

    public WSDataSourceInfo getDataSource(String dsName) throws DataSourceException {
        CarbonDataSource cds = DataSourceManager.getInstance().getDataSourceRepository().getDataSource(dsName);
        if (cds == null) {
            return null;
        }
        return new WSDataSourceInfo(new DataSourceInfo(cds.getDSMInfo(), cds.getDSStatus()));
    }

    public WSDataSourceInfo[] getAllDataSourcesForType(String dsType) throws DataSourceException {
        ArrayList<WSDataSourceInfo> result = new ArrayList<WSDataSourceInfo>();
        for (CarbonDataSource cds : DataSourceManager.getInstance().getDataSourceRepository().getAllDataSources()) {
            if (!dsType.equals(cds.getDSMInfo().getDefinition().getType())) continue;
            result.add(new WSDataSourceInfo(new DataSourceInfo(cds.getDSMInfo(), cds.getDSStatus())));
        }
        return result.toArray(new WSDataSourceInfo[0]);
    }

    public String[] getDataSourceTypes() throws DataSourceException {
        return DataSourceManager.getInstance().getDataSourceTypes().toArray(new String[0]);
    }

    public boolean reloadAllDataSources() throws DataSourceException {
        DataSourceManager.getInstance().getDataSourceRepository().refreshAllUserDataSources();
        return true;
    }

    public boolean reloadDataSource(String dsName) throws DataSourceException {
        DataSourceManager.getInstance().getDataSourceRepository().refreshUserDataSource(dsName);
        return true;
    }

    public boolean addDataSource(WSDataSourceMetaInfo dsmInfo) throws DataSourceException {
        DataSourceManager.getInstance().getDataSourceRepository().addDataSource(dsmInfo.extractDataSourceMetaInfo());
        return true;
    }

    public boolean deleteDataSource(String dsName) throws DataSourceException {
        DataSourceManager.getInstance().getDataSourceRepository().deleteDataSource(dsName);
        return true;
    }

    public boolean testDataSourceConnection(WSDataSourceMetaInfo dsmInfo) throws DataSourceException {
        return DataSourceManager.getInstance().getDataSourceRepository().testDataSourceConnection(dsmInfo.extractDataSourceMetaInfo());
    }
}

