/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core.internal;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.crypto.api.ExternalCryptoProvider;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.DataSourceAxis2ConfigurationContextObserver;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.core.DataSourceRepository;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.ndatasource", immediate=true)
public class DataSourceServiceComponent {
    private static final Log log = LogFactory.getLog(DataSourceServiceComponent.class);
    private static final String DATA_SOURCE_REPO_CLASS_TAG = "CarbonDataSourceRepositoryClass";
    private static RegistryService registryService;
    private static ExternalCryptoProvider externalCryptoProvider;
    private static RealmService realmService;
    private static SecretCallbackHandlerService secretCallbackHandlerService;
    private static ServerConfigurationService serverConfigurationService;
    private DataSourceService dataSourceService;
    private ComponentContext ctx;
    private boolean tenantUserDataSourcesInitialized;
    private static ConfigurationContextService configContextService;
    private static Class<DataSourceRepository> carbonDataSourceRepositoryClass;

    protected synchronized void activate(ComponentContext ctx) {
        String carbonDataSourceRepositoryClassName;
        this.ctx = ctx;
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceServiceComponent activated");
        }
        if ((carbonDataSourceRepositoryClassName = CarbonUtils.getServerConfiguration().getFirstProperty(DATA_SOURCE_REPO_CLASS_TAG)) != null) {
            try {
                carbonDataSourceRepositoryClass = this.getClass().getClassLoader().loadClass(carbonDataSourceRepositoryClassName);
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("The specified DataSourceRepositoryClass " + carbonDataSourceRepositoryClassName + " is not there in the class path.Using the default DataSourceRepositoryClass "), (Throwable)e);
            }
        }
        if (this.tenantUserDataSourcesInitialized) {
            this.registerServices();
        }
    }

    protected synchronized void deactivate(ComponentContext ctx) {
        this.ctx = null;
        this.tenantUserDataSourcesInitialized = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceServiceComponent deactivated");
        }
    }

    private void registerServices() {
        if (this.getDataSourceService() == null) {
            this.dataSourceService = new DataSourceService();
        }
        BundleContext bundleContext = this.ctx.getBundleContext();
        bundleContext.registerService(DataSourceService.class.getName(), (Object)this.getDataSourceService(), null);
        bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new DataSourceAxis2ConfigurationContextObserver(), null);
    }

    public DataSourceService getDataSourceService() {
        return this.dataSourceService;
    }

    @Reference(name="user.realmservice.default", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService acquired");
        }
        DataSourceServiceComponent.realmService = realmService;
        this.checkInitTenantUserDataSources();
    }

    protected void unsetRealmService(RealmService realmService) {
        DataSourceServiceComponent.realmService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="registry.service", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService acquired");
        }
        DataSourceServiceComponent.registryService = registryService;
        this.checkInitTenantUserDataSources();
    }

    protected void unsetRegistryService(RegistryService registryService) {
        registryService = null;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    @Reference(name="external.crypto.service", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetExternalCryptoProvider")
    protected void setExternalCryptoProvider(ExternalCryptoProvider externalCryptoProvider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ExternalCryptoProvider acquired");
        }
        DataSourceServiceComponent.externalCryptoProvider = externalCryptoProvider;
        this.checkInitTenantUserDataSources();
    }

    protected void unsetExternalCryptoProvider(ExternalCryptoProvider externalCryptoProvider) {
        DataSourceServiceComponent.externalCryptoProvider = null;
    }

    public static ExternalCryptoProvider getExternalCryptoProvider() {
        return externalCryptoProvider;
    }

    public static SecretCallbackHandlerService getSecretCallbackHandlerService() {
        return secretCallbackHandlerService;
    }

    @Reference(name="secret.callback.handler.service", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY, unbind="unsetSecretCallbackHandlerService")
    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService acquired");
        }
        DataSourceServiceComponent.secretCallbackHandlerService = secretCallbackHandlerService;
        this.initSystemDataSources();
        this.checkInitTenantUserDataSources();
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        DataSourceServiceComponent.secretCallbackHandlerService = null;
    }

    private void initSystemDataSources() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing system data sources...");
        }
        try {
            DataSourceManager.getInstance().initSystemDataSources();
            if (log.isDebugEnabled()) {
                log.debug((Object)"System data sources successfully initialized");
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in intializing system data sources: " + e.getMessage()), (Throwable)e);
        }
    }

    private synchronized void checkInitTenantUserDataSources() {
        if (DataSourceServiceComponent.getRealmService() != null && DataSourceServiceComponent.getRegistryService() != null && DataSourceServiceComponent.getSecretCallbackHandlerService() != null && DataSourceServiceComponent.getServerConfigurationService() != null && DataSourceServiceComponent.getExternalCryptoProvider() != null) {
            this.initSuperTenantUserDataSources();
        }
    }

    private synchronized void initSuperTenantUserDataSources() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing super tenant user data sources...");
            }
            DataSourceManager.getInstance().initTenant(-1234);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Super tenant user data sources successfully initialized");
            }
            this.tenantUserDataSourcesInitialized = true;
            if (this.ctx != null) {
                this.registerServices();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in intializing system data sources: " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean isTenantUserDataSourcesInitialized() {
        return this.tenantUserDataSourcesInitialized;
    }

    public static ServerConfigurationService getServerConfigurationService() {
        return serverConfigurationService;
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        DataSourceServiceComponent.serverConfigurationService = null;
    }

    @Reference(name="server.configuration.service", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ServerConfigurationService acquired");
        }
        DataSourceServiceComponent.serverConfigurationService = serverConfigurationService;
        this.checkInitTenantUserDataSources();
    }

    @Reference(name="config.context.service", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configContextService) {
        DataSourceServiceComponent.configContextService = configContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configContextService) {
        DataSourceServiceComponent.configContextService = null;
    }

    public static ConfigurationContextService getConfigContextService() {
        return configContextService;
    }

    public static DataSourceRepository getNewTenantDataSourceRepository(int tenantId) throws DataSourceException {
        DataSourceRepository dataSourceRepository = null;
        if (carbonDataSourceRepositoryClass != null) {
            try {
                dataSourceRepository = carbonDataSourceRepositoryClass.getConstructor(Integer.TYPE).newInstance(tenantId);
            }
            catch (InstantiationException e) {
                log.warn((Object)("The specified DataSourceRepositoryClass " + carbonDataSourceRepositoryClass.getName() + " could not be instantiated.Using the default DataSourceRepositoryClass "), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("The specified DataSourceRepositoryClass " + carbonDataSourceRepositoryClass.getName() + " could not be accessed.Using the default DataSourceRepositoryClass "), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.warn((Object)("The specified DataSourceRepositoryClass " + carbonDataSourceRepositoryClass.getName() + " do not have constructor that takes tenantId as argument.Using the default DataSourceRepositoryClass"), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.warn((Object)("Error while instantiating specified DataSourceRepositoryClass " + carbonDataSourceRepositoryClass.getName() + " .Using the default DataSourceRepositoryClass"), (Throwable)e);
            }
        }
        if (dataSourceRepository != null) {
            return dataSourceRepository;
        }
        return new DataSourceRepository(tenantId);
    }
}

