/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.common.spi.DataSourceReader;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.core.DataSourceMetaInfo;
import org.wso2.carbon.ndatasource.core.DataSourceStatMessage;
import org.wso2.carbon.ndatasource.core.DataSourceStatus;
import org.wso2.carbon.ndatasource.core.JNDIConfig;
import org.wso2.carbon.ndatasource.core.internal.DataSourceServiceComponent;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.utils.ConfigurationContextService;

public class DataSourceRepository {
    private static Log log = LogFactory.getLog(DataSourceRepository.class);
    private int tenantId;
    private Registry registry;
    private Map<String, CarbonDataSource> dataSources;
    private Marshaller dsmMarshaller;
    private Unmarshaller dsmUnmarshaller;

    public DataSourceRepository(int tenantId) throws DataSourceException {
        this.tenantId = tenantId;
        this.dataSources = new HashMap<String, CarbonDataSource>();
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{DataSourceMetaInfo.class});
            this.dsmMarshaller = ctx.createMarshaller();
            this.dsmUnmarshaller = ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new DataSourceException("Error creating data source meta info marshaller/unmarshaller: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void initRepository() throws DataSourceException {
        this.refreshAllUserDataSources();
    }

    private synchronized Registry getRegistry() throws DataSourceException {
        if (this.registry == null) {
            this.registry = DataSourceUtils.getConfRegistryForTenant(this.getTenantId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("[datasources] Retrieving the governance registry for tenant: " + this.getTenantId()));
            }
        }
        return this.registry;
    }

    private String resourceNameFromPath(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public void refreshAllUserDataSources() throws DataSourceException {
        this.updateAllUserDataSource(false);
    }

    public void unregisterAllUserDataSources() throws DataSourceException {
        this.updateAllUserDataSource(true);
    }

    private void updateAllUserDataSource(boolean unregister) throws DataSourceException {
        try {
            if (this.getRegistry().resourceExists("/repository/components/org.wso2.carbon.ndatasource")) {
                String[] dsmPaths;
                org.wso2.carbon.registry.api.Collection dsCollection = (org.wso2.carbon.registry.api.Collection)this.getRegistry().get("/repository/components/org.wso2.carbon.ndatasource");
                for (String dsmPath : dsmPaths = dsCollection.getChildren()) {
                    try {
                        this.updateDataSource(this.resourceNameFromPath(dsmPath), unregister);
                    }
                    catch (DataSourceException e) {
                        log.error((Object)("Error in updating data source [remove:" + unregister + "] at path '" + dsmPath + "': " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in getting all data sources from repository: " + e.getMessage(), e);
        }
    }

    public void refreshUserDataSource(String dsName) throws DataSourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refreshing data source: " + dsName));
        }
        this.updateDataSource(dsName, false);
    }

    private synchronized void updateDataSource(String dsName, boolean unregister) throws DataSourceException {
        String dsmPath = "/repository/components/org.wso2.carbon.ndatasource/" + dsName;
        try {
            DataSourceMetaInfo dsmInfo = this.getDataSourceMetaInfoFromRegistryPath(dsmPath);
            CarbonDataSource currentCDS = this.getDataSource(dsName);
            DataSourceMetaInfo currentDsmInfo = null;
            if (currentCDS != null) {
                currentDsmInfo = currentCDS.getDSMInfo();
            }
            if (unregister) {
                this.unregisterDataSource(dsName);
            } else {
                if (DataSourceUtils.nullAllowEquals(dsmInfo, currentDsmInfo)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No update change for data source: " + dsName));
                    }
                    return;
                }
                if (dsmInfo != null) {
                    this.registerDataSource(dsmInfo);
                } else {
                    this.unregisterDataSource(dsName);
                }
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in updating data source '" + dsName + "' from registry [remove:" + unregister + "]: " + e.getMessage(), e);
        }
    }

    private Object createDataSourceObject(DataSourceMetaInfo dsmInfo, boolean isUseDataSourceFactory) throws DataSourceException {
        DataSourceReader dsReader = DataSourceManager.getInstance().getDataSourceReader(dsmInfo.getDefinition().getType());
        if (dsReader == null) {
            throw new DataSourceException("A data source reader cannot be found for the type '" + dsmInfo.getDefinition().getType() + "'");
        }
        DataSourceUtils.setCurrentDataSourceId(this.getTenantId() + ":" + dsmInfo.getName());
        return dsReader.createDataSource(DataSourceUtils.elementToString((Element)dsmInfo.getDefinition().getDsXMLConfiguration()), isUseDataSourceFactory);
    }

    private Context lookupJNDISubContext(Context context, String jndiName) throws DataSourceException {
        try {
            Object obj = context.lookup(jndiName);
            if (!(obj instanceof Context)) {
                throw new DataSourceException("Non JNDI context already exists at '" + context + "/" + jndiName);
            }
            return (Context)obj;
        }
        catch (NamingException e) {
            return null;
        }
    }

    private void checkAndCreateJNDISubContexts(Context context, String jndiName) throws DataSourceException {
        String[] tokens = jndiName.split("/");
        for (int i = 0; i < tokens.length - 1; ++i) {
            String token = tokens[i];
            Context tmpCtx = this.lookupJNDISubContext(context, token);
            if (tmpCtx == null) {
                try {
                    tmpCtx = context.createSubcontext(token);
                }
                catch (NamingException e) {
                    throw new DataSourceException("Error in creating JNDI subcontext '" + context + "/" + token + ": " + e.getMessage(), (Exception)e);
                }
            }
            context = tmpCtx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerJNDI(DataSourceMetaInfo dsmInfo, Object dsObject) throws DataSourceException {
        try {
            InitialContext context;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.getTenantId());
            JNDIConfig jndiConfig = dsmInfo.getJndiConfig();
            if (jndiConfig == null) {
                return;
            }
            try {
                context = new InitialContext(jndiConfig.extractHashtableEnv());
            }
            catch (NamingException e) {
                throw new DataSourceException("Error creating JNDI initial context: " + e.getMessage(), (Exception)e);
            }
            this.checkAndCreateJNDISubContexts(context, jndiConfig.getName());
            try {
                context.rebind(jndiConfig.getName(), dsObject);
            }
            catch (NamingException e) {
                throw new DataSourceException("Error in binding to JNDI with name '" + jndiConfig.getName() + "' - " + e.getMessage(), (Exception)e);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterJNDI(DataSourceMetaInfo dsmInfo) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.getTenantId());
            JNDIConfig jndiConfig = dsmInfo.getJndiConfig();
            if (jndiConfig == null) {
                return;
            }
            try {
                InitialContext context = new InitialContext(jndiConfig.extractHashtableEnv());
                context.unbind(jndiConfig.getName());
            }
            catch (NamingException e) {
                log.error((Object)("Error in unregistering JNDI name: " + jndiConfig.getName() + " - " + e.getMessage()), (Throwable)e);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void removePersistedDataSource(String dsName) throws DataSourceException {
        try {
            this.getRegistry().beginTransaction();
            String path = "/repository/components/org.wso2.carbon.ndatasource/" + dsName;
            if (this.getRegistry().resourceExists(path)) {
                this.getRegistry().delete(path);
            }
            this.getRegistry().commitTransaction();
        }
        catch (Exception e) {
            try {
                this.getRegistry().rollbackTransaction();
            }
            catch (RegistryException e1) {
                log.error((Object)("Error in rollback transaction in removing data source:" + e1.getMessage()), (Throwable)e1);
            }
            throw new DataSourceException("Error in removing data source: " + dsName + " - " + e.getMessage(), e);
        }
    }

    private void persistDataSource(DataSourceMetaInfo dsmInfo) throws DataSourceException {
        try {
            Element element = DataSourceUtils.convertDataSourceMetaInfoToElement(dsmInfo, this.getDSMMarshaller());
            DataSourceUtils.secureSaveElement(element);
            Resource resource = this.getRegistry().newResource();
            resource.setContentStream(DataSourceUtils.elementToInputStream(element));
            this.getRegistry().put("/repository/components/org.wso2.carbon.ndatasource/" + dsmInfo.getName(), (org.wso2.carbon.registry.api.Resource)resource);
        }
        catch (Exception e) {
            throw new DataSourceException("Error in persisting data source: " + dsmInfo.getName() + " - " + e.getMessage(), e);
        }
    }

    private void unregisterDataSource(String dsName) {
        CarbonDataSource cds = this.getDataSource(dsName);
        if (cds == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering data source: " + dsName));
        }
        this.unregisterJNDI(cds.getDSMInfo());
        this.dataSources.remove(dsName);
    }

    private synchronized void registerDataSource(DataSourceMetaInfo dsmInfo) throws DataSourceException {
        DataSourceStatus dsStatus;
        CarbonDataSource currentCDS = this.getDataSource(dsmInfo.getName());
        if (currentCDS != null) {
            if (dsmInfo.isSystem()) {
                throw new DataSourceException("System datasource " + dsmInfo.getName() + "can not be updated.");
            }
            this.unregisterDataSource(currentCDS.getDSMInfo().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering data source: " + dsmInfo.getName()));
        }
        Object dsObject = null;
        boolean isDataSourceFactoryReference = false;
        try {
            JNDIConfig jndiConfig = dsmInfo.getJndiConfig();
            if (jndiConfig != null) {
                isDataSourceFactoryReference = jndiConfig.isUseDataSourceFactory();
            }
            dsObject = this.createDataSourceObject(dsmInfo, isDataSourceFactoryReference);
            this.registerJNDI(dsmInfo, dsObject);
            dsStatus = new DataSourceStatus("ACTIVE", null);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            dsStatus = new DataSourceStatus("ERROR", msg);
        }
        if (isDataSourceFactoryReference) {
            dsObject = this.createDataSourceObject(dsmInfo, false);
        }
        CarbonDataSource cds = new CarbonDataSource(dsmInfo, dsStatus, dsObject);
        this.dataSources.put(cds.getDSMInfo().getName(), cds);
    }

    private void notifyClusterDSChange(String dsName) throws DataSourceException {
        ConfigurationContextService configCtxService;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Notifying cluster DS change: " + dsName));
        }
        if ((configCtxService = DataSourceServiceComponent.getConfigContextService()) == null) {
            throw new DataSourceException("ConfigurationContextService not available for notifying the cluster");
        }
        ConfigurationContext configCtx = configCtxService.getServerConfigContext();
        ClusteringAgent agent = configCtx.getAxisConfiguration().getClusteringAgent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clustering Agent: " + agent));
        }
        if (agent != null) {
            DataSourceStatMessage msg = new DataSourceStatMessage();
            msg.setTenantId(this.getTenantId());
            msg.setDsName(dsName);
            try {
                agent.sendMessage((ClusteringMessage)msg, true);
            }
            catch (ClusteringFault e) {
                throw new DataSourceException("Error in sending out cluster message: " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private DataSourceMetaInfo getDataSourceMetaInfoFromRegistryPath(String path) throws DataSourceException, Exception {
        try (InputStream in = null;){
            this.getRegistry().beginTransaction();
            if (this.getRegistry().resourceExists(path)) {
                Resource resource;
                try {
                    resource = this.getRegistry().get(path);
                }
                catch (ResourceNotFoundException e) {
                    DataSourceMetaInfo dataSourceMetaInfo = null;
                    if (in != null) {
                        in.close();
                    }
                    return dataSourceMetaInfo;
                }
                in = resource.getContentStream();
                OMElement doc = DataSourceUtils.convertToOMElement(in);
                DataSourceUtils.secureResolveOMElement(doc, false);
                this.getRegistry().commitTransaction();
                doc.toStringWithConsume();
                DataSourceMetaInfo dataSourceMetaInfo = (DataSourceMetaInfo)this.getDSMUnmarshaller().unmarshal(doc.getXMLStreamReader());
                return dataSourceMetaInfo;
            }
            DataSourceMetaInfo resource = null;
            return resource;
        }
    }

    private Unmarshaller getDSMUnmarshaller() {
        return this.dsmUnmarshaller;
    }

    private Marshaller getDSMMarshaller() {
        return this.dsmMarshaller;
    }

    public Collection<CarbonDataSource> getAllDataSources() {
        return this.dataSources.values();
    }

    public CarbonDataSource getDataSource(String dsName) {
        return this.dataSources.get(dsName);
    }

    public void addDataSource(DataSourceMetaInfo dsmInfo) throws DataSourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding data source: " + dsmInfo.getName()));
        }
        if (dsmInfo.isPersistable()) {
            this.persistDataSource(dsmInfo);
        }
        this.registerDataSource(dsmInfo);
        if (dsmInfo.isPersistable()) {
            this.notifyClusterDSChange(dsmInfo.getName());
        }
    }

    public void deleteDataSource(String dsName) throws DataSourceException {
        CarbonDataSource cds;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting data source: " + dsName));
        }
        if ((cds = this.getDataSource(dsName)) == null) {
            throw new DataSourceException("Data source does not exist: " + dsName);
        }
        if (cds.getDSMInfo().isSystem()) {
            throw new DataSourceException("System data sources cannot be deleted: " + dsName);
        }
        this.unregisterDataSource(dsName);
        if (cds.getDSMInfo().isPersistable()) {
            this.removePersistedDataSource(dsName);
            this.notifyClusterDSChange(dsName);
        }
    }

    public boolean testDataSourceConnection(DataSourceMetaInfo dsmInfo) throws DataSourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Testing connection of data source: " + dsmInfo.getName()));
        }
        DataSourceReader dsReader = DataSourceManager.getInstance().getDataSourceReader(dsmInfo.getDefinition().getType());
        try {
            return dsReader.testDataSourceConnection(DataSourceUtils.elementToString((Element)dsmInfo.getDefinition().getDsXMLConfiguration()));
        }
        catch (DataSourceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

