/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Element;
import org.wso2.carbon.ndatasource.core.JNDIConfig;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;

@XmlRootElement(name="datasource")
@XmlType(propOrder={"name", "description", "jndiConfig", "definition"})
public class DataSourceMetaInfo {
    private String name;
    private String description;
    private JNDIConfig jndiConfig;
    private DataSourceDefinition definition;
    @XmlTransient
    private boolean system;
    @XmlTransient
    private boolean carbonApplicationDeployed;

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setJndiConfig(JNDIConfig jndiConfig) {
        this.jndiConfig = jndiConfig;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public void setCarbonApplicationDeployed(boolean carbonApplicationDeployed) {
        this.carbonApplicationDeployed = carbonApplicationDeployed;
    }

    @XmlElement(name="name", required=true, nillable=false)
    public String getName() {
        return this.name;
    }

    @XmlElement(name="description")
    public String getDescription() {
        return this.description;
    }

    @XmlElement(name="jndiConfig")
    public JNDIConfig getJndiConfig() {
        return this.jndiConfig;
    }

    @XmlTransient
    public boolean isSystem() {
        return this.system;
    }

    @XmlTransient
    public boolean isCarbonApplicationDeployed() {
        return this.carbonApplicationDeployed;
    }

    @XmlElement(name="definition", required=true, nillable=false)
    public DataSourceDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(DataSourceDefinition definition) {
        this.definition = definition;
    }

    @XmlTransient
    public boolean isPersistable() {
        return !this.system && !this.carbonApplicationDeployed;
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof DataSourceMetaInfo)) {
            return false;
        }
        DataSourceMetaInfo dsmInfo = (DataSourceMetaInfo)rhs;
        if (!DataSourceUtils.nullAllowEquals(dsmInfo.getName(), this.getName())) {
            return false;
        }
        if (!DataSourceUtils.nullAllowEquals(dsmInfo.getDescription(), this.getDescription())) {
            return false;
        }
        if (!DataSourceUtils.nullAllowEquals(dsmInfo.getJndiConfig(), this.getJndiConfig())) {
            return false;
        }
        return DataSourceUtils.nullAllowEquals(dsmInfo.getDefinition(), this.getDefinition());
    }

    public int hashCode() {
        assert (false) : "hashCode() not implemented";
        return -1;
    }

    @XmlRootElement(name="definition")
    public static class DataSourceDefinition {
        private String type;
        private Object dsXMLConfiguration;

        @XmlAttribute(name="type", required=true)
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @XmlAnyElement
        public Object getDsXMLConfiguration() {
            return this.dsXMLConfiguration;
        }

        public void setDsXMLConfiguration(Object dsXMLConfiguration) {
            this.dsXMLConfiguration = dsXMLConfiguration;
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof DataSourceDefinition)) {
                return false;
            }
            DataSourceDefinition dsDef = (DataSourceDefinition)rhs;
            if (!DataSourceUtils.nullAllowEquals(dsDef.getType(), this.getType())) {
                return false;
            }
            return DataSourceUtils.nullAllowEquals(DataSourceUtils.elementToString((Element)dsDef.getDsXMLConfiguration()), DataSourceUtils.elementToString((Element)this.getDsXMLConfiguration()));
        }

        public int hashCode() {
            assert (false) : "hashCode() not implemented";
            return -1;
        }
    }
}

