/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsMode;
import org.apache.commons.vfs2.util.DelegatingFileSystemOptionsBuilder;
import org.apache.synapse.commons.vfs.VFSConstants;
import org.apache.synapse.commons.vfs.VFSOutTransportInfo;
import org.apache.synapse.commons.vfs.VFSParamDTO;

public class VFSUtils {
    private static final Log log = LogFactory.getLog(VFSUtils.class);
    private static final String STR_SPLITER = ":";
    private static final String LOCK_FILE_SUFFIX = ".lock";
    private static final String FAIL_FILE_SUFFIX = ".fail";
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");
    private static final Random randomNumberGenerator = new Random();
    private static final String KEY_STORE = "vfs.ssl.keystore";
    private static final String TRUST_STORE = "vfs.ssl.truststore";
    private static final String KS_PASSWD = "vfs.ssl.kspassword";
    private static final String TS_PASSWD = "vfs.ssl.tspassword";
    private static final String KEY_PASSWD = "vfs.ssl.keypassword";
    public static final String PASSIVE_MODE = "vfs.passive";
    public static final String IMPLICIT_MODE = "vfs.implicit";
    public static final String PROTECTION_MODE = "vfs.protection";

    private VFSUtils() {
    }

    public static String getProperty(FileContent message, String property) {
        try {
            Object o = message.getAttributes().get(property);
            if (o instanceof String) {
                return (String)o;
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return null;
    }

    public static String getFileName(MessageContext msgCtx, VFSOutTransportInfo vfsOutInfo) {
        Parameter param;
        String fileName = null;
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (transportHeaders != null) {
            fileName = (String)transportHeaders.get("transport.vfs.ReplyFileName");
        }
        if (fileName == null && (param = msgCtx.getAxisService().getParameter("transport.vfs.ReplyFileName")) != null) {
            fileName = (String)param.getValue();
        }
        if (fileName == null) {
            fileName = vfsOutInfo.getOutFileName();
        }
        if (fileName == null) {
            fileName = "response.xml";
        }
        return fileName;
    }

    public static synchronized boolean acquireLock(FileSystemManager fsManager, FileObject fo, FileSystemOptions fso, boolean isListener) {
        return VFSUtils.acquireLock(fsManager, fo, null, fso, isListener);
    }

    public static synchronized boolean acquireLock(FileSystemManager fsManager, FileObject fo, VFSParamDTO paramDTO, FileSystemOptions fso, boolean isListener) {
        block10: {
            String strLockValue = VFSUtils.getLockValue();
            byte[] lockValue = strLockValue.getBytes();
            FileObject lockObject = null;
            try {
                String fullPath = VFSUtils.getFullPath(fo);
                lockObject = fsManager.resolveFile(fullPath + LOCK_FILE_SUFFIX, fso);
                if (lockObject.exists()) {
                    log.debug((Object)("There seems to be an external lock, aborting the processing of the file " + VFSUtils.maskURLPassword(fo.getName().getURI()) + ". This could possibly be due to some other party already processing this file or the file is still being uploaded"));
                    if (paramDTO != null && paramDTO.isAutoLockRelease()) {
                        VFSUtils.releaseLock(lockValue, strLockValue, lockObject, paramDTO.isAutoLockReleaseSameNode(), paramDTO.getAutoLockReleaseInterval());
                    }
                } else {
                    FileObject originalFileObject;
                    if (isListener && !(originalFileObject = fsManager.resolveFile(fullPath, fso)).exists()) {
                        return false;
                    }
                    if (!VFSUtils.createLockFile(lockValue, lockObject, fullPath)) {
                        return false;
                    }
                    FileObject verifyingLockObject = fsManager.resolveFile(fullPath + LOCK_FILE_SUFFIX, fso);
                    if (verifyingLockObject.exists() && VFSUtils.verifyLock(lockValue, verifyingLockObject)) {
                        return true;
                    }
                }
            }
            catch (FileSystemException fse) {
                log.error((Object)("Cannot get the lock for the file : " + VFSUtils.maskURLPassword(fo.getName().getURI()) + " before processing"), (Throwable)fse);
                if (lockObject == null) break block10;
                try {
                    fsManager.closeFileSystem(lockObject.getParent().getFileSystem());
                }
                catch (FileSystemException e) {
                    log.warn((Object)"Unable to close the lockObject parent file system");
                }
            }
        }
        return false;
    }

    private static String getFullPath(FileObject fo) {
        String fullPath = fo.getName().getURI();
        int pos = fullPath.indexOf(63);
        if (pos != -1) {
            fullPath = fullPath.substring(0, pos);
        }
        return fullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createLockFile(byte[] lockValue, FileObject lockObject, String fullPath) throws FileSystemException {
        lockObject.createFile();
        OutputStream stream = lockObject.getContent().getOutputStream();
        try {
            stream.write(lockValue);
            stream.flush();
        }
        catch (IOException e) {
            lockObject.delete();
            log.error((Object)("Couldn't create the lock file before processing the file " + VFSUtils.maskURLPassword(fullPath)), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.debug((Object)"Error closing stream", (Throwable)e);
            }
            lockObject.close();
        }
        return true;
    }

    private static String getLockValue() {
        StringBuilder lockValueBuilder;
        block2: {
            lockValueBuilder = new StringBuilder();
            lockValueBuilder.append(randomNumberGenerator.nextLong());
            try {
                lockValueBuilder.append(STR_SPLITER).append(InetAddress.getLocalHost().getHostName()).append(STR_SPLITER).append(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException ue) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Unable to get the Hostname or IP.", (Throwable)ue);
            }
        }
        lockValueBuilder.append(STR_SPLITER).append(new Date().getTime());
        return lockValueBuilder.toString();
    }

    public static void releaseLock(FileSystemManager fsManager, FileObject fo, FileSystemOptions fso) {
        String fullPath = fo.getName().getURI();
        try {
            FileObject lockObject;
            int pos = fullPath.indexOf(63);
            if (pos > -1) {
                fullPath = fullPath.substring(0, pos);
            }
            if ((lockObject = fsManager.resolveFile(fullPath + LOCK_FILE_SUFFIX, fso)).exists()) {
                lockObject.delete();
            }
        }
        catch (FileSystemException e) {
            log.error((Object)("Couldn't release the lock for the file : " + VFSUtils.maskURLPassword(fo.getName().getURI()) + " after processing"));
        }
    }

    public static String maskURLPassword(String url) {
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            Matcher pwdMatcher = PASSWORD_PATTERN.matcher(url);
            String maskUrl = pwdMatcher.replaceFirst("\":***@\"");
            return maskUrl;
        }
        return url;
    }

    public static String getSystemTime(String dateFormat) {
        return new SimpleDateFormat(dateFormat).format(new Date());
    }

    private static boolean verifyLock(byte[] lockValue, FileObject lockObject) {
        try {
            InputStream is = lockObject.getContent().getInputStream();
            byte[] val = new byte[lockValue.length];
            is.read(val);
            if (Arrays.equals(lockValue, val) && is.read() == -1) {
                return true;
            }
            log.debug((Object)"The lock has been acquired by an another party");
        }
        catch (IOException e) {
            log.error((Object)"Couldn't verify the lock", (Throwable)e);
            return false;
        }
        return false;
    }

    public static Long getLastModified(MessageContext msgCtx) {
        Object lastModified;
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (transportHeaders != null && (lastModified = transportHeaders.get("LAST_MODIFIED")) != null) {
            if (lastModified instanceof Long) {
                return (Long)lastModified;
            }
            if (lastModified instanceof String) {
                try {
                    return Long.parseLong((String)lastModified);
                }
                catch (Exception e) {
                    log.warn((Object)"Cannot create last modified.", (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    public static synchronized void markFailRecord(FileSystemManager fsManager, FileObject fo) {
        VFSUtils.markFailRecord(fsManager, fo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void markFailRecord(FileSystemManager fsManager, FileObject fo, FileSystemOptions fso) {
        byte[] failValue = Long.toString(new Date().getTime()).getBytes();
        try {
            String fullPath = VFSUtils.getFullPath(fo);
            FileObject failObject = fsManager.resolveFile(fullPath + FAIL_FILE_SUFFIX, fso);
            if (!failObject.exists()) {
                failObject.createFile();
            }
            OutputStream stream = failObject.getContent().getOutputStream();
            try {
                stream.write(failValue);
                stream.flush();
            }
            catch (IOException e) {
                failObject.delete();
                log.error((Object)("Couldn't create the fail file before processing the file " + VFSUtils.maskURLPassword(fullPath)), (Throwable)e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing stream", (Throwable)e);
                }
                failObject.close();
            }
        }
        catch (FileSystemException fse) {
            log.error((Object)("Cannot get the lock for the file : " + VFSUtils.maskURLPassword(fo.getName().getURI()) + " before processing"));
        }
    }

    public static boolean isFailRecord(FileSystemManager fsManager, FileObject fo) {
        return VFSUtils.isFailRecord(fsManager, fo, null);
    }

    public static boolean isFailRecord(FileSystemManager fsManager, FileObject fo, FileSystemOptions fso) {
        try {
            FileObject failObject;
            String fullPath = fo.getName().getURI();
            String queryParams = "";
            int pos = fullPath.indexOf(63);
            if (pos > -1) {
                queryParams = fullPath.substring(pos);
                fullPath = fullPath.substring(0, pos);
            }
            if ((failObject = fsManager.resolveFile(fullPath + FAIL_FILE_SUFFIX + queryParams, fso)).exists()) {
                return true;
            }
        }
        catch (FileSystemException e) {
            log.error((Object)("Couldn't release the fail for the file : " + VFSUtils.maskURLPassword(fo.getName().getURI())));
        }
        return false;
    }

    public static boolean isReadyToRead(FileObject fo, Long waitTimeBeforeRead) {
        if (waitTimeBeforeRead != null && waitTimeBeforeRead > 0L) {
            try {
                return fo.getContent().getLastModifiedTime() < System.currentTimeMillis() - waitTimeBeforeRead;
            }
            catch (FileSystemException e) {
                log.warn((Object)"Unable to determine whether the file can be read or not", (Throwable)e);
            }
        }
        return true;
    }

    public static void releaseFail(FileSystemManager fsManager, FileObject fo) {
        VFSUtils.releaseFail(fsManager, fo, null);
    }

    public static void releaseFail(FileSystemManager fsManager, FileObject fo, FileSystemOptions fso) {
        try {
            FileObject failObject;
            String fullPath = fo.getName().getURI();
            int pos = fullPath.indexOf(63);
            if (pos > -1) {
                fullPath = fullPath.substring(0, pos);
            }
            if ((failObject = fsManager.resolveFile(fullPath + FAIL_FILE_SUFFIX, fso)).exists()) {
                failObject.delete();
            }
        }
        catch (FileSystemException e) {
            log.error((Object)("Couldn't release the fail for the file : " + VFSUtils.maskURLPassword(fo.getName().getURI())));
        }
    }

    private static void releaseLock(byte[] bLockValue, String sLockValue, FileObject lockObject, Boolean autoLockReleaseSameNode, Long autoLockReleaseInterval) {
        block5: {
            try {
                InputStream is = lockObject.getContent().getInputStream();
                byte[] val = new byte[bLockValue.length];
                is.read(val);
                is.close();
                String strVal = new String(val);
                String[] arrVal = strVal.split(STR_SPLITER);
                String[] arrValNew = sLockValue.split(STR_SPLITER);
                if (arrVal.length == 4 && arrValNew.length == 4 && (!autoLockReleaseSameNode.booleanValue() || arrVal[1].equals(arrValNew[1]) && arrVal[2].equals(arrValNew[2]))) {
                    long lInterval = 0L;
                    try {
                        lInterval = Long.parseLong(arrValNew[3]) - Long.parseLong(arrVal[3]);
                    }
                    catch (NumberFormatException nfe) {
                        log.debug((Object)"Error calculating lock file age", (Throwable)nfe);
                    }
                    VFSUtils.deleteLockFile(lockObject, autoLockReleaseInterval, lInterval);
                    break block5;
                }
                lockObject.close();
            }
            catch (IOException e) {
                log.error((Object)"Couldn't verify the lock", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteLockFile(FileObject lockObject, Long autoLockReleaseInterval, long lInterval) throws FileSystemException {
        if (autoLockReleaseInterval == null || autoLockReleaseInterval <= lInterval) {
            try {
                lockObject.delete();
            }
            catch (Exception e) {
                log.warn((Object)"Unable to delete the lock file during auto release cycle.", (Throwable)e);
            }
            finally {
                lockObject.close();
            }
        }
    }

    public static Map<String, String> parseSchemeFileOptions(String fileURI, ParameterInclude params) {
        String scheme = UriParser.extractScheme((String)fileURI);
        if (scheme == null) {
            return null;
        }
        Map<String, String> schemeFileOptions = VFSUtils.parseSchemeFileOptions(scheme, fileURI);
        VFSUtils.addOptions(schemeFileOptions, params);
        return schemeFileOptions;
    }

    public static Map<String, String> parseSchemeFileOptions(String fileURI, Properties vfsProperties) {
        String scheme = UriParser.extractScheme((String)fileURI);
        if (scheme == null) {
            return null;
        }
        Map<String, String> schemeFileOptions = VFSUtils.parseSchemeFileOptions(scheme, fileURI);
        VFSUtils.addOptions(schemeFileOptions, vfsProperties);
        return schemeFileOptions;
    }

    private static Map<String, String> parseSchemeFileOptions(String scheme, String fileURI) {
        HashMap<String, String> schemeFileOptions = new HashMap<String, String>();
        schemeFileOptions.put("VFS_SCHEME", scheme);
        try {
            Map queryParams = UriParser.extractQueryParams((String)fileURI);
            schemeFileOptions.putAll(queryParams);
        }
        catch (FileSystemException e) {
            log.error((Object)"Error while loading scheme query params", (Throwable)e);
        }
        return schemeFileOptions;
    }

    private static void addOptions(Map<String, String> schemeFileOptions, Properties vfsProperties) {
        for (VFSConstants.SFTP_FILE_OPTION option : VFSConstants.SFTP_FILE_OPTION.values()) {
            String paramValue = vfsProperties.getProperty("transport.vfs.SFTP" + WordUtils.capitalize((String)option.toString()));
            if (paramValue == null || paramValue.isEmpty()) continue;
            schemeFileOptions.put(option.toString(), paramValue);
        }
    }

    private static void addOptions(Map<String, String> schemeFileOptions, ParameterInclude params) {
        for (VFSConstants.SFTP_FILE_OPTION option : VFSConstants.SFTP_FILE_OPTION.values()) {
            String paramValue = null;
            try {
                paramValue = ParamUtils.getOptionalParam((ParameterInclude)params, (String)("transport.vfs.SFTP" + WordUtils.capitalize((String)option.toString())));
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error while loading VFS parameter. " + axisFault.getMessage()));
            }
            if (paramValue == null || paramValue.isEmpty()) continue;
            schemeFileOptions.put(option.toString(), paramValue);
        }
    }

    public static FileSystemOptions attachFileSystemOptions(Map<String, String> options, FileSystemManager fsManager) throws FileSystemException {
        String keyPassword;
        String trustStorePassword;
        String keyStorePassword;
        String trustStore;
        String protectionMode;
        String implicitMode;
        if (options == null) {
            return null;
        }
        FileSystemOptions opts = new FileSystemOptions();
        DelegatingFileSystemOptionsBuilder delegate = new DelegatingFileSystemOptionsBuilder(fsManager);
        for (Map.Entry<String, String> entry : options.entrySet()) {
            for (VFSConstants.SFTP_FILE_OPTION option : VFSConstants.SFTP_FILE_OPTION.values()) {
                if (!entry.getKey().equals(option.toString()) || entry.getValue() == null) continue;
                delegate.setConfigString(opts, "sftp", entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        FtpsFileSystemConfigBuilder configBuilder = FtpsFileSystemConfigBuilder.getInstance();
        String passiveMode = options.get(PASSIVE_MODE);
        if (passiveMode != null) {
            configBuilder.setPassiveMode(opts, Boolean.parseBoolean(passiveMode));
        }
        if ((implicitMode = options.get(IMPLICIT_MODE)) != null) {
            if (Boolean.parseBoolean(implicitMode)) {
                configBuilder.setFtpsMode(opts, FtpsMode.IMPLICIT);
            } else {
                configBuilder.setFtpsMode(opts, FtpsMode.EXPLICIT);
            }
        }
        if ("P".equalsIgnoreCase(protectionMode = options.get(PROTECTION_MODE))) {
            configBuilder.setDataChannelProtectionLevel(opts, FtpsDataChannelProtectionLevel.P);
        } else if ("C".equalsIgnoreCase(protectionMode)) {
            configBuilder.setDataChannelProtectionLevel(opts, FtpsDataChannelProtectionLevel.C);
        } else if ("S".equalsIgnoreCase(protectionMode)) {
            configBuilder.setDataChannelProtectionLevel(opts, FtpsDataChannelProtectionLevel.S);
        } else if ("E".equalsIgnoreCase(protectionMode)) {
            configBuilder.setDataChannelProtectionLevel(opts, FtpsDataChannelProtectionLevel.E);
        }
        String keyStore = options.get(KEY_STORE);
        if (keyStore != null) {
            configBuilder.setKeyStore(opts, keyStore);
        }
        if ((trustStore = options.get(TRUST_STORE)) != null) {
            configBuilder.setTrustStore(opts, trustStore);
        }
        if ((keyStorePassword = options.get(KS_PASSWD)) != null) {
            configBuilder.setKeyStorePW(opts, keyStorePassword);
        }
        if ((trustStorePassword = options.get(TS_PASSWD)) != null) {
            configBuilder.setTrustStorePW(opts, trustStorePassword);
        }
        if ((keyPassword = options.get(KEY_PASSWD)) != null) {
            configBuilder.setKeyPW(opts, keyPassword);
        }
        if (options.get("filetype") != null) {
            delegate.setConfigString(opts, options.get("VFS_SCHEME"), "filetype", options.get("filetype"));
        }
        return opts;
    }

    public static String resolveUriHost(String uri) throws FileSystemException, UnknownHostException {
        return VFSUtils.resolveUriHost(uri, new StringBuilder());
    }

    public static String resolveUriHost(String uri, StringBuilder strBuilder) throws FileSystemException, UnknownHostException {
        String scheme;
        if (uri != null && strBuilder != null && (scheme = UriParser.extractScheme((String)uri, (StringBuilder)strBuilder)) != null && scheme.equals("smb")) {
            if (strBuilder.length() < 2 || strBuilder.charAt(0) != '/' || strBuilder.charAt(1) != '/') {
                throw new FileSystemException("vfs.provider/missing-double-slashes.error", (Object)uri);
            }
            strBuilder.delete(0, 2);
            String userInfo = VFSUtils.extractUserInfo(strBuilder);
            String hostName = VFSUtils.extractHostName(strBuilder);
            InetAddress hostAddress = InetAddress.getByName(hostName);
            String resolvedHostAddress = hostAddress.getHostAddress();
            StringBuilder uriStrBuilder = new StringBuilder();
            uriStrBuilder.append(scheme).append("://");
            if (userInfo != null) {
                uriStrBuilder.append(userInfo).append("@");
            }
            uriStrBuilder.append(resolvedHostAddress).append((CharSequence)strBuilder);
            return uriStrBuilder.toString();
        }
        return uri;
    }

    private static String extractHostName(StringBuilder name) {
        char ch;
        int pos;
        int maxlen = name.length();
        for (pos = 0; pos < maxlen && (ch = name.charAt(pos)) != '/' && ch != ';' && ch != '?' && ch != ':' && ch != '@' && ch != '&' && ch != '=' && ch != '+' && ch != '$' && ch != ','; ++pos) {
        }
        if (pos == 0) {
            return null;
        }
        String hostname = name.substring(0, pos);
        name.delete(0, pos);
        return hostname;
    }

    private static String extractUserInfo(StringBuilder name) {
        int maxlen = name.length();
        for (int pos = 0; pos < maxlen; ++pos) {
            char ch = name.charAt(pos);
            if (ch == '@') {
                String userInfo = name.substring(0, pos);
                name.delete(0, pos + 1);
                return userInfo;
            }
            if (ch == '/' || ch == '?') break;
        }
        return null;
    }

    private static Integer getFileType(String fileType) {
        if ("ASCII".equals(fileType = fileType.toUpperCase())) {
            return 0;
        }
        if ("BINARY".equals(fileType)) {
            return 2;
        }
        if ("EBCDIC".equals(fileType)) {
            return 1;
        }
        if ("LOCAL".equals(fileType)) {
            return 3;
        }
        return 2;
    }
}

