/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.vfs;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.provider.UriParser;

public class VFSOutTransportInfo
implements OutTransportInfo {
    private static final Log log = LogFactory.getLog(VFSOutTransportInfo.class);
    private String outFileURI = null;
    private String outFileName = null;
    private String contentType = null;
    private int maxRetryCount = 3;
    private long reconnectTimeout = 30000L;
    private boolean append;
    private boolean fileLocking;
    private Map<String, String> fso = null;
    private boolean sendFileSynchronously = false;
    private boolean forceCreateFolder = false;
    private static final String[] uriParamsToDelete = new String[]{"transport.vfs.Append=true", "transport.vfs.Append=false"};

    public VFSOutTransportInfo(String outFileURI, boolean fileLocking) {
        String strForceCreateFolder;
        String vfsURI;
        String queryParams;
        this.outFileURI = outFileURI.startsWith("vfs:") ? (null != (queryParams = UriParser.extractQueryString((StringBuilder)new StringBuilder(vfsURI = outFileURI.substring("vfs:".length())))) && !"".equals(queryParams) && vfsURI.contains("transport.vfs.Append") ? this.cleanURI(vfsURI, queryParams, outFileURI) : vfsURI) : outFileURI;
        Hashtable properties = BaseUtils.getEPRProperties((String)outFileURI);
        String scheme = UriParser.extractScheme((String)this.outFileURI);
        properties.put("VFS_SCHEME", scheme);
        this.setOutFileSystemOptionsMap(properties);
        if (properties.containsKey("transport.vfs.SubFolderTimestampFormat")) {
            String strSubfolderFormat = (String)properties.get("transport.vfs.SubFolderTimestampFormat");
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(strSubfolderFormat);
                String strDateformat = sdf.format(new Date());
                int iIndex = this.outFileURI.indexOf("?");
                this.outFileURI = iIndex > -1 ? this.outFileURI.substring(0, iIndex) + strDateformat + this.outFileURI.substring(iIndex, this.outFileURI.length()) : this.outFileURI + strDateformat;
            }
            catch (Exception e) {
                log.warn((Object)"Error generating subfolder name with date", (Throwable)e);
            }
        }
        if (properties.containsKey("transport.vfs.MaxRetryCount")) {
            String strMaxRetryCount = (String)properties.get("transport.vfs.MaxRetryCount");
            this.maxRetryCount = Integer.parseInt(strMaxRetryCount);
        } else {
            this.maxRetryCount = 3;
        }
        this.forceCreateFolder = false;
        if (properties.containsKey("transport.vfs.CreateFolder") && (strForceCreateFolder = (String)properties.get("transport.vfs.CreateFolder")) != null && strForceCreateFolder.toLowerCase().equals("true")) {
            this.forceCreateFolder = true;
        }
        if (properties.containsKey("transport.vfs.ReconnectTimeout")) {
            String strReconnectTimeout = (String)properties.get("transport.vfs.ReconnectTimeout");
            this.reconnectTimeout = Long.parseLong(strReconnectTimeout) * 1000L;
        } else {
            this.reconnectTimeout = 30000L;
        }
        if (properties.containsKey("transport.vfs.Locking")) {
            String strFileLocking = (String)properties.get("transport.vfs.Locking");
            if ("enable".equals(strFileLocking)) {
                this.fileLocking = true;
            } else if ("disable".equals(strFileLocking)) {
                this.fileLocking = false;
            }
        } else {
            this.fileLocking = fileLocking;
        }
        if (properties.containsKey("transport.vfs.SendFileSynchronously")) {
            String strSendLocking = (String)properties.get("transport.vfs.SendFileSynchronously");
            this.sendFileSynchronously = Boolean.parseBoolean(strSendLocking);
        } else {
            this.sendFileSynchronously = false;
        }
        if (properties.containsKey("transport.vfs.Append")) {
            String strAppend = (String)properties.get("transport.vfs.Append");
            this.append = Boolean.parseBoolean(strAppend);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using the fileURI        : " + this.outFileURI));
            log.debug((Object)("Using the maxRetryCount  : " + this.maxRetryCount));
            log.debug((Object)("Using the reconnectionTimeout : " + this.reconnectTimeout));
            log.debug((Object)("Using the append         : " + this.append));
            log.debug((Object)("File locking             : " + (this.fileLocking ? "ON" : "OFF")));
        }
    }

    private String cleanURI(String vfsURI, String queryParams, String originalFileURI) {
        vfsURI = StringUtils.replace((String)vfsURI, (String)("?" + queryParams), (String)"");
        for (String deleteParam : uriParamsToDelete) {
            queryParams = StringUtils.replace((String)queryParams, (String)deleteParam, (String)"");
        }
        if (!"".equals(queryParams = StringUtils.replace((String)queryParams, (String)"&&", (String)"&")) && queryParams.toCharArray()[0] == "&".charAt(0)) {
            queryParams = queryParams.substring(1);
        } else if ("".equals(queryParams)) {
            return vfsURI;
        }
        String[] queryParamsArray = queryParams.split("&");
        StringBuilder newQueryParams = new StringBuilder("");
        if (queryParamsArray.length > 0) {
            for (String param : queryParamsArray) {
                newQueryParams.append(param);
                newQueryParams.append("&");
            }
            if (!"".equals(newQueryParams = newQueryParams.deleteCharAt(newQueryParams.length() - 1))) {
                return vfsURI + "?" + newQueryParams;
            }
            return vfsURI;
        }
        return originalFileURI.substring("vfs:".length());
    }

    public boolean isForceCreateFolder(MessageContext msgCtx) {
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (transportHeaders != null && "true".equals((String)transportHeaders.get("transport.vfs.CreateFolder"))) {
            return true;
        }
        return this.isForceCreateFolder();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getOutFileURI() {
        return this.outFileURI;
    }

    public boolean getSendFileSynchronously() {
        return this.sendFileSynchronously;
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public void setReconnectTimeout(long reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isFileLockingEnabled() {
        return this.fileLocking;
    }

    public Map<String, String> getOutFileSystemOptionsMap() {
        return this.fso;
    }

    private void setOutFileSystemOptionsMap(Map<String, String> fso) {
        HashMap<String, String> options = new HashMap<String, String>();
        if ("sftp".equals(fso.get("VFS_SCHEME"))) {
            for (String key : fso.keySet()) {
                options.put(key.replaceAll("transport.vfs.SFTP", ""), fso.get(key));
            }
        }
        if ("ftp".equals(fso.get("VFS_SCHEME")) || "ftps".equals(fso.get("VFS_SCHEME"))) {
            options.putAll(fso);
            String fileType = fso.remove("transport.vfs.fileType");
            if (fileType != null) {
                options.put("filetype", fileType);
            }
        }
        this.fso = options;
    }

    public boolean isForceCreateFolder() {
        return this.forceCreateFolder;
    }

    public void setForceCreateFolder(boolean forceCreateFolder) {
        this.forceCreateFolder = forceCreateFolder;
    }
}

